/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.PortSide;

public final class SelfLoopOpposingSegment {
    private SelfLoopComponent component;
    private final PortSide side;
    private int level;
    private double labelOffset;
    private SelfLoopPort levelGivingPort;

    private SelfLoopOpposingSegment(SelfLoopComponent component, PortSide side) {
        this.component = component;
        this.side = side;
    }

    private SelfLoopOpposingSegment(SelfLoopComponent component, PortSide currentPortSide, SelfLoopPort port) {
        this.component = component;
        this.side = currentPortSide;
        this.levelGivingPort = port;
    }

    public static Map<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>> create(SelfLoopComponent component, SelfLoopNode nodeRep) {
        Map<Object, Object> segments = new HashMap();
        segments = SelfLoopOpposingSegment.supportsHyperedges(nodeRep) ? SelfLoopOpposingSegment.createHyperEdgeSegments(component) : SelfLoopOpposingSegment.createNonHyperEdgeSegments(component, nodeRep);
        return segments;
    }

    private static Map<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>> createHyperEdgeSegments(SelfLoopComponent component) {
        Map<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>> segments = SelfLoopOpposingSegment.initSegmentMap();
        HashSet<PortSide> sides = new HashSet<PortSide>(component.getComponentSpanningSides());
        List<SelfLoopPort> ports = component.getPorts();
        sides.remove(ports.get(0).getPortSide());
        sides.remove(ports.get(ports.size() - 1).getPortSide());
        for (PortSide side : sides) {
            List<SelfLoopPort> portsOfSide = component.getPortsOfSide(side);
            SelfLoopOpposingSegment segment = portsOfSide != null && !portsOfSide.isEmpty() ? new SelfLoopOpposingSegment(component, side, portsOfSide.get(0)) : new SelfLoopOpposingSegment(component, side);
            Map<SelfLoopEdge, SelfLoopOpposingSegment> sideSegments = segments.get(side);
            for (SelfLoopEdge edge : component.getConnectedEdges()) {
                sideSegments.put(edge, segment);
            }
        }
        return segments;
    }

    private static Map<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>> createNonHyperEdgeSegments(SelfLoopComponent component, SelfLoopNode nodeRep) {
        Map<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>> segments = SelfLoopOpposingSegment.initSegmentMap();
        SelfLoopOpposingSegment.rotatePortsToBeRightPointing(component);
        HashMap<LPort, SelfLoopEdge> startedEdges = new HashMap<LPort, SelfLoopEdge>();
        List<SelfLoopPort> ports = component.getPorts();
        HashSet<SelfLoopEdge> visitedEdges = new HashSet<SelfLoopEdge>();
        if (ports.size() > 1) {
            SelfLoopPort startPort = ports.get(0);
            PortSide startSide = startPort.getPortSide();
            SelfLoopOpposingSegment.updateConnectedEdges(startedEdges, startPort, visitedEdges);
            List<SelfLoopPort> sidePorts = component.getPortsOfSide(startSide);
            SelfLoopNodeSide nodeSide = nodeRep.getNodeSide(startSide);
            sidePorts.sort((port1, port2) -> Integer.compare(nodeSide.getPorts().indexOf(port1), nodeSide.getPorts().indexOf(port2)));
            int startIndex = sidePorts.indexOf(startPort);
            sidePorts = sidePorts.size() > 1 && startIndex < sidePorts.size() ? sidePorts.subList(startIndex + 1, sidePorts.size()) : new ArrayList<SelfLoopPort>();
            int i = 0;
            while (i < nodeRep.getSides().size()) {
                HashMap<LPort, SelfLoopEdge> startedEdges2 = new HashMap<LPort, SelfLoopEdge>();
                for (SelfLoopPort port : sidePorts) {
                    startedEdges.remove((Object)port.getLPort());
                    SelfLoopOpposingSegment.updateConnectedEdges(startedEdges2, port, visitedEdges);
                }
                if (i != 0) {
                    for (SelfLoopEdge startedEdge : startedEdges.values()) {
                        SelfLoopOpposingSegment segment = new SelfLoopOpposingSegment(component, startSide);
                        Map<SelfLoopEdge, SelfLoopOpposingSegment> sideSegment = segments.get(startSide);
                        sideSegment.put(startedEdge, segment);
                    }
                }
                startedEdges.putAll(startedEdges2);
                startSide = startSide.right();
                sidePorts = component.getPortsOfSide(startSide);
                ++i;
            }
        }
        return segments;
    }

    public SelfLoopComponent getComponent() {
        return this.component;
    }

    public void setComponent(SelfLoopComponent component) {
        this.component = component;
    }

    public PortSide getSide() {
        return this.side;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public double getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(double labelOffset) {
        this.labelOffset = labelOffset;
    }

    public SelfLoopPort getLevelGivingPort() {
        return this.levelGivingPort;
    }

    public void setLevelGivingPort(SelfLoopPort levelGivingPort) {
        this.levelGivingPort = levelGivingPort;
    }

    private static boolean supportsHyperedges(SelfLoopNode nodeRep) {
        return nodeRep.getNode().getGraph().getProperty(LayeredOptions.EDGE_ROUTING) != EdgeRouting.SPLINES;
    }

    private static Map<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>> initSegmentMap() {
        EnumMap<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>> segments = new EnumMap<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>>(PortSide.class);
        segments.put(PortSide.NORTH, new HashMap());
        segments.put(PortSide.EAST, new HashMap());
        segments.put(PortSide.SOUTH, new HashMap());
        segments.put(PortSide.WEST, new HashMap());
        return segments;
    }

    private static void rotatePortsToBeRightPointing(SelfLoopComponent component) {
        List<SelfLoopPort> ports = component.getPorts();
        SelfLoopPort currPort = ports.get(0);
        while (currPort.getDirection() != SelfLoopRoutingDirection.RIGHT) {
            SelfLoopPort removedPort = ports.remove(0);
            ports.add(removedPort);
            currPort = ports.get(0);
        }
    }

    private static void updateConnectedEdges(Map<LPort, SelfLoopEdge> startedEdges, SelfLoopPort port, Set<SelfLoopEdge> visitedEdges) {
        List<SelfLoopEdge> connectedEdges = port.getConnectedEdges();
        for (SelfLoopEdge edge : connectedEdges) {
            if (visitedEdges.contains(edge)) continue;
            visitedEdges.add(edge);
            if (edge.getTarget() == port) {
                startedEdges.put(edge.getSource().getLPort(), edge);
                continue;
            }
            startedEdges.put(edge.getTarget().getLPort(), edge);
        }
    }

    public String toString() {
        return this.side.toString();
    }
}

