/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.labeling;

import java.util.List;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabel;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabelPosition;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.labeling.AbstractSelfLoopLabelPositionGenerator;
import org.eclipse.elk.alg.layered.p5edges.loops.util.SelfLoopBendpointCalculationUtil;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.math.KVector;

public class CornerLoopLabelPositionGenerator
extends AbstractSelfLoopLabelPositionGenerator {
    public CornerLoopLabelPositionGenerator(SelfLoopNode slNode) {
        super(slNode);
    }

    @Override
    public void generatePositions(SelfLoopComponent component) {
        List<SelfLoopPort> ports = component.getPorts();
        SelfLoopPort startPort = ports.get(0);
        SelfLoopPort endPort = ports.get(ports.size() - 1);
        double edgeEdgeSpacing = this.getEdgeEdgeSpacing();
        double edgeLabelSpacing = this.getEdgeLabelSpacing();
        KVector startPosition = startPort.getLPort().getPosition().clone().add(startPort.getLPort().getAnchor());
        KVector endPosition = endPort.getLPort().getPosition().clone().add(endPort.getLPort().getAnchor());
        double directionStart = SplinesMath.portSideToDirection(startPort.getPortSide());
        KVector dirVectorStart = new KVector(directionStart);
        double directionEnd = SplinesMath.portSideToDirection(endPort.getPortSide());
        KVector dirVectorEnd = new KVector(directionEnd);
        KVector firstBend = startPosition.clone().add(dirVectorStart.clone().scale((double)startPort.getMaximumLevel() * edgeEdgeSpacing + edgeLabelSpacing));
        KVector secondBend = endPosition.clone().add(dirVectorEnd.clone().scale((double)endPort.getMaximumLevel() * edgeEdgeSpacing + edgeLabelSpacing));
        KVector cornerBend = SelfLoopBendpointCalculationUtil.calculateCornerBendPoint(firstBend, startPort.getPortSide(), secondBend, endPort.getPortSide());
        SelfLoopLabel label = component.getSelfLoopLabel();
        List<SelfLoopLabelPosition> positions = label.getCandidatePositions();
        positions.add(this.shortSegmentPosition(label, startPort, firstBend, cornerBend, AbstractSelfLoopLabelPositionGenerator.Alignment.CENTERED, false));
        positions.add(this.shortSegmentPosition(label, startPort, firstBend, cornerBend, AbstractSelfLoopLabelPositionGenerator.Alignment.LEFT_OR_TOP, false));
        positions.add(this.shortSegmentPosition(label, startPort, firstBend, cornerBend, AbstractSelfLoopLabelPositionGenerator.Alignment.RIGHT_OR_BOTTOM, false));
        positions.add(this.shortSegmentPosition(label, endPort, secondBend, cornerBend, AbstractSelfLoopLabelPositionGenerator.Alignment.CENTERED, false));
        positions.add(this.shortSegmentPosition(label, endPort, secondBend, cornerBend, AbstractSelfLoopLabelPositionGenerator.Alignment.LEFT_OR_TOP, false));
        positions.add(this.shortSegmentPosition(label, endPort, secondBend, cornerBend, AbstractSelfLoopLabelPositionGenerator.Alignment.RIGHT_OR_BOTTOM, false));
    }
}

