/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.layouter;

import java.util.EnumSet;
import org.eclipse.elk.alg.graphviz.dot.transform.NeatoModel;
import org.eclipse.elk.alg.graphviz.dot.transform.OverlapMode;
import org.eclipse.elk.alg.graphviz.layouter.GraphvizLayoutProvider;
import org.eclipse.elk.alg.graphviz.layouter.GraphvizMetaDataProvider;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.GraphFeature;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class NeatoOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.graphviz.neato";
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(10.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 40.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property(CoreOptions.SPACING_NODE_NODE, (Object)40.0);
    public static final IProperty<Double> SPACING_EDGE_LABEL = CoreOptions.SPACING_EDGE_LABEL;
    public static final IProperty<EnumSet<SizeConstraint>> NODE_SIZE_CONSTRAINTS = CoreOptions.NODE_SIZE_CONSTRAINTS;
    public static final IProperty<EnumSet<SizeOptions>> NODE_SIZE_OPTIONS = CoreOptions.NODE_SIZE_OPTIONS;
    private static final int RANDOM_SEED_DEFAULT = 1;
    public static final IProperty<Integer> RANDOM_SEED = new Property(CoreOptions.RANDOM_SEED, (Object)1);
    public static final IProperty<Boolean> INTERACTIVE = CoreOptions.INTERACTIVE;
    private static final EdgeRouting EDGE_ROUTING_DEFAULT = EdgeRouting.SPLINES;
    public static final IProperty<EdgeRouting> EDGE_ROUTING = new Property(CoreOptions.EDGE_ROUTING, (Object)EDGE_ROUTING_DEFAULT);
    public static final IProperty<Boolean> DEBUG_MODE = CoreOptions.DEBUG_MODE;
    private static final boolean SEPARATE_CONNECTED_COMPONENTS_DEFAULT = false;
    public static final IProperty<Boolean> SEPARATE_CONNECTED_COMPONENTS = new Property(CoreOptions.SEPARATE_CONNECTED_COMPONENTS, (Object)false);
    public static final IProperty<Boolean> CONCENTRATE = GraphvizMetaDataProvider.CONCENTRATE;
    private static final double EPSILON_DEFAULT = (double)1.0E-4f;
    public static final IProperty<Double> EPSILON = new Property(GraphvizMetaDataProvider.EPSILON, (Object)1.0E-4f);
    public static final IProperty<Double> LABEL_DISTANCE = GraphvizMetaDataProvider.LABEL_DISTANCE;
    public static final IProperty<Double> LABEL_ANGLE = GraphvizMetaDataProvider.LABEL_ANGLE;
    private static final int MAXITER_DEFAULT = 200;
    public static final IProperty<Integer> MAXITER = new Property(GraphvizMetaDataProvider.MAXITER, (Object)200);
    public static final IProperty<NeatoModel> NEATO_MODEL = GraphvizMetaDataProvider.NEATO_MODEL;
    public static final IProperty<OverlapMode> OVERLAP_MODE = GraphvizMetaDataProvider.OVERLAP_MODE;
    public static final IProperty<Boolean> ADAPT_PORT_POSITIONS = GraphvizMetaDataProvider.ADAPT_PORT_POSITIONS;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("Neato").description("Spring model layouts. Neato attempts to minimize a global energy function, which is equivalent to statistical multi-dimensional scaling. The solution is achieved using stress majorization, though the older Kamada-Kawai algorithm, using steepest descent, is also available.").providerFactory((IFactory)new NeatoFactory()).category("org.eclipse.elk.force").melkBundleName("Graphviz").definingBundleId("org.eclipse.elk.alg.graphviz.layouter").imagePath("images/neato_layout.png").supportedFeatures(EnumSet.of(GraphFeature.SELF_LOOPS, GraphFeature.MULTI_EDGES, GraphFeature.EDGE_LABELS)).create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", (Object)PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", (Object)40.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.edgeLabel", SPACING_EDGE_LABEL.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.constraints", NODE_SIZE_CONSTRAINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.options", NODE_SIZE_OPTIONS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.randomSeed", (Object)1);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.interactive", INTERACTIVE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.edgeRouting", (Object)EDGE_ROUTING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.debugMode", DEBUG_MODE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.separateConnectedComponents", (Object)false);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.concentrate", CONCENTRATE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.epsilon", (Object)1.0E-4f);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.labelDistance", LABEL_DISTANCE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.labelAngle", LABEL_ANGLE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.maxiter", (Object)200);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.neatoModel", NEATO_MODEL.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.overlapMode", OVERLAP_MODE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.graphviz.adaptPortPositions", ADAPT_PORT_POSITIONS.getDefault());
    }

    public static class NeatoFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            GraphvizLayoutProvider provider = new GraphvizLayoutProvider();
            provider.initialize("NEATO");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

