/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.grandom.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.elk.core.debug.grandom.gRandom.Configuration;
import org.eclipse.elk.core.debug.grandom.gRandom.ConstraintType;
import org.eclipse.elk.core.debug.grandom.gRandom.DoubleQuantity;
import org.eclipse.elk.core.debug.grandom.gRandom.Edges;
import org.eclipse.elk.core.debug.grandom.gRandom.Flow;
import org.eclipse.elk.core.debug.grandom.gRandom.FlowType;
import org.eclipse.elk.core.debug.grandom.gRandom.Form;
import org.eclipse.elk.core.debug.grandom.gRandom.Formats;
import org.eclipse.elk.core.debug.grandom.gRandom.Hierarchy;
import org.eclipse.elk.core.debug.grandom.gRandom.Nodes;
import org.eclipse.elk.core.debug.grandom.gRandom.Ports;
import org.eclipse.elk.core.debug.grandom.gRandom.RandGraph;
import org.eclipse.elk.core.debug.grandom.gRandom.Side;
import org.eclipse.elk.core.debug.grandom.gRandom.Size;
import org.eclipse.elk.core.debug.grandom.generators.GeneratorOptions;
import org.eclipse.elk.core.debug.grandom.generators.RandomGraphGenerator;
import org.eclipse.elk.core.debug.grandom.ui.GeneratorOptionsUtil;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.MapPropertyHolder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

public class GRandomGraphMaker {
    private final Iterable<Configuration> configs;
    private final int DEFAULT_NUM_GRAPHS = 1;
    private final String DEFAULT_NAME = "random";
    private final String DEFAULT_FORMAT = Formats.ELKT.toString();

    public GRandomGraphMaker(RandGraph rdg) {
        this.configs = rdg.getConfigs();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void gen(IProject project) {
        try {
            for (Configuration config : this.configs) {
                _xifexpression = null;
                _exists = this.exists(config.getFilename());
                _xifexpression = _exists != false ? config.getFilename() : "random";
                filename = _xifexpression;
                _xifexpression_1 /* !! */  = null;
                _exists_1 = this.exists(config.getFormat());
                _xifexpression_1 /* !! */  = _exists_1 != false ? config.getFormat() : this.DEFAULT_FORMAT;
                format /* !! */  = _xifexpression_1 /* !! */ ;
                graphs = this.genElkNode(config);
                fileNum = 0;
                i = 0;
                ** GOTO lbl21
                {
                    ++fileNum;
                    do {
                        if (project.getFile(String.valueOf(filename) + Integer.valueOf(fileNum) + "." + format /* !! */ ).exists()) continue block3;
                        f = project.getFile(String.valueOf(filename) + Integer.valueOf(fileNum) + "." + format /* !! */ );
                        this.serialize(graphs.get(i), f);
                        ++i;
lbl21:
                        // 2 sources

                    } while (i < graphs.size());
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public List<ElkNode> loadGraph() {
        ArrayList<ElkNode> graphs = new ArrayList<ElkNode>();
        for (Configuration config : this.configs) {
            graphs.addAll(this.genElkNode(config));
        }
        return graphs;
    }

    public List<ElkNode> genElkNode(Configuration config) {
        ArrayList<ElkNode> generated = new ArrayList<ElkNode>();
        int samples = config.getSamples();
        int _xifexpression = 0;
        boolean _exists = this.exists(samples);
        _xifexpression = _exists ? samples : 1;
        int nGraphs = _xifexpression;
        Random r = this.random(config);
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, nGraphs, true);
        for (Integer i : _doubleDotLessThan) {
            GeneratorOptions options = this.parseGenOptions(config, r);
            ElkNode n = new RandomGraphGenerator(r).generate(options);
            generated.add(n);
        }
        return generated;
    }

    public GeneratorOptions parseGenOptions(Configuration config, Random r) {
        GeneratorOptions _xblockexpression = null;
        GeneratorOptions genOpt = new GeneratorOptions();
        boolean _exists = this.exists(GeneratorOptionsUtil.getPreferenceStore());
        if (_exists) {
            GeneratorOptionsUtil.loadPreferences((MapPropertyHolder)genOpt);
        }
        this.setGraphType(config, genOpt);
        this.nodes(config.getNodes(), r, genOpt);
        this.edges(config, genOpt, r);
        this.hierarchy(config, genOpt, r);
        this.setQuantities(genOpt, config.getFraction(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.PARTITION_FRAC);
        this.setIfExists(genOpt, config.getMaxWidth(), GeneratorOptions.MAX_WIDTH);
        this.setIfExists(genOpt, config.getMaxDegree(), GeneratorOptions.MAX_DEGREE);
        _xblockexpression = genOpt;
        return _xblockexpression;
    }

    public MapPropertyHolder hierarchy(Configuration configuration, GeneratorOptions options, Random random) {
        MapPropertyHolder _xblockexpression = null;
        Hierarchy hierarchy = configuration.getHierarchy();
        MapPropertyHolder _xifexpression = null;
        boolean _exists = this.exists(hierarchy);
        if (_exists) {
            MapPropertyHolder _xblockexpression_1 = null;
            DoubleQuantity hierarch = hierarchy.getNumHierarchNodes();
            this.setQuantities(options, hierarchy.getCrossHierarchRel(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.EXACT_RELATIVE_HIER);
            options.setProperty(GeneratorOptions.SMALL_HIERARCHY, (Object)this.exists(hierarch));
            this.setQuantities(options, hierarchy.getLevels(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.MAX_HIERARCHY_LEVEL);
            this.setQuantities(options, hierarch, (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.NUMBER_HIERARCHICAL_NODES);
            _xifexpression = _xblockexpression_1 = this.setQuantities(options, hierarchy.getEdges(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.CROSS_HIER);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private Random random(Configuration g) {
        Integer seed = g.getSeed();
        if (seed == null) {
            return new Random();
        }
        return new Random(seed.intValue());
    }

    private MapPropertyHolder edges(Configuration config, GeneratorOptions genOpt, Random r) {
        MapPropertyHolder _xblockexpression = null;
        Edges edges = config.getEdges();
        MapPropertyHolder _xifexpression = null;
        boolean _exists = this.exists(edges);
        if (_exists) {
            MapPropertyHolder _xblockexpression_1 = null;
            boolean _isTotal = edges.isTotal();
            if (_isTotal) {
                genOpt.setProperty(GeneratorOptions.EDGE_DETERMINATION, (Object)GeneratorOptions.EdgeDetermination.ABSOLUTE);
                this.setQuantities(genOpt, edges.getNEdges(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.EDGES_ABSOLUTE);
            } else {
                boolean _isDensity = edges.isDensity();
                if (_isDensity) {
                    this.setQuantities(genOpt, edges.getNEdges(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.DENSITY);
                    genOpt.setProperty(GeneratorOptions.EDGE_DETERMINATION, (Object)GeneratorOptions.EdgeDetermination.DENSITY);
                } else {
                    boolean _isRelative = edges.isRelative();
                    if (_isRelative) {
                        genOpt.setProperty(GeneratorOptions.EDGE_DETERMINATION, (Object)GeneratorOptions.EdgeDetermination.RELATIVE);
                        this.setQuantities(genOpt, edges.getNEdges(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.RELATIVE_EDGES);
                    } else {
                        genOpt.setProperty(GeneratorOptions.EDGE_DETERMINATION, (Object)GeneratorOptions.EdgeDetermination.OUTGOING);
                        this.setQuantities(genOpt, edges.getNEdges(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.OUTGOING_EDGES);
                    }
                }
            }
            genOpt.setProperty((IProperty)GeneratorOptions.EDGE_LABELS, (Object)edges.isLabels());
            _xifexpression = _xblockexpression_1 = genOpt.setProperty(GeneratorOptions.SELF_LOOPS, (Object)edges.isSelfLoops());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private MapPropertyHolder nodes(Nodes nodes, Random r, GeneratorOptions genOpt) {
        MapPropertyHolder _xifexpression = null;
        boolean _exists = this.exists(nodes);
        if (_exists) {
            MapPropertyHolder _xblockexpression = null;
            this.setQuantities(genOpt, nodes.getNNodes(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.NUMBER_OF_NODES);
            genOpt.setProperty(GeneratorOptions.CREATE_NODE_LABELS, (Object)nodes.isLabels());
            this.ports(nodes, genOpt, r);
            this.size(nodes, r, genOpt);
            boolean _isRemoveIsolated = nodes.isRemoveIsolated();
            boolean _not = !_isRemoveIsolated;
            _xifexpression = _xblockexpression = genOpt.setProperty(GeneratorOptions.ISOLATED_NODES, (Object)_not);
        }
        return _xifexpression;
    }

    private MapPropertyHolder size(Nodes nodes, Random r, GeneratorOptions genOpt) {
        MapPropertyHolder _xblockexpression = null;
        Size size = nodes.getSize();
        MapPropertyHolder _xifexpression = null;
        boolean _exists = this.exists(size);
        if (_exists) {
            MapPropertyHolder _xblockexpression_1 = null;
            this.setQuantities(genOpt, size.getWidth(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.NODE_WIDTH);
            _xifexpression = _xblockexpression_1 = this.setQuantities(genOpt, size.getHeight(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.NODE_HEIGHT);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private MapPropertyHolder ports(Nodes nodes, GeneratorOptions genOpt, Random r) {
        MapPropertyHolder _xblockexpression = null;
        Ports ports = nodes.getPorts();
        MapPropertyHolder _xifexpression = null;
        boolean _exists = this.exists(ports);
        if (_exists) {
            MapPropertyHolder _xblockexpression_1 = null;
            genOpt.setProperty(GeneratorOptions.ENABLE_PORTS, (Object)true);
            genOpt.setProperty(GeneratorOptions.CREATE_PORT_LABELS, (Object)ports.isLabels());
            genOpt.setProperty(GeneratorOptions.PORT_CONSTRAINTS, (Object)this.getConstraint(ports.getConstraint()));
            this.setQuantities(genOpt, ports.getReUse(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.USE_EXISTING_PORTS_CHANCE);
            EList flows = ports.getFlow();
            boolean _exists_1 = this.exists(flows);
            if (_exists_1) {
                for (Flow f : flows) {
                    this.setFlowSide(genOpt, f.getFlowType(), f.getSide(), f.getAmount(), r);
                }
            }
            Size size = ports.getSize();
            genOpt.setProperty(GeneratorOptions.SET_PORT_SIZE, (Object)true);
            MapPropertyHolder _xifexpression_1 = null;
            boolean _exists_2 = this.exists(size);
            if (_exists_2) {
                MapPropertyHolder _xblockexpression_2 = null;
                this.setQuantities(genOpt, size.getHeight(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.PORT_HEIGHT);
                _xifexpression_1 = _xblockexpression_2 = this.setQuantities(genOpt, size.getWidth(), (IProperty<GeneratorOptions.RandVal>)GeneratorOptions.PORT_WIDTH);
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private MapPropertyHolder setQuantities(GeneratorOptions genOpt, DoubleQuantity quant, IProperty<GeneratorOptions.RandVal> randomValue) {
        MapPropertyHolder _xifexpression = null;
        boolean _exists = this.exists(quant);
        if (_exists) {
            _xifexpression = genOpt.setProperty(randomValue, (Object)this.toRandVal(quant));
        }
        return _xifexpression;
    }

    public GeneratorOptions.RandVal toRandVal(DoubleQuantity quant) {
        GeneratorOptions.RandVal _xifexpression = null;
        boolean _isMinMax = quant.isMinMax();
        if (_isMinMax) {
            _xifexpression = GeneratorOptions.RandVal.minMax((double)quant.getMin(), (double)quant.getMax());
        } else {
            GeneratorOptions.RandVal _xifexpression_1 = null;
            boolean _isGaussian = quant.isGaussian();
            _xifexpression_1 = _isGaussian ? GeneratorOptions.RandVal.gaussian((double)quant.getMean(), (double)quant.getStddv()) : GeneratorOptions.RandVal.exact((double)quant.getQuant());
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private MapPropertyHolder setFlowSide(GeneratorOptions options, FlowType type, Side side, DoubleQuantity quant, Random r) {
        MapPropertyHolder _xblockexpression = null;
        int amount = this.toRandVal(quant).intVal(r);
        MapPropertyHolder _switchResult = null;
        if (type != null) {
            switch (type) {
                case INCOMING: {
                    MapPropertyHolder _switchResult_1 = null;
                    if (side != null) {
                        switch (side) {
                            case EAST: {
                                _switchResult_1 = options.setProperty(GeneratorOptions.INCOMING_EAST_SIDE, (Object)amount);
                                break;
                            }
                            case NORTH: {
                                _switchResult_1 = options.setProperty(GeneratorOptions.INCOMING_NORTH_SIDE, (Object)amount);
                                break;
                            }
                            case SOUTH: {
                                _switchResult_1 = options.setProperty(GeneratorOptions.INCOMING_SOUTH_SIDE, (Object)amount);
                                break;
                            }
                            case WEST: {
                                _switchResult_1 = options.setProperty(GeneratorOptions.INCOMING_WEST_SIDE, (Object)amount);
                                break;
                            }
                        }
                    }
                    _switchResult = _switchResult_1;
                    break;
                }
                case OUTGOING: {
                    MapPropertyHolder _switchResult_2 = null;
                    if (side != null) {
                        switch (side) {
                            case EAST: {
                                _switchResult_2 = options.setProperty(GeneratorOptions.OUTGOING_EAST_SIDE, (Object)amount);
                                break;
                            }
                            case NORTH: {
                                _switchResult_2 = options.setProperty(GeneratorOptions.OUTGOING_NORTH_SIDE, (Object)amount);
                                break;
                            }
                            case SOUTH: {
                                _switchResult_2 = options.setProperty(GeneratorOptions.OUTGOING_SOUTH_SIDE, (Object)amount);
                                break;
                            }
                            case WEST: {
                                _switchResult_2 = options.setProperty(GeneratorOptions.OUTGOING_WEST_SIDE, (Object)amount);
                                break;
                            }
                        }
                    }
                    _switchResult = _switchResult_2;
                    break;
                }
            }
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private PortConstraints getConstraint(ConstraintType constraint) {
        if (constraint != null) {
            switch (constraint) {
                case FREE: {
                    return PortConstraints.FREE;
                }
                case ORDER: {
                    return PortConstraints.FIXED_ORDER;
                }
                case POSITION: {
                    return PortConstraints.FIXED_POS;
                }
                case SIDE: {
                    return PortConstraints.FIXED_SIDE;
                }
                case RATIO: {
                    return PortConstraints.FIXED_RATIO;
                }
            }
        }
        return PortConstraints.UNDEFINED;
    }

    private void setGraphType(Configuration configuration, GeneratorOptions options) {
        Form _form = configuration.getForm();
        if (_form != null) {
            switch (_form) {
                case ACYCLIC: {
                    options.setProperty(GeneratorOptions.GRAPH_TYPE, (Object)GeneratorOptions.GraphType.ACYCLIC_NO_TRANSITIVE_EDGES);
                    break;
                }
                case BICONNECTED: {
                    options.setProperty(GeneratorOptions.GRAPH_TYPE, (Object)GeneratorOptions.GraphType.BICONNECTED);
                    break;
                }
                case BIPARTITE: {
                    options.setProperty(GeneratorOptions.GRAPH_TYPE, (Object)GeneratorOptions.GraphType.BIPARTITE);
                    break;
                }
                case CUSTOM: {
                    options.setProperty(GeneratorOptions.GRAPH_TYPE, (Object)GeneratorOptions.GraphType.CUSTOM);
                    break;
                }
                case TREES: {
                    options.setProperty(GeneratorOptions.GRAPH_TYPE, (Object)GeneratorOptions.GraphType.TREE);
                    break;
                }
                case TRICONNECTED: {
                    options.setProperty(GeneratorOptions.GRAPH_TYPE, (Object)GeneratorOptions.GraphType.TRICONNECTED);
                    break;
                }
            }
        }
    }

    private void serialize(ElkNode graph, IFile file) throws IOException, CoreException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)file.getLocationURI().toString()));
        resource.getContents().add((Object)graph);
        resource.save(Collections.EMPTY_MAP);
        file.refreshLocal(1, null);
    }

    private boolean exists(Object o) {
        return o != null;
    }

    private <T> boolean setIfExists(GeneratorOptions genOpt, T value, IProperty<T> property) {
        boolean _exists = this.exists(value);
        if (_exists) {
            genOpt.setProperty(property, value);
            return true;
        }
        return false;
    }
}

