/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.elk.alg.rectpacking.firstiteration.AreaApproximation;
import org.eclipse.elk.alg.rectpacking.options.RectPackingOptions;
import org.eclipse.elk.alg.rectpacking.seconditeration.RowFillingAndCompaction;
import org.eclipse.elk.alg.rectpacking.util.DrawingData;
import org.eclipse.elk.alg.rectpacking.util.DrawingUtil;
import org.eclipse.elk.alg.rectpacking.util.OptimizationGoal;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.common.util.EList;

public class RectPackingLayoutProvider
extends AbstractLayoutProvider {
    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Rectangle Packing", 1.0f);
        if (progressMonitor.isLoggingEnabled()) {
            progressMonitor.logGraph(layoutGraph, "Input");
        }
        double aspectRatio = (Double)layoutGraph.getProperty(RectPackingOptions.ASPECT_RATIO);
        OptimizationGoal goal = (OptimizationGoal)((Object)layoutGraph.getProperty(RectPackingOptions.OPTIMIZATION_GOAL));
        boolean lastPlaceShift = (Boolean)layoutGraph.getProperty(RectPackingOptions.LAST_PLACE_SHIFT);
        boolean onlyFirstIteration = (Boolean)layoutGraph.getProperty(RectPackingOptions.ONLY_FIRST_ITERATION);
        boolean expandNodes = (Boolean)layoutGraph.getProperty(RectPackingOptions.EXPAND_NODES);
        ElkPadding padding = (ElkPadding)layoutGraph.getProperty(RectPackingOptions.PADDING);
        double nodeNodeSpacing = (Double)layoutGraph.getProperty(RectPackingOptions.SPACING_NODE_NODE);
        boolean compaction = (Boolean)layoutGraph.getProperty(RectPackingOptions.ROW_COMPACTION);
        boolean expandToAspectRatio = (Boolean)layoutGraph.getProperty(RectPackingOptions.EXPAND_TO_ASPECT_RATIO);
        boolean interactive = (Boolean)layoutGraph.getProperty(RectPackingOptions.INTERACTIVE);
        EList rectangles = layoutGraph.getChildren();
        DrawingUtil.resetCoordinates((List<ElkNode>)rectangles);
        if (interactive) {
            ArrayList<ElkNode> fixedNodes = new ArrayList<ElkNode>();
            for (ElkNode elkNode : rectangles) {
                if (!elkNode.hasProperty(RectPackingOptions.DESIRED_POSITION)) continue;
                fixedNodes.add(elkNode);
            }
            for (ElkNode elkNode : fixedNodes) {
                rectangles.remove(elkNode);
            }
            Collections.sort(fixedNodes, (a, b) -> {
                int positionB;
                int positionA = (Integer)a.getProperty(RectPackingOptions.DESIRED_POSITION);
                if (positionA == (positionB = ((Integer)b.getProperty(RectPackingOptions.DESIRED_POSITION)).intValue())) {
                    return -1;
                }
                return Integer.compare(positionA, positionB);
            });
            for (ElkNode elkNode : fixedNodes) {
                int position = (Integer)elkNode.getProperty(RectPackingOptions.DESIRED_POSITION);
                rectangles.add(position, elkNode);
            }
            int index = 0;
            for (ElkNode elkNode : rectangles) {
                elkNode.setProperty(RectPackingOptions.CURRENT_POSITION, (Object)index);
                ++index;
            }
        }
        KVector minSize = ElkUtil.effectiveMinSizeConstraintFor((ElkNode)layoutGraph);
        minSize.x -= padding.getHorizontal();
        minSize.y -= padding.getVertical();
        AreaApproximation firstIt = new AreaApproximation(aspectRatio, goal, lastPlaceShift);
        DrawingData drawing = firstIt.approxBoundingBox((List<ElkNode>)rectangles, nodeNodeSpacing);
        if (progressMonitor.isLoggingEnabled()) {
            progressMonitor.logGraph(layoutGraph, "After approximation");
        }
        if (!onlyFirstIteration) {
            DrawingUtil.resetCoordinates((List<ElkNode>)rectangles);
            RowFillingAndCompaction secondIt = new RowFillingAndCompaction(aspectRatio, expandNodes, expandToAspectRatio, compaction, nodeNodeSpacing);
            minSize.x = Math.max(minSize.x, drawing.getDrawingWidth());
            drawing = secondIt.start((List<ElkNode>)rectangles, minSize);
        }
        if (progressMonitor.isLoggingEnabled()) {
            progressMonitor.logGraph(layoutGraph, "After compaction");
        }
        RectPackingLayoutProvider.applyPadding((List<ElkNode>)rectangles, padding);
        ElkUtil.resizeNode((ElkNode)layoutGraph, (double)(drawing.getDrawingWidth() + padding.getHorizontal()), (double)(drawing.getDrawingHeight() + padding.getVertical()), (boolean)false, (boolean)true);
        if (progressMonitor.isLoggingEnabled()) {
            progressMonitor.logGraph(layoutGraph, "Output");
        }
        progressMonitor.done();
    }

    private static void applyPadding(List<ElkNode> rectangles, ElkPadding padding) {
        for (ElkNode rect : rectangles) {
            rect.setLocation(rect.getX() + padding.getLeft(), rect.getY() + padding.getTop());
        }
    }
}

