/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.views.time;

import org.eclipse.elk.core.debug.ElkDebugPlugin;
import org.eclipse.elk.core.debug.model.ExecutionInfo;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

final class ExecutionTimeLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private static final String IMAGE_PATH = "/icons/execution.gif";
    private Image elementImage = ElkDebugPlugin.imageDescriptorFromPlugin((String)"org.eclipse.elk.core.debug", (String)"/icons/execution.gif").createImage();
    private DisplayMode displayMode;

    public ExecutionTimeLabelProvider(DisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    public Image getImage(Object element) {
        if (this.displayMode == DisplayMode.NAME && element instanceof ExecutionInfo) {
            return this.elementImage;
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof ExecutionInfo) {
            ExecutionInfo execution = (ExecutionInfo)element;
            switch (this.displayMode) {
                case NAME: {
                    return new StyledString(execution.getName());
                }
                case TIME_TOTAL: {
                    if (execution.isExecutionTimeMeasured()) {
                        return new StyledString(this.timeToString(execution.getExecutionTimeIncludingChildren()));
                    }
                    return new StyledString("\u2013");
                }
                case TIME_LOCAL: {
                    if (execution.isExecutionTimeMeasured()) {
                        return execution.getChildren().isEmpty() ? new StyledString("") : new StyledString(this.timeToString(execution.getExecutionTimeLocal()));
                    }
                    return new StyledString("");
                }
            }
        }
        return null;
    }

    private String timeToString(double time) {
        return String.format("%1$.3f", time * 1000.0);
    }

    public void dispose() {
        super.dispose();
        if (this.elementImage != null) {
            this.elementImage.dispose();
            this.elementImage = null;
        }
    }

    public static enum DisplayMode {
        NAME,
        TIME_TOTAL,
        TIME_LOCAL;

    }
}

