/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.eclipse.elk.graph.json.JsonImportException;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public final class JsonAdapter {
    public Object getId(JsonObject o) {
        boolean _not;
        Object _xblockexpression = null;
        boolean _has = o.has("id");
        boolean bl = _not = !_has;
        if (_not) {
            throw this.formatError("Every element must have an id.");
        }
        _xblockexpression = this.asId(o.get("id"));
        return _xblockexpression;
    }

    public Object asId(JsonElement id) {
        boolean _isString;
        boolean _matched = false;
        if (id instanceof JsonPrimitive && (_isString = ((JsonPrimitive)id).isString())) {
            _matched = true;
            return ((JsonPrimitive)id).getAsString();
        }
        if (!_matched && id instanceof JsonPrimitive && ((JsonPrimitive)id).isNumber() && this.isInt(((JsonPrimitive)id).getAsDouble())) {
            _matched = true;
            return Double.valueOf(((JsonPrimitive)id).getAsDouble()).intValue();
        }
        throw this.formatError("Id must be a string or an integer: '" + id + "'.");
    }

    public String getIdSave(JsonObject o) {
        return this.optString(o, "id");
    }

    public Error implementationError() {
        return new Error("Severe implementation error in the Json to ElkGraph importer.");
    }

    public JsonImportException formatError(String msg) {
        return new JsonImportException(msg);
    }

    public JsonObject toJsonObject(Object o) {
        return (JsonObject)o;
    }

    public JsonArray toJsonArray(Object o) {
        return (JsonArray)o;
    }

    public String stringVal(JsonElement e) {
        return e.getAsString();
    }

    public String optString(JsonObject o, String element) {
        JsonElement _get = o.get(element);
        String _stringVal = null;
        if (_get != null) {
            _stringVal = this.stringVal(_get);
        }
        return _stringVal;
    }

    public String optString(JsonArray arr, int i) {
        JsonElement _get = arr.get(i);
        String _stringVal = null;
        if (_get != null) {
            _stringVal = this.stringVal(_get);
        }
        return _stringVal;
    }

    public String optString(Object o, String element) {
        JsonObject _jsonObject = null;
        if (o != null) {
            _jsonObject = this.toJsonObject(o);
        }
        return this.optString(_jsonObject, element);
    }

    public Double optDouble(JsonObject o, String element) {
        Double _xifexpression = null;
        boolean _has = o.has(element);
        _xifexpression = _has ? Double.valueOf(o.get(element).getAsDouble()) : null;
        return _xifexpression;
    }

    public JsonArray optJSONArray(JsonObject o, String element) {
        JsonElement _get = o.get(element);
        JsonArray _asJsonArray = null;
        if (_get != null) {
            _asJsonArray = _get.getAsJsonArray();
        }
        return _asJsonArray;
    }

    public JsonObject optJSONObject(JsonObject o, String element) {
        JsonElement _get = o.get(element);
        JsonObject _asJsonObject = null;
        if (_get != null) {
            _asJsonObject = _get.getAsJsonObject();
        }
        return _asJsonObject;
    }

    public JsonObject optJSONObject(JsonArray arr, int i) {
        JsonElement _get = arr.get(i);
        JsonObject _asJsonObject = null;
        if (_get != null) {
            _asJsonObject = _get.getAsJsonObject();
        }
        return _asJsonObject;
    }

    public int sizeJsonArr(JsonArray o) {
        return o.size();
    }

    public boolean hasJsonObj(JsonObject o, String element) {
        return o.has(element);
    }

    public Iterable<String> keysJsonObj(JsonObject o) {
        Functions.Function1<Map.Entry<String, JsonElement>, String> _function = new Functions.Function1<Map.Entry<String, JsonElement>, String>(){

            public String apply(Map.Entry<String, JsonElement> e) {
                return e.getKey();
            }
        };
        return IterableExtensions.map((Iterable)o.entrySet(), (Functions.Function1)_function);
    }

    public JsonElement getJsonObj(JsonObject o, String element) {
        return o.get(element);
    }

    public JsonElement getJsonArr(JsonArray arr, int i) {
        return arr.get(i);
    }

    public JsonObject newJsonObject() {
        return new JsonObject();
    }

    public JsonArray newJsonArray() {
        return new JsonArray();
    }

    public JsonPrimitive toJson(String s) {
        return new JsonPrimitive(s);
    }

    public JsonPrimitive toJson(Number n) {
        return new JsonPrimitive(n);
    }

    public void addJsonObj(JsonObject o, String element, Number n) {
        o.addProperty(element, n);
    }

    public void addJsonObj(JsonObject o, String element, boolean b) {
        o.addProperty(element, Boolean.valueOf(b));
    }

    public void addJsonObj(JsonObject o, String element, String s) {
        o.addProperty(element, s);
    }

    public void addJsonObj(JsonObject o, String element, JsonElement je) {
        o.add(element, je);
    }

    public void addJsonObj(JsonObject o, String element, Object obj) {
        boolean _matched = false;
        if (obj instanceof String) {
            _matched = true;
            this.addJsonObj(o, element, (String)obj);
        }
        if (!_matched && obj instanceof Boolean) {
            _matched = true;
            this.addJsonObj(o, element, obj);
        }
        if (!_matched && obj instanceof Number) {
            _matched = true;
            this.addJsonObj(o, element, (Number)obj);
        }
        if (!_matched) {
            throw this.implementationError();
        }
    }

    public void addJsonArr(JsonArray arr, JsonElement je) {
        arr.add(je);
    }

    public void addJsonArr(JsonArray arr, Object o) {
        boolean _matched = false;
        if (o instanceof String) {
            _matched = true;
            this.addJsonArr(arr, (JsonElement)this.toJson((String)o));
        }
        if (!_matched && o instanceof Number) {
            _matched = true;
            this.addJsonArr(arr, (JsonElement)this.toJson((Number)o));
        }
        if (!_matched) {
            throw this.implementationError();
        }
    }

    public boolean isInt(double d) {
        return d % 1.0 == 0.0;
    }
}

