/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p2layers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.PriorityQueue;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class CoffmanGrahamLayerer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private boolean[] nodeMark;
    private boolean[] edgeMark;
    private int[] inDeg;
    private int[] outDeg;
    private int[] topoOrd;
    private ListMultimap<LNode, Integer> inTopo = ArrayListMultimap.create();
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> BASELINE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P1_CYCLE_BREAKING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER).addBefore((Enum)LayeredPhases.P2_LAYERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LAYER_CONSTRAINT_PREPROCESSOR).addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LAYER_CONSTRAINT_POSTPROCESSOR);

    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Coffman-Graham Layering", 1.0f);
        if (layeredGraph.getLayerlessNodes().isEmpty()) {
            progressMonitor.done();
            return;
        }
        int w = (Integer)layeredGraph.getProperty(LayeredOptions.LAYERING_COFFMAN_GRAHAM_LAYER_BOUND);
        int index = 0;
        int edgeIndex = 0;
        for (LNode n : layeredGraph.getLayerlessNodes()) {
            n.id = index++;
            for (LEdge e : n.getOutgoingEdges()) {
                e.id = edgeIndex++;
            }
        }
        this.nodeMark = new boolean[index];
        this.edgeMark = new boolean[edgeIndex];
        this.inDeg = new int[index];
        this.outDeg = new int[index];
        this.topoOrd = new int[index];
        this.inTopo.clear();
        this.transitiveReduction(layeredGraph);
        PriorityQueue<LNode> sources = new PriorityQueue<LNode>(this::compareNodesInTopo);
        for (LNode v : layeredGraph.getLayerlessNodes()) {
            for (LEdge e : v.getIncomingEdges()) {
                if (this.edgeMark[e.id]) continue;
                int n = v.id;
                this.inDeg[n] = this.inDeg[n] + 1;
            }
            if (this.inDeg[v.id] != 0) continue;
            sources.add(v);
        }
        int i = 0;
        while (!sources.isEmpty()) {
            LNode v = (LNode)((Object)sources.poll());
            this.topoOrd[v.id] = i++;
            for (LEdge e : v.getOutgoingEdges()) {
                if (this.edgeMark[e.id]) continue;
                LNode tgt = e.getTarget().getNode();
                int n = tgt.id;
                this.inDeg[n] = this.inDeg[n] - 1;
                this.inTopo.put((Object)tgt, (Object)this.topoOrd[v.id]);
                if (this.inDeg[tgt.id] != 0) continue;
                sources.add(tgt);
            }
        }
        PriorityQueue<LNode> sinks = new PriorityQueue<LNode>((n1, n2) -> -Integer.compare(this.topoOrd[n1.id], this.topoOrd[n2.id]));
        for (LNode v : layeredGraph.getLayerlessNodes()) {
            for (LEdge e : v.getOutgoingEdges()) {
                if (this.edgeMark[e.id]) continue;
                int n = v.id;
                this.outDeg[n] = this.outDeg[n] + 1;
            }
            if (this.outDeg[v.id] != 0) continue;
            sinks.add(v);
        }
        ArrayList layers = Lists.newArrayList();
        Layer currentLayer = this.createLayer(layeredGraph, layers);
        while (!sinks.isEmpty()) {
            LNode u = (LNode)((Object)sinks.poll());
            if (this.isLayerFull(currentLayer, w) || !this.canAdd(u, currentLayer)) {
                currentLayer = this.createLayer(layeredGraph, layers);
            }
            u.setLayer(currentLayer);
            for (LEdge e : u.getIncomingEdges()) {
                if (this.edgeMark[e.id]) continue;
                LNode src = e.getSource().getNode();
                int n = src.id;
                this.outDeg[n] = this.outDeg[n] - 1;
                if (this.outDeg[src.id] != 0) continue;
                sinks.add(src);
            }
        }
        int j = layers.size() - 1;
        while (j >= 0) {
            layeredGraph.getLayers().add((Layer)layers.get(j));
            --j;
        }
        layeredGraph.getLayerlessNodes().clear();
        progressMonitor.done();
    }

    private boolean isLayerFull(Layer layer, int w) {
        return layer.getNodes().size() >= w;
    }

    private boolean canAdd(LNode n, Layer l) {
        for (LEdge e : n.getOutgoingEdges()) {
            LNode v = e.getTarget().getNode();
            if (v.getLayer() != l) continue;
            return false;
        }
        return true;
    }

    private Layer createLayer(LGraph graph, List<Layer> layers) {
        Layer aLayer = new Layer(graph);
        layers.add(aLayer);
        return aLayer;
    }

    private int compareNodesInTopo(LNode u, LNode v) {
        List inListU = this.inTopo.get((Object)u);
        List inLsitV = this.inTopo.get((Object)v);
        ListIterator itU = inListU.listIterator(inListU.size());
        ListIterator itV = inLsitV.listIterator(inLsitV.size());
        while (itU.hasPrevious() && itV.hasPrevious()) {
            Integer iv;
            Integer iu = (Integer)itU.previous();
            if (iu == (iv = (Integer)itV.previous())) continue;
            return Integer.compare(iu, iv);
        }
        if (!itU.hasNext() && !itV.hasNext()) {
            return 0;
        }
        if (!itU.hasNext()) {
            return -1;
        }
        return 1;
    }

    private void transitiveReduction(LGraph graph) {
        for (LNode start : graph.getLayerlessNodes()) {
            Arrays.fill(this.nodeMark, false);
            for (LEdge out : start.getOutgoingEdges()) {
                this.dfs(start, out.getTarget().getNode());
            }
        }
    }

    private void dfs(LNode start, LNode v) {
        if (this.nodeMark[v.id]) {
            return;
        }
        for (LEdge out : v.getOutgoingEdges()) {
            LNode w = out.getTarget().getNode();
            for (LEdge transitive : w.getIncomingEdges()) {
                if (transitive.getSource().getNode() != start) continue;
                this.edgeMark[transitive.id] = true;
            }
            this.dfs(start, w);
        }
        this.nodeMark[v.id] = true;
    }

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return BASELINE_PROCESSING_CONFIGURATION;
    }
}

