/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.templates.core.processes;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddAbsolutePathFiles
extends ProcessRunner {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        IProject projectHandle = null;
        ProcessArgument[][] files = null;
        String startPattern = null;
        String endPattern = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            String argName = arg.getName();
            if (argName.equals("projectName")) {
                projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(arg.getSimpleValue());
            } else if (argName.equals("files")) {
                files = arg.getComplexArrayValue();
            } else if (argName.equals("startPattern")) {
                startPattern = arg.getSimpleValue();
            } else if (argName.equals("endPattern")) {
                endPattern = arg.getSimpleValue();
            }
            ++n2;
        }
        if (projectHandle == null) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, Messages.getString((String)"AddFiles.8")));
        }
        if (files == null) {
            throw new ProcessFailureException(this.getProcessMessage(processId, 4, Messages.getString((String)"AddFiles.9")));
        }
        int i = 0;
        while (i < files.length) {
            URL sourceURL;
            void file = files[i];
            String fileSourcePath = file[0].getSimpleValue();
            String fileTargetPath = file[1].getSimpleValue();
            boolean replaceable = file[2].getSimpleValue().equals("true");
            try {
                File f = new File(fileSourcePath);
                if (f.isAbsolute()) {
                    sourceURL = f.toURL();
                } else {
                    sourceURL = TemplateEngineHelper.getTemplateResourceURLRelativeToTemplate((TemplateCore)template, (String)fileSourcePath);
                    if (sourceURL == null) {
                        throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString((String)"AddFiles.1")) + fileSourcePath));
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.2")) + fileSourcePath);
            }
            catch (IOException iOException) {
                throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.2")) + fileSourcePath);
            }
            InputStream contents = null;
            if (replaceable) {
                String fileContents;
                try {
                    fileContents = ProcessHelper.readFromFile((URL)sourceURL);
                }
                catch (IOException iOException) {
                    throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.3")) + fileSourcePath);
                }
                fileContents = startPattern != null && endPattern != null ? ProcessHelper.getValueAfterExpandingMacros((String)fileContents, (Set)ProcessHelper.getReplaceKeys((String)fileContents, (String)startPattern, (String)endPattern), (Map)template.getValueStore(), (String)startPattern, (String)endPattern) : ProcessHelper.getValueAfterExpandingMacros((String)fileContents, (Set)ProcessHelper.getReplaceKeys((String)fileContents), (Map)template.getValueStore());
                contents = new ByteArrayInputStream(fileContents.getBytes());
            } else {
                try {
                    contents = sourceURL.openStream();
                }
                catch (IOException iOException) {
                    throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString((String)"AddFiles.4")) + fileSourcePath));
                }
            }
            try {
                IFile iFile = projectHandle.getFile(fileTargetPath);
                if (!iFile.getParent().exists()) {
                    ProcessHelper.mkdirs((IProject)projectHandle, (IFolder)projectHandle.getFolder(iFile.getParent().getProjectRelativePath()));
                }
                if (iFile.exists()) {
                    if (!replaceable) throw new ProcessFailureException(Messages.getString((String)"AddFiles.5"));
                    iFile.setContents(contents, true, true, null);
                } else {
                    iFile.create(contents, true, null);
                    iFile.refreshLocal(1, null);
                }
            }
            catch (CoreException e) {
                throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.6")) + e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        try {
            projectHandle.refreshLocal(2, null);
            return;
        }
        catch (CoreException e) {
            throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AddFiles.7")) + e.getMessage(), (Throwable)e);
        }
    }
}

