/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.ui.viewmodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbAdapterFactory;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputProvider;
import org.eclipse.embedcdt.debug.gdbjtag.ui.viewmodel.GnuMcuViewModelAdapter;

public class GnuMcuAdapterFactory
extends GdbAdapterFactory {
    private static Map<GdbLaunch, SessionAdapters> fgLaunchAdaptersMap = Collections.synchronizedMap(new HashMap());
    private static Map<ILaunch, SessionAdapters> fgDisposedLaunchAdaptersMap = new WeakHashMap<ILaunch, SessionAdapters>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeAdapterSet(ILaunch launch) {
        Map<GdbLaunch, SessionAdapters> map = fgLaunchAdaptersMap;
        synchronized (map) {
            if (fgLaunchAdaptersMap.containsKey(launch)) {
                fgLaunchAdaptersMap.remove(launch).dispose();
                fgDisposedLaunchAdaptersMap.put(launch, null);
            }
        }
    }

    public GnuMcuAdapterFactory() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        SessionAdapters sessionAdapters;
        block12: {
            if (!(adaptableObject instanceof GdbLaunch)) {
                return null;
            }
            GdbLaunch launch = (GdbLaunch)adaptableObject;
            DsfSession session = launch.getSession();
            if (session == null) {
                return null;
            }
            Map<GdbLaunch, SessionAdapters> map = fgLaunchAdaptersMap;
            synchronized (map) {
                block11: {
                    block10: {
                        if (!fgDisposedLaunchAdaptersMap.containsKey(launch)) break block10;
                        return null;
                    }
                    sessionAdapters = fgLaunchAdaptersMap.get(launch);
                    if (sessionAdapters != null) break block12;
                    if (session.isActive()) break block11;
                    return null;
                }
                sessionAdapters = new SessionAdapters(launch);
                fgLaunchAdaptersMap.put(launch, sessionAdapters);
            }
        }
        if (adapterType.equals(IElementContentProvider.class)) {
            return sessionAdapters.fViewModelAdapter;
        }
        if (adapterType.equals(IModelProxyFactory.class)) {
            return sessionAdapters.fViewModelAdapter;
        }
        if (adapterType.equals(IColumnPresentationFactory.class)) {
            return sessionAdapters.fViewModelAdapter;
        }
        return super.getAdapter(adaptableObject, adapterType);
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof GdbLaunch) {
                GnuMcuAdapterFactory.disposeAdapterSet(launch);
            }
            ++n2;
        }
        super.launchesRemoved(launches);
    }

    @Immutable
    class SessionAdapters {
        final GdbLaunch fLaunch;
        final SteppingController fSteppingController;
        final GnuMcuViewModelAdapter fViewModelAdapter;

        SessionAdapters(GdbLaunch launch) {
            this.fLaunch = launch;
            DsfSession session = launch.getSession();
            this.fSteppingController = new SteppingController(session);
            session.registerModelAdapter(SteppingController.class, (Object)this.fSteppingController);
            this.fViewModelAdapter = new GnuMcuViewModelAdapter(session, this.fSteppingController);
            session.registerModelAdapter(IViewerInputProvider.class, (Object)this.fViewModelAdapter);
        }

        void dispose() {
            DsfSession session = this.fLaunch.getSession();
            session.unregisterModelAdapter(IViewerInputProvider.class);
            if (this.fViewModelAdapter != null) {
                this.fViewModelAdapter.dispose();
            }
            session.unregisterModelAdapter(SteppingController.class);
            if (this.fSteppingController != null) {
                this.fSteppingController.dispose();
            }
        }
    }
}

