/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.qemu.core;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.StringUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.core.DynamicVariableResolver;
import org.eclipse.embedcdt.debug.gdbjtag.qemu.core.preferences.DefaultPreferences;
import org.eclipse.embedcdt.internal.debug.gdbjtag.qemu.core.Activator;

public class Configuration {
    public static String getPrefix(ILaunchConfiguration configuration) {
        String prefix = "";
        String architecture = "";
        try {
            architecture = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.architecture", "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (!architecture.isEmpty()) {
            prefix = String.valueOf(architecture) + ".";
        }
        return prefix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getGdbServerCommand(ILaunchConfiguration configuration, String executable, Boolean preferXpacksBin) {
        try {
            if (executable == null) {
                DefaultPreferences fDefaultPreferences;
                String prefix = "";
                String architecture = "";
                try {
                    architecture = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.architecture", "");
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (!architecture.isEmpty()) {
                    prefix = String.valueOf(architecture) + ".";
                }
                if (!configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doStartGdbServer", (fDefaultPreferences = Activator.getInstance().getDefaultPreferences()).getGdbServerDoStart(prefix))) {
                    return null;
                }
                executable = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerExecutable", fDefaultPreferences.getGdbServerExecutable(prefix, architecture));
            }
            executable = Configuration.resolveAll(executable, configuration);
            if (preferXpacksBin == null) {
                preferXpacksBin = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doStartGdbServer", false);
            }
            if (preferXpacksBin == false) return executable;
            String name = StringUtils.extractNameFromPath((String)executable);
            IResource[] resources = configuration.getMappedResources();
            Project project = null;
            if (resources == null) return executable;
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof Project) {
                    project = (Project)resource;
                    break;
                }
                ++n2;
            }
            if (project == null) return executable;
            IPath xpackBinPath = project.getFolder("xpacks").getFolder(".bin").getLocation();
            IPath serverPath = xpackBinPath.append(name);
            if (serverPath.toFile().exists()) {
                return serverPath.toString();
            }
            if (!EclipseUtils.isWindows()) return executable;
            serverPath = xpackBinPath.append(String.valueOf(name) + ".cmd");
            if (!serverPath.toFile().exists()) return executable;
            return serverPath.toString();
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
            return null;
        }
    }

    public static String getGdbServerCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbServerCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String[] getGdbServerCommandLineArray(ILaunchConfiguration configuration) {
        String executable;
        boolean useLegacyInterface;
        ArrayList<String> lst;
        block24: {
            block23: {
                lst = new ArrayList<String>();
                DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
                String prefix = "";
                String architecture = "";
                try {
                    architecture = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.architecture", "");
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                useLegacyInterface = false;
                if (architecture.isEmpty()) {
                    useLegacyInterface = true;
                } else {
                    prefix = String.valueOf(architecture) + ".";
                }
                if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doStartGdbServer", fDefaultPreferences.getGdbServerDoStart(prefix))) break block23;
                return null;
            }
            executable = Configuration.getGdbServerCommand(configuration, null, null);
            if (executable != null && !executable.isEmpty()) break block24;
            return null;
        }
        try {
            boolean nographic;
            String deviceName;
            String boardName;
            lst.add(executable);
            if (useLegacyInterface) {
                lst.add("--verbose");
                if (configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.isGdbServerVerbose", false)) {
                    lst.add("--verbose");
                }
                boardName = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerBoardName", "").trim();
                if (!(boardName = DebugUtils.resolveAll((String)boardName, (Map)configuration.getAttributes())).isEmpty()) {
                    lst.add("--board");
                    lst.add(boardName);
                }
                deviceName = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerDeviceName", "").trim();
                if (!(deviceName = DebugUtils.resolveAll((String)deviceName, (Map)configuration.getAttributes())).isEmpty()) {
                    lst.add("--mcu");
                    lst.add(deviceName);
                }
            } else {
                boardName = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerQemuMachineName", "").trim();
                if (!(boardName = DebugUtils.resolveAll((String)boardName, (Map)configuration.getAttributes())).isEmpty()) {
                    lst.add("--machine");
                    lst.add(boardName);
                }
                deviceName = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerQemuCpuName", "").trim();
                if (!(deviceName = DebugUtils.resolveAll((String)deviceName, (Map)configuration.getAttributes())).isEmpty()) {
                    lst.add("--cpu");
                    lst.add(deviceName);
                }
            }
            lst.add("--gdb");
            lst.add("tcp::" + Integer.toString(configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerGdbPortNumber", 1234)));
            if (!useLegacyInterface) {
                lst.add("-S");
            }
            String other = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerOther", "-d unimp,guest_errors").trim();
            if (!(other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes())).isEmpty()) {
                lst.addAll(StringUtils.splitCommandLineOptions((String)other));
            }
            if (nographic = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.disableGraphics", false)) {
                lst.add("--nographic");
            }
            boolean isSemihosting = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.enableSemihosting", true);
            if (useLegacyInterface) {
                String semihostingCmdline;
                lst.add("--semihosting-config");
                lst.add(isSemihosting ? "enable=on,target=native" : "enable=off,target=native");
                if (isSemihosting && !(semihostingCmdline = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.semihosting.cmdline", "").trim()).isEmpty()) {
                    lst.add("--semihosting-cmdline");
                    lst.addAll(StringUtils.splitCommandLineOptions((String)semihostingCmdline));
                }
            } else {
                String semihostingCmdline;
                lst.add("--semihosting-config");
                String semiConfig = "enable=";
                semiConfig = String.valueOf(semiConfig) + (isSemihosting ? "on" : "off");
                semiConfig = String.valueOf(semiConfig) + ",target=native";
                if (isSemihosting && !(semihostingCmdline = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.semihosting.cmdline", "").trim()).isEmpty()) {
                    for (String opt : StringUtils.splitCommandLineOptions((String)semihostingCmdline)) {
                        semiConfig = String.valueOf(semiConfig) + ",arg=" + opt;
                    }
                }
                lst.add(semiConfig);
            }
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
            return null;
        }
        return lst.toArray(new String[0]);
    }

    public static String getGdbServerCommandName(ILaunchConfiguration configuration) {
        String fullCommand = Configuration.getGdbServerCommand(configuration, null, null);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String getGdbServerOtherConfig(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerOther", "-d unimp,guest_errors").trim();
    }

    public static String getQemuBoardName(ILaunchConfiguration configuration) throws CoreException {
        String architecture = "";
        try {
            architecture = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.architecture", "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        boolean useLegacyInterface = architecture.isEmpty();
        if (useLegacyInterface) {
            return configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerBoardName", "").trim();
        }
        return configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerQemuMachineName", "").trim();
    }

    public static String getQemuDeviceName(ILaunchConfiguration configuration) throws CoreException {
        String architecture = "";
        try {
            architecture = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.architecture", "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        boolean useLegacyInterface = architecture.isEmpty();
        if (useLegacyInterface) {
            return configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerDeviceName", "").trim();
        }
        return configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbServerQemuCpuName", "").trim();
    }

    public static String getGdbClientCommand(ILaunchConfiguration configuration, String executable) {
        try {
            if (executable == null) {
                String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
                executable = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            }
            executable = Configuration.resolveAll(executable, configuration);
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
            return null;
        }
        return executable;
    }

    public static String[] getGdbClientCommandLineArray(ILaunchConfiguration configuration) {
        ArrayList<String> lst = new ArrayList<String>();
        String executable = Configuration.getGdbClientCommand(configuration, null);
        if (executable == null || executable.isEmpty()) {
            return null;
        }
        lst.add(executable);
        lst.add("--interpreter=mi2");
        lst.add("--nx");
        try {
            DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
            String prefix = Configuration.getPrefix(configuration);
            String other = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.gdbClientOtherOptions", fDefaultPreferences.getGdbClientOtherOptions(prefix)).trim();
            other = DebugUtils.resolveAll((String)other, (Map)configuration.getAttributes());
            if (other.length() > 0) {
                lst.addAll(StringUtils.splitCommandLineOptions((String)other));
            }
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
        }
        return lst.toArray(new String[0]);
    }

    public static String getGdbClientCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = Configuration.getGdbClientCommandLineArray(configuration);
        return StringUtils.join((String[])cmdLineArray, (String)" ");
    }

    public static String getGdbClientCommandName(ILaunchConfiguration configuration) {
        String fullCommand = Configuration.getGdbClientCommand(configuration, null);
        return StringUtils.extractNameFromPath((String)fullCommand);
    }

    public static String resolveAll(String str, ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String value = str;
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        if (value.indexOf("${") >= 0 && (project = EclipseUtils.getProjectByLaunchConfiguration((ILaunchConfiguration)configuration)) != null) {
            value = DynamicVariableResolver.resolveAll(value, project);
        }
        if (value.indexOf("${") >= 0) {
            value = DebugUtils.resolveAll((String)value, (Map)configuration.getAttributes());
            ICConfigurationDescription buildConfig = EclipseUtils.getBuildConfigDescription((ILaunchConfiguration)configuration);
            if (buildConfig != null) {
                value = DebugUtils.resolveAll((String)value, (ICConfigurationDescription)buildConfig);
            }
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("qemu.resolveAll(\"" + str + "\") = \"" + value + "\"");
        }
        return value;
    }

    public static boolean getDoStartGdbServer(ILaunchConfiguration configuration) throws CoreException {
        DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();
        String prefix = Configuration.getPrefix(configuration);
        return configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doStartGdbServer", fDefaultPreferences.getGdbServerDoStart(prefix));
    }

    public static boolean getDoAddServerConsole(ILaunchConfiguration configuration) throws CoreException {
        return Configuration.getDoStartGdbServer(configuration) && configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.doGdbServerAllocateConsole", true);
    }

    public static boolean hasLegacyInterface(ILaunchConfiguration configuration) {
        String architecture = "";
        try {
            architecture = configuration.getAttribute("ilg.gnumcueclipse.debug.gdbjtag.qemu.architecture", "");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return architecture.isEmpty();
    }
}

