/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.editor;

import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.emfatic.core.lang.gen.parser.EmfaticParserDriver;
import org.eclipse.emf.emfatic.ui.contentassist.CascadedContentAssistProcessor;
import org.eclipse.emf.emfatic.ui.contentassist.EmfaticContentAssistProcessor;
import org.eclipse.emf.emfatic.ui.contentassist.EmfaticKeywordContentAssistProcessor;
import org.eclipse.emf.emfatic.ui.editor.EmfaticAutoEditStrategy;
import org.eclipse.emf.emfatic.ui.editor.EmfaticCodeScanner;
import org.eclipse.emf.emfatic.ui.editor.EmfaticEditor;
import org.eclipse.emf.emfatic.ui.editor.EmfaticTextHover;
import org.eclipse.emf.emfatic.ui.hyperlinks.EmfaticHyperlinkDetector;
import org.eclipse.emf.emfatic.ui.partition.EmfaticPartitionScanner;
import org.eclipse.emf.emfatic.ui.templates.EmfaticTemplateCompletionProcessor;
import org.eclipse.gymnast.runtime.core.parser.IParser;
import org.eclipse.gymnast.runtime.ui.editor.LDTCodeScanner;
import org.eclipse.gymnast.runtime.ui.editor.LDTEditor;
import org.eclipse.gymnast.runtime.ui.editor.LDTSourceViewerConfiguration;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;

public class EmfaticSourceViewerConfiguration
extends LDTSourceViewerConfiguration {
    EmfaticCodeScanner _emfaticCodeScanner = null;
    EmfaticEditor _editor = null;
    private final EmfaticTextHover _textHover;
    DefaultAnnotationHover _annotationHover = null;

    public EmfaticSourceViewerConfiguration(EmfaticEditor editor) {
        super((LDTEditor)editor);
        this._editor = editor;
        this._textHover = new EmfaticTextHover(editor);
    }

    public LDTCodeScanner createCodeScanner() {
        if (this._emfaticCodeScanner == null) {
            this._emfaticCodeScanner = new EmfaticCodeScanner();
        }
        return this._emfaticCodeScanner;
    }

    public IParser getParser() {
        return new EmfaticParserDriver(URI.createPlatformResourceURI((String)this._editor.getFile().getFullPath().toPortableString(), (boolean)true));
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this._textHover;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return this._textHover;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return EmfaticPartitionScanner.contentTypes();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer arg0) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.createCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        this.setDR(reconciler, dr, "packagePart");
        this.setDR(reconciler, dr, "importPart");
        this.setDR(reconciler, dr, "annotationPart");
        this.setDR(reconciler, dr, "subPackagePart");
        this.setDR(reconciler, dr, "attrPart");
        this.setDR(reconciler, dr, "refPart");
        this.setDR(reconciler, dr, "valPart");
        this.setDR(reconciler, dr, "opPart");
        this.setDR(reconciler, dr, "datatypePart");
        this.setDR(reconciler, dr, "enumPart");
        this.setDR(reconciler, dr, "mapentryPart");
        this.setDR(reconciler, dr, "classHeadingPart");
        this.setDR(reconciler, dr, "ifaceHeadingPart");
        this.setDR(reconciler, dr, "singleLineComment");
        DefaultDamagerRepairer cr = new DefaultDamagerRepairer((ITokenScanner)this.createCodeScanner()){

            public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
                return partition;
            }
        };
        this.setDR(reconciler, cr, "multiLineComment");
        return reconciler;
    }

    private void setDR(PresentationReconciler reconciler, DefaultDamagerRepairer dr, String docPart) {
        reconciler.setDamager((IPresentationDamager)dr, docPart);
        reconciler.setRepairer((IPresentationRepairer)dr, docPart);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this._annotationHover == null) {
            this._annotationHover = new DefaultAnnotationHover();
        }
        return this._annotationHover;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this._editor == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors != null ? inheritedDetectors.length : 0;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 1];
        detectors[0] = new EmfaticHyperlinkDetector(this._editor);
        int i = 0;
        while (i < inheritedDetectorsLength) {
            detectors[i + 1] = inheritedDetectors[i];
            ++i;
        }
        return detectors;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] vonOben;
        ArrayList<Object> s = new ArrayList<Object>();
        IAutoEditStrategy[] iAutoEditStrategyArray = vonOben = super.getAutoEditStrategies(sourceViewer, contentType);
        int n = vonOben.length;
        int n2 = 0;
        while (n2 < n) {
            IAutoEditStrategy autoEditStrategy = iAutoEditStrategyArray[n2];
            s.add(autoEditStrategy);
            ++n2;
        }
        s.add(new DefaultIndentLineAutoEditStrategy());
        s.add(new EmfaticAutoEditStrategy(this._editor));
        IAutoEditStrategy[] res = s.toArray(new IAutoEditStrategy[0]);
        return res;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = new ContentAssistant();
        ca.enableAutoActivation(true);
        ca.setAutoActivationDelay(500);
        ca.setProposalPopupOrientation(21);
        ca.setContextInformationPopupOrientation(21);
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        CascadedContentAssistProcessor masterCap = new CascadedContentAssistProcessor();
        Object cap = new EmfaticTemplateCompletionProcessor("org.eclipse.emf.emfatic.ui.templates.EmfaticContextType");
        masterCap.add((IContentAssistProcessor)cap);
        this.registerForAllEmfaticContentTypes(ca, masterCap);
        cap = new EmfaticContentAssistProcessor(this._editor);
        masterCap.add((IContentAssistProcessor)cap);
        cap = new EmfaticKeywordContentAssistProcessor(this._editor);
        masterCap.add((IContentAssistProcessor)cap);
        return ca;
    }

    private void registerForAllEmfaticContentTypes(ContentAssistant ca, IContentAssistProcessor cap) {
        ca.setContentAssistProcessor(cap, "__dftl_partition_content_type");
        ca.setContentAssistProcessor(cap, "packagePart");
        ca.setContentAssistProcessor(cap, "importPart");
        ca.setContentAssistProcessor(cap, "annotationPart");
        ca.setContentAssistProcessor(cap, "subPackagePart");
        ca.setContentAssistProcessor(cap, "attrPart");
        ca.setContentAssistProcessor(cap, "refPart");
        ca.setContentAssistProcessor(cap, "valPart");
        ca.setContentAssistProcessor(cap, "opPart");
        ca.setContentAssistProcessor(cap, "datatypePart");
        ca.setContentAssistProcessor(cap, "enumPart");
        ca.setContentAssistProcessor(cap, "mapentryPart");
        ca.setContentAssistProcessor(cap, "classHeadingPart");
        ca.setContentAssistProcessor(cap, "ifaceHeadingPart");
        ca.setContentAssistProcessor(cap, "multiLineComment");
        ca.setContentAssistProcessor(cap, "singleLineComment");
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return super.getOverviewRulerAnnotationHover(sourceViewer);
    }
}

