/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.views;

import java.lang.ref.WeakReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.emfatic.core.lang.gen.ast.ClassDecl;
import org.eclipse.emf.emfatic.core.lang.gen.ast.EmfaticASTNode;
import org.eclipse.emf.emfatic.ui.EmfaticUIPlugin;
import org.eclipse.emf.emfatic.ui.editor.EmfaticEditor;
import org.eclipse.emf.emfatic.ui.hyperlinks.EmfaticHyperlinkDetector;
import org.eclipse.emf.emfatic.ui.views.MethodsViewContentProvider;
import org.eclipse.emf.emfatic.ui.views.MethodsViewLabelProvider;
import org.eclipse.emf.emfatic.ui.views.TypeHierarchyMessages;
import org.eclipse.emf.emfatic.ui.views.TypesViewContentProvider;
import org.eclipse.emf.emfatic.ui.views.TypesViewDoubleClick;
import org.eclipse.emf.emfatic.ui.views.TypesViewLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class TypesView
extends ViewPart
implements IShowInTarget {
    public static final String ID = "org.eclipse.emf.emfatic.ui.views.TypesView";
    private TreeViewer typesViewer;
    private TreeViewer memberViewer;
    private Action actionSupertypeH;
    private Action actionSubtypeH;
    private TypesViewDoubleClick doubleClickAction;
    private String _currentClassifier = "";
    private PageBook fPagebook;
    private Label fNoHierarchyShownLabel;
    private SashForm fTypeMethodsSplitter;
    private ViewForm fTypeViewerViewForm;
    private PageBook fViewerbook;
    private ViewForm fMethodViewerViewForm;
    private TableViewer fMethodsViewer;
    private CLabel fMethodViewerPaneLabel;
    private IAction fShowInheritedMembersAction;
    private IAction fSortByDefiningTypeAction;

    public void createPartControl(Composite parent) {
        this.fPagebook = new PageBook(parent, 0);
        this.fNoHierarchyShownLabel = new Label((Composite)this.fPagebook, 16576);
        this.fNoHierarchyShownLabel.setText(TypeHierarchyMessages.TypeHierarchyViewPart_empty);
        this.fTypeMethodsSplitter = new SashForm((Composite)this.fPagebook, 512);
        this.fTypeMethodsSplitter.setVisible(false);
        this.fTypeViewerViewForm = new ViewForm((Composite)this.fTypeMethodsSplitter, 0);
        Control typeViewerControl = this.createTypeViewerControl((Composite)this.fTypeViewerViewForm);
        this.fTypeViewerViewForm.setContent(typeViewerControl);
        this.fMethodViewerViewForm = new ViewForm((Composite)this.fTypeMethodsSplitter, 0);
        this.fTypeMethodsSplitter.setWeights(new int[]{35, 65});
        Control methodViewerPart = this.createMethodViewerControl(this.fMethodViewerViewForm);
        this.fMethodViewerViewForm.setContent(methodViewerPart);
        this.fMethodViewerPaneLabel = new CLabel((Composite)this.fMethodViewerViewForm, 0);
        this.fMethodViewerViewForm.setTopLeft((Control)this.fMethodViewerPaneLabel);
        this.fTypeMethodsSplitter.pack();
        this.makeTypeViewerActions();
        this.hookTypeViewerClickActions();
        this.contributeToActionBars();
        this.fillTheMethodViewerToolbar();
    }

    private void fillTheMethodViewerToolbar() {
        ToolBar methodViewerToolBar = new ToolBar((Composite)this.fMethodViewerViewForm, 0x800040);
        this.fMethodViewerViewForm.setTopCenter((Control)methodViewerToolBar);
        this.fShowInheritedMembersAction = new Action("Show inherited members", 2){

            public void run() {
                TypesView.this.fMethodsViewer.refresh();
            }
        };
        this.fShowInheritedMembersAction.setToolTipText("Show inherited members");
        this.fShowInheritedMembersAction.setImageDescriptor(EmfaticUIPlugin.getImageDescriptor("typesView/inher_co"));
        this.fShowInheritedMembersAction.setChecked(false);
        this.fSortByDefiningTypeAction = new Action("Sort by defining type", 2){

            public void run() {
                if (!this.isChecked()) {
                    TypesView.this.fMethodsViewer.setSorter(null);
                } else {
                    TypesView.this.fMethodsViewer.setSorter(new ViewerSorter(){

                        public int compare(Viewer viewer, Object e1, Object e2) {
                            int subtyping = this.compareSubtyping(e1, e2);
                            if (subtyping != 0) {
                                return subtyping;
                            }
                            String s1 = MethodsViewLabelProvider.labelFor(e1, true);
                            String s2 = MethodsViewLabelProvider.labelFor(e2, true);
                            return s1.compareTo(s2);
                        }

                        private int compareSubtyping(Object e1, Object e2) {
                            int res = 0;
                            EClass declClass1 = this.declaringClass(e1);
                            EClass declClass2 = this.declaringClass(e2);
                            if (declClass1 != null && declClass2 != null) {
                                if (declClass1.getEAllSuperTypes().contains((Object)declClass2)) {
                                    return -1;
                                }
                                if (declClass2.getEAllSuperTypes().contains((Object)declClass1)) {
                                    return 1;
                                }
                            }
                            return res;
                        }

                        private EClass declaringClass(Object e) {
                            EClass eC = null;
                            if (e instanceof EStructuralFeature) {
                                EStructuralFeature sf = (EStructuralFeature)e;
                                eC = sf.getEContainingClass();
                            }
                            if (e instanceof EOperation) {
                                EOperation eOp = (EOperation)e;
                                eC = eOp.getEContainingClass();
                            }
                            return eC;
                        }
                    });
                }
                TypesView.this.fMethodsViewer.refresh();
            }
        };
        this.fSortByDefiningTypeAction.setToolTipText("Sort by defining type");
        this.fSortByDefiningTypeAction.setImageDescriptor(EmfaticUIPlugin.getImageDescriptor("typesView/definingtype_sort_co"));
        this.fSortByDefiningTypeAction.setChecked(false);
        ToolBarManager lowertbmanager = new ToolBarManager(methodViewerToolBar);
        lowertbmanager.add((IContributionItem)new Separator());
        lowertbmanager.add(this.fShowInheritedMembersAction);
        lowertbmanager.add(this.fSortByDefiningTypeAction);
        lowertbmanager.add((IContributionItem)new Separator());
        lowertbmanager.update(true);
    }

    private void initActionMember(IAction a, String msg) {
        a.setText(msg);
        a.setToolTipText(msg);
        a.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private Control createMethodViewerControl(ViewForm parent) {
        this.fMethodsViewer = new TableViewer((Composite)parent, 67586);
        this.fMethodsViewer.setContentProvider((IContentProvider)new MethodsViewContentProvider(this));
        this.fMethodsViewer.setLabelProvider((IBaseLabelProvider)new MethodsViewLabelProvider(this));
        TableColumn column = new TableColumn(this.fMethodsViewer.getTable(), 16384);
        column.setText("Name");
        column.setWidth(400);
        this.fMethodsViewer.getTable().setHeaderVisible(true);
        Table control = this.fMethodsViewer.getTable();
        this.fMethodsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EmfaticASTNode landingPlace;
                if (!(event.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                if (!(ssel.getFirstElement() instanceof EObject)) {
                    return;
                }
                EObject eO = (EObject)ssel.getFirstElement();
                EmfaticEditor editor = TypesView.this.getActiveEmfaticEditor();
                if (editor != null && (landingPlace = EmfaticHyperlinkDetector.getLandingPlace(eO, editor)) != null) {
                    editor.setSelection(landingPlace, true);
                    editor.setFocus();
                }
            }
        });
        return control;
    }

    private Control createTypeViewerControl(Composite parent) {
        this.fViewerbook = new PageBook(parent, 0);
        this.typesViewer = new TreeViewer((Composite)this.fViewerbook, 770);
        this.typesViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof EClass && e2 instanceof EClass) {
                    EClass eC1 = (EClass)e1;
                    EClass eC2 = (EClass)e2;
                    return eC1.getName().compareToIgnoreCase(eC2.getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.typesViewer.setContentProvider((IContentProvider)new TypesViewContentProvider(this));
        this.typesViewer.setLabelProvider((IBaseLabelProvider)new TypesViewLabelProvider());
        return this.fViewerbook;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSupertypeH);
        manager.add((IAction)this.actionSubtypeH);
        manager.add((IContributionItem)new Separator());
    }

    private void makeTypeViewerActions() {
        this.actionSupertypeH = new Action("Show the supertype hierarchy", 2){

            public void run() {
                TypesView.this.actionSubtypeH.setChecked(!TypesView.this.actionSupertypeH.isChecked());
                TypesView.this.fMethodsViewer.setInput(null);
                TypesView.this.typesViewer.refresh();
            }
        };
        this.actionSupertypeH.setToolTipText("Show the supertype hierarchy");
        this.actionSupertypeH.setImageDescriptor(EmfaticUIPlugin.getImageDescriptor("typesView/super_co"));
        this.actionSupertypeH.setChecked(false);
        this.actionSubtypeH = new Action("Show the subtype hierarchy", 2){

            public void run() {
                TypesView.this.actionSupertypeH.setChecked(!TypesView.this.actionSubtypeH.isChecked());
                TypesView.this.fMethodsViewer.setInput(null);
                TypesView.this.typesViewer.refresh();
            }
        };
        this.actionSubtypeH.setText("Show the subtype hierarchy");
        this.actionSubtypeH.setToolTipText("Show the subtype hierarchy");
        this.actionSubtypeH.setImageDescriptor(EmfaticUIPlugin.getImageDescriptor("typesView/sub_co"));
        this.actionSubtypeH.setChecked(true);
        this.doubleClickAction = new TypesViewDoubleClick(this, this.typesViewer);
    }

    private void hookTypeViewerClickActions() {
        this.typesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TypesView.this.doubleClickAction.run();
            }
        });
        this.typesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                if (!(ssel.getFirstElement() instanceof EClass)) {
                    TypesView.this.fMethodsViewer.setInput(null);
                    return;
                }
                EClass eC = (EClass)ssel.getFirstElement();
                TypesView.this.fMethodsViewer.setInput((Object)eC);
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.typesViewer.getControl().getShell(), (String)"Types View", (String)message);
    }

    public void setFocus() {
        this.fPagebook.setFocus();
    }

    public void setInput(WeakReference<EClass> wrC, boolean navigateInEditor) {
        EClass eC = (EClass)wrC.get();
        this._currentClassifier = this.getQualifiedName((EClassifier)eC);
        this.typesViewer.setInput(wrC);
        this.fPagebook.showPage((Control)this.fTypeMethodsSplitter);
        this.fViewerbook.showPage(this.typesViewer.getControl());
        this.typesViewer.getTree().setFocus();
    }

    private String getQualifiedName(EClassifier eC) {
        String res = eC.getName();
        EPackage eP = eC.getEPackage();
        do {
            res = String.valueOf(eP.getName()) + "." + res;
        } while ((eP = eP.getESuperPackage()) != null);
        return res;
    }

    public boolean show(ShowInContext context) {
        if (context == null) {
            return false;
        }
        if (!(context.getSelection() instanceof ITextSelection)) {
            return false;
        }
        if (!(context.getInput() instanceof IFile)) {
            return false;
        }
        EmfaticEditor editor = this.getActiveEmfaticEditor();
        if (editor == null) {
            return false;
        }
        ITextSelection ts = (ITextSelection)context.getSelection();
        int offset = ts.getOffset();
        int length = ts.getLength();
        EmfaticEditor.ReferedEcoreDecl red = editor.getReferedEcoreDecl(offset, length);
        EObject ecoreDecl = null;
        if (red == null || red.ecoreDecl == null) {
            EmfaticASTNode n = editor.getClosestEnclosingASTNodeAt(offset, ClassDecl.class);
            ecoreDecl = (EObject)editor.getCstDecl2EcoreAST().get((Object)n);
            if (ecoreDecl == null) {
                return false;
            }
        } else {
            ecoreDecl = red.ecoreDecl;
        }
        if (!(ecoreDecl instanceof EClass)) {
            return false;
        }
        EClass eC = (EClass)ecoreDecl;
        WeakReference<EClass> wrC = new WeakReference<EClass>(eC);
        this.setInput(wrC, false);
        return true;
    }

    EmfaticEditor getEditor(IFile f) {
        IWorkbenchPage[] wps;
        IWorkbenchPage[] iWorkbenchPageArray = wps = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        int n = wps.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart[] edsInPage;
            IWorkbenchPage wp = iWorkbenchPageArray[n2];
            IEditorPart[] iEditorPartArray = edsInPage = wp.getEditors();
            int n3 = edsInPage.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorPart ep = iEditorPartArray[n4];
                if (ep instanceof EmfaticEditor) {
                    EmfaticEditor ee = (EmfaticEditor)ep;
                    if (!(ee.getEditorInput() instanceof FileEditorInput)) {
                        return null;
                    }
                    FileEditorInput fei = (FileEditorInput)ee.getEditorInput();
                    if (fei.getFile() == f) {
                        return ee;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    EmfaticEditor getActiveEmfaticEditor() {
        IEditorPart ep = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (ep instanceof EmfaticEditor) {
            EmfaticEditor ee = (EmfaticEditor)ep;
            return ee;
        }
        return null;
    }

    public Object getTypesViewerInput() {
        Object i = this.typesViewer.getInput();
        return i;
    }

    public boolean isShowinSuperTypeHierarchy() {
        return this.actionSupertypeH.isChecked();
    }

    public boolean isShowingInheritedMembers() {
        return this.fShowInheritedMembersAction.isChecked();
    }

    public boolean isSortingByDefiningType() {
        return this.fSortByDefiningTypeAction.isChecked();
    }
}

