/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

public class EMapSerializer
extends JsonSerializer<EList<Map.Entry<?, ?>>> {
    private final MapSerializer delegate;

    public EMapSerializer(MapSerializer delegateMapSerialize) {
        this.delegate = delegateMapSerialize;
    }

    public void serialize(EList<Map.Entry<?, ?>> value, JsonGenerator jg, SerializerProvider serializers) throws IOException {
        if (value == null || value.isEmpty()) {
            jg.writeNull();
        } else if (value instanceof EMap) {
            this.delegate.serialize(((EMap)value).map(), jg, serializers);
        } else {
            jg.writeStartObject();
            for (Map.Entry entry : value) {
                String key = Optional.ofNullable(entry.getKey()).orElse("");
                this.delegate.getKeySerializer().serialize((Object)key, jg, serializers);
                Object objectValue = entry.getValue();
                this.delegate.getContentSerializer().serialize(objectValue, jg, serializers);
            }
            jg.writeEndObject();
        }
    }
}

