/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.observer;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.exceptions.ECPProjectWithNameExistsException;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProvider;
import org.eclipse.emf.ecp.emfstore.internal.ui.observer.Messages;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.observer.ESCheckoutObserver;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class CheckoutObserver
implements ESCheckoutObserver {
    public void checkoutDone(ESLocalProject project) {
        if ("log_error_checksum_debug_checkout".equals(project.getProjectName())) {
            return;
        }
        ECPRepository repository = EMFStoreProvider.INSTANCE.getRepository(project.getUsersession().getServer());
        boolean ecpProjectExists = false;
        boolean validProjectName = false;
        for (ECPProject ecpProject : ECPUtil.getECPProjectManager().getProjects()) {
            InternalProject internalProject = (InternalProject)ecpProject;
            Object localProject = internalProject.getProviderSpecificData();
            if (!(localProject instanceof ESLocalProject) || localProject != project) continue;
            ecpProjectExists = true;
            break;
        }
        String projectName = project.getProjectName();
        if (!ecpProjectExists) {
            while (!validProjectName) {
                try {
                    ECPUtil.getECPProjectManager().createProject(repository, projectName, this.createECPProperties(project));
                    validProjectName = true;
                }
                catch (ECPProjectWithNameExistsException eCPProjectWithNameExistsException) {
                    InputDialog id = new InputDialog(Display.getCurrent().getActiveShell(), Messages.CheckoutObserver_CreateProject, Messages.CheckoutObserver_EnterNameForProject, String.valueOf(project.getProjectName()) + "@" + this.createDateString(), new IInputValidator(){

                        public String isValid(String newText) {
                            if (ECPUtil.getECPProjectManager().getProject(newText) == null) {
                                return null;
                            }
                            return Messages.CheckoutObserver_ProjectWithNameExists;
                        }
                    });
                    int inputResult = id.open();
                    projectName = inputResult != 0 ? String.valueOf(project.getProjectName()) + "@" + this.createDateString() : id.getValue();
                }
            }
        }
    }

    private ECPProperties createECPProperties(ESLocalProject project) {
        ECPProperties projectProperties = ECPUtil.createProperties();
        projectProperties.addProperty("projectSpaceID", project.getLocalProjectId().getId());
        return projectProperties;
    }

    private String createDateString() {
        DateFormat format = DateFormat.getDateTimeInstance(3, 2);
        return format.format(new Date());
    }
}

