/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.decorators;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.osgi.framework.Bundle;

public class ModelElementDirtyDecorator
implements ILightweightLabelDecorator {
    private static final String DIRTY_ICON_PATH = "icons/dirty.png";
    private static ImageDescriptor descriptor;

    public void decorate(Object element, IDecoration decoration) {
        URL url = null;
        boolean dirty = false;
        if (element instanceof EObject) {
            EObject modelElement = (EObject)element;
            Project project = ModelUtil.getProject((EObject)modelElement);
            if (project == null) {
                return;
            }
            ProjectSpace projectSpace = ESWorkspaceProviderImpl.getProjectSpace((EObject)modelElement);
            if (projectSpace == null) {
                return;
            }
            ModelElementId modelElementId = project.getModelElementId(modelElement);
            if (modelElementId == null) {
                return;
            }
        }
        if (dirty) {
            if (descriptor == null) {
                url = FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.emf.ecp.common"), (IPath)new Path(DIRTY_ICON_PATH), null);
                descriptor = ImageDescriptor.createFromURL((URL)url);
            }
            decoration.addOverlay(descriptor, 2);
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

