/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.IPlotCommit;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.IPlotCommitProvider;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.PlotCommit;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.PlotLane;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotCommitProvider
implements IPlotCommitProvider {
    private IPlotCommit[] commits;
    private TreeSet<Integer> freePositions;
    private HashSet<PlotLane> activeLanes;
    private int positionsAllocated;
    private Map<HistoryInfo, IPlotCommit> commitForHistory = new LinkedHashMap<HistoryInfo, IPlotCommit>();
    private Map<Integer, IPlotCommit> commitForID;
    private int nextBranchColorIndex;
    private Map<String, Integer> colorForBranch = new LinkedHashMap<String, Integer>();
    private static List<Color> createdSaturatedColors = new LinkedList<Color>();
    private static List<Color> createdLightColors = new LinkedList<Color>();
    private static Color[] saturatedColors;
    private static Color[] lightColors;
    private static final Color[] COLORS_TRUNK;
    private Map<Integer, IPlotCommit> dummyParentForId = new LinkedHashMap<Integer, IPlotCommit>();

    static {
        COLORS_TRUNK = new Color[]{Display.getDefault().getSystemColor(2), PlotCommitProvider.createLightColor(Display.getDefault().getSystemColor(15))};
        PlotCommitProvider.setUpSaturatedColors();
        PlotCommitProvider.setUpLightColors();
    }

    public PlotCommitProvider() {
        this.reset(null);
    }

    public void reset(List<HistoryInfo> infos) {
        this.nextBranchColorIndex = 0;
        this.freePositions = new TreeSet();
        this.activeLanes = new LinkedHashSet<PlotLane>(32);
        this.commitForHistory = new LinkedHashMap<HistoryInfo, IPlotCommit>();
        if (infos != null) {
            this.refresh(infos);
        }
    }

    @Override
    public void refresh(List<HistoryInfo> newInfos) {
        this.positionsAllocated = 0;
        this.commits = new PlotCommit[newInfos.size()];
        this.freePositions.clear();
        this.activeLanes.clear();
        this.commitForHistory.clear();
        this.dummyParentForId.clear();
        int i = 0;
        while (i < newInfos.size()) {
            this.commits[i] = new PlotCommit(newInfos.get(i));
            this.commitForHistory.put(newInfos.get(i), this.commits[i]);
            Color[] branchColors = this.getColorsForBranch(this.commits[i].getBranch());
            this.commits[i].setColor(branchColors[0]);
            this.commits[i].setLightColor(branchColors[1]);
            ++i;
        }
        this.setupCommitIdLookUp();
        this.setupParents(newInfos);
        this.commits = this.insertDummyParents(this.dummyParentForId.values().toArray(new IPlotCommit[0]), this.commits);
        i = 0;
        while (i < this.commits.length) {
            this.initCommit(i, this.commits[i]);
            ++i;
        }
    }

    private IPlotCommit[] insertDummyParents(IPlotCommit[] dummyParents, IPlotCommit[] realCommits) {
        IPlotCommit[] wholeArray = new IPlotCommit[dummyParents.length + realCommits.length];
        int i = 0;
        while (i < realCommits.length) {
            wholeArray[i] = realCommits[i];
            ++i;
        }
        int offsetForDummyParents = realCommits.length;
        int i2 = 0;
        while (i2 < dummyParents.length) {
            wholeArray[i2 + offsetForDummyParents] = dummyParents[i2];
            ++i2;
        }
        Arrays.sort(wholeArray, new Comparator<IPlotCommit>(){

            @Override
            public int compare(IPlotCommit arg0, IPlotCommit arg1) {
                if (arg0.getId() != -1 && arg1.getId() != -1) {
                    return arg1.getId() - arg0.getId();
                }
                if (arg0.getId() == -1) {
                    return -1;
                }
                return 1;
            }
        });
        return wholeArray;
    }

    private void setupCommitIdLookUp() {
        this.commitForID = new LinkedHashMap<Integer, IPlotCommit>();
        IPlotCommit[] iPlotCommitArray = this.commits;
        int n = this.commits.length;
        int n2 = 0;
        while (n2 < n) {
            IPlotCommit commit = iPlotCommitArray[n2];
            this.commitForID.put(commit.getId(), commit);
            ++n2;
        }
    }

    private static void setUpSaturatedColors() {
        saturatedColors = new Color[8];
        PlotCommitProvider.saturatedColors[0] = PlotCommitProvider.getSysColor(9);
        PlotCommitProvider.saturatedColors[1] = PlotCommitProvider.getSysColor(3);
        PlotCommitProvider.saturatedColors[2] = PlotCommitProvider.getSysColor(5);
        PlotCommitProvider.saturatedColors[3] = PlotCommitProvider.getSysColor(13);
        PlotCommitProvider.saturatedColors[4] = PlotCommitProvider.getSysColor(7);
        Color orange = new Color((Device)Display.getDefault(), 255, 148, 0);
        Color violet = new Color((Device)Display.getDefault(), 128, 0, 128);
        Color brown = new Color((Device)Display.getDefault(), 148, 64, 0);
        PlotCommitProvider.saturatedColors[5] = orange;
        PlotCommitProvider.saturatedColors[6] = violet;
        PlotCommitProvider.saturatedColors[7] = brown;
        createdSaturatedColors.add(orange);
        createdSaturatedColors.add(violet);
        createdSaturatedColors.add(brown);
    }

    private static void setUpLightColors() {
        lightColors = new Color[saturatedColors.length];
        int i = 0;
        while (i < saturatedColors.length) {
            PlotCommitProvider.lightColors[i] = PlotCommitProvider.createLightColor(saturatedColors[i]);
            ++i;
        }
    }

    private static Color getSysColor(int color) {
        return Display.getDefault().getSystemColor(color);
    }

    private static Color createLightColor(Color color) {
        float[] hsbColor = java.awt.Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        hsbColor[1] = hsbColor[1] * 0.2f;
        hsbColor[2] = hsbColor[2] * 1.1f;
        if (hsbColor[2] > 1.0f) {
            hsbColor[2] = 1.0f;
        }
        int lightColorRGB = java.awt.Color.HSBtoRGB(hsbColor[0], hsbColor[1], hsbColor[2]);
        java.awt.Color lightColor = new java.awt.Color(lightColorRGB);
        Color lightColorSWT = new Color((Device)Display.getDefault(), lightColor.getRed(), lightColor.getGreen(), lightColor.getBlue());
        createdLightColors.add(lightColorSWT);
        return lightColorSWT;
    }

    private Color[] getColorsForBranch(String branch) {
        String trunkIdentifier = "trunk";
        if (trunkIdentifier.equals(branch)) {
            return COLORS_TRUNK;
        }
        Integer colorIndex = this.colorForBranch.get(branch);
        if (colorIndex == null) {
            colorIndex = this.nextBranchColorIndex;
            this.colorForBranch.put(branch, colorIndex);
            this.nextBranchColorIndex = (this.nextBranchColorIndex + 1) % saturatedColors.length;
        }
        Color[] retColors = new Color[]{saturatedColors[colorIndex], lightColors[colorIndex]};
        return retColors;
    }

    private void setupParents(List<HistoryInfo> historyInfos) {
        int i = 0;
        while (i < historyInfos.size()) {
            PrimaryVersionSpec parentSpec;
            HistoryInfo currInfo = historyInfos.get(i);
            EList mergedFrom = currInfo.getMergedFrom();
            ArrayList<IPlotCommit> parents = new ArrayList<IPlotCommit>();
            if (mergedFrom != null && mergedFrom.size() >= 1) {
                for (PrimaryVersionSpec mergeParent : mergedFrom) {
                    if (this.commitForID.containsKey(mergeParent.getIdentifier())) {
                        parents.add(this.commitForID.get(mergeParent.getIdentifier()));
                        continue;
                    }
                    parents.add(this.getDummyParent(mergeParent.getIdentifier(), mergeParent.getBranch()));
                }
                this.commits[i].setParents(parents);
            }
            if ((parentSpec = currInfo.getPreviousSpec()) != null) {
                if (this.commitForID.containsKey(parentSpec.getIdentifier())) {
                    parents.add(this.commitForID.get(parentSpec.getIdentifier()));
                } else {
                    parents.add(this.getDummyParent(parentSpec.getIdentifier(), parentSpec.getBranch()));
                }
            }
            if (!parents.isEmpty()) {
                this.commits[i].setParents(parents);
            }
            ++i;
        }
    }

    private void initCommit(int index, IPlotCommit currCommit) {
        this.setupChildren(currCommit);
        int nChildren = currCommit.getChildCount();
        if (nChildren == 0) {
            return;
        }
        if (nChildren == 1 && currCommit.getChild(0).getParentCount() < 2 && !currCommit.getChild(0).getBranch().equals(currCommit.getBranch())) {
            IPlotCommit c = currCommit.getChild(0);
            if (c.getLane() == null) {
                PlotLane lane = this.nextFreeLane();
                lane.setSaturatedColor(c.getColor());
                lane.setLightColor(c.getLightColor());
                c.setLane(lane);
                this.activeLanes.add(c.getLane());
            }
            int r = index - 1;
            while (r >= 0) {
                IPlotCommit rObj = this.commits[r];
                if (rObj == c) break;
                rObj.addPassingLane(c.getLane());
                --r;
            }
            currCommit.setLane(c.getLane());
            this.handleBlockedLanes(index, currCommit, nChildren);
        } else {
            PlotLane reservedLane = null;
            int i = 0;
            while (i < nChildren) {
                IPlotCommit c = currCommit.getChild(i);
                if (c.getLane() == null) {
                    PlotLane lane = this.nextFreeLane();
                    lane.setSaturatedColor(c.getColor());
                    lane.setLightColor(c.getLightColor());
                    c.setLane(lane);
                    this.activeLanes.add(c.getLane());
                    if (reservedLane != null) {
                        this.closeLane(c.getLane());
                    } else {
                        reservedLane = c.getLane();
                    }
                } else if (reservedLane == null && this.activeLanes.contains(c.getLane())) {
                    reservedLane = c.getLane();
                } else {
                    this.closeLane(c.getLane());
                }
                ++i;
            }
            if (reservedLane != null) {
                this.closeLane(reservedLane);
            }
            PlotLane lane = this.nextFreeLane();
            lane.setSaturatedColor(currCommit.getColor());
            lane.setLightColor(currCommit.getLightColor());
            currCommit.setLane(lane);
            this.activeLanes.add(currCommit.getLane());
            this.handleBlockedLanes(index, currCommit, nChildren);
        }
    }

    private void setupChildren(IPlotCommit currCommit) {
        int nParents = currCommit.getParentCount();
        int i = 0;
        while (i < nParents) {
            currCommit.getParent(i).addChild(currCommit);
            ++i;
        }
    }

    private PlotLane nextFreeLane() {
        PlotLane p = new PlotLane();
        if (this.freePositions.isEmpty()) {
            p.setPosition(this.positionsAllocated++);
        } else {
            Integer min = this.freePositions.first();
            p.setPosition(min);
            this.freePositions.remove(min);
        }
        return p;
    }

    private void handleBlockedLanes(int index, IPlotCommit commit, int nChildren) {
        int remaining = nChildren;
        BitSet blockedPositions = new BitSet();
        int r = index - 1;
        while (r >= 0) {
            IPlotCommit rObj = this.commits[r];
            if (commit.isChild(rObj) && --remaining == 0) break;
            if (rObj != null) {
                PlotLane lane = rObj.getLane();
                if (lane != null) {
                    blockedPositions.set(lane.getPosition());
                }
                rObj.addPassingLane(commit.getLane());
            }
            --r;
        }
        if (blockedPositions.get(commit.getLane().getPosition())) {
            int newPos = -1;
            for (Integer pos : this.freePositions) {
                if (blockedPositions.get(pos)) continue;
                newPos = pos;
                break;
            }
            if (newPos == -1) {
                newPos = this.positionsAllocated++;
            }
            this.freePositions.add(commit.getLane().getPosition());
            this.activeLanes.remove(commit.getLane());
            commit.getLane().setPosition(newPos);
            this.activeLanes.add(commit.getLane());
        }
    }

    private void closeLane(PlotLane lane) {
        if (this.activeLanes.remove(lane)) {
            this.freePositions.add(lane.getPosition());
        }
    }

    @Override
    public IPlotCommit getCommitFor(HistoryInfo info, boolean onlyAChildRequest) {
        IPlotCommit comForInfo = this.commitForHistory.get(info);
        comForInfo.setIsRealCommit(!onlyAChildRequest);
        return comForInfo;
    }

    private IPlotCommit getDummyParent(int id, String parentBranch) {
        if (!this.dummyParentForId.containsKey(id)) {
            PlotCommit dummyParent = new PlotCommit(id, parentBranch);
            Color[] colors = this.getColorsForBranch(parentBranch);
            dummyParent.setColor(colors[1]);
            dummyParent.setLightColor(colors[1]);
            this.dummyParentForId.put(id, dummyParent);
        }
        return this.dummyParentForId.get(id);
    }
}

