/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.common.internal.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.model.common.spi.databinding.DatabindingProviderService;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

public class FeaturePathDatabindingProviderService
implements DatabindingProviderService<VFeaturePathDomainModelReference> {
    @Override
    public <O extends IObservable> O getObservable(VFeaturePathDomainModelReference domainModelReference, Class<O> observableClass) {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The DomainModelReference must not be null.");
        }
        if (!observableClass.isAssignableFrom(IObservableValue.class)) {
            throw new IllegalArgumentException("A FeaturePathDomainModelReference can't provide " + observableClass.getName());
        }
        EStructuralFeature.Setting lastSetting = this.getSetting((VDomainModelReference)domainModelReference, SettingOption.Last);
        return (O)EMFEditObservables.observeValue((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)lastSetting.getEObject()), (EObject)lastSetting.getEObject(), (EStructuralFeature)lastSetting.getEStructuralFeature());
    }

    @Override
    public <P extends IProperty> P getProperty(VFeaturePathDomainModelReference domainModelReference, Class<P> propertyClass) {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The DomainModelReference must not be null.");
        }
        if (!propertyClass.isAssignableFrom(IValueProperty.class)) {
            throw new IllegalArgumentException("A FeaturePathDomainModelReference can't provide " + propertyClass.getName());
        }
        ArrayList<EStructuralFeature> fullList = new ArrayList<EStructuralFeature>((Collection<EStructuralFeature>)domainModelReference.getDomainModelEReferencePath());
        fullList.add(domainModelReference.getDomainModelEFeature());
        FeaturePath featurePath = FeaturePath.fromList((EStructuralFeature[])fullList.toArray(new EStructuralFeature[0]));
        EStructuralFeature.Setting setting = this.getLastSettingForProperty(domainModelReference);
        return (P)(setting == null ? EMFProperties.value((FeaturePath)featurePath) : EMFEditProperties.value((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)setting.getEObject()), (FeaturePath)featurePath));
    }

    private EStructuralFeature.Setting getLastSettingForProperty(VFeaturePathDomainModelReference domainModelReference) {
        try {
            return this.getSetting((VDomainModelReference)domainModelReference, SettingOption.Last);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!VDomainModelReference.class.isInstance(domainModelReference.eContainer())) {
                return null;
            }
            try {
                return this.getSetting((VDomainModelReference)domainModelReference.eContainer(), SettingOption.First);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
    }

    private EStructuralFeature.Setting getSetting(VDomainModelReference domainModelReference, SettingOption option) {
        Iterator iterator = domainModelReference.getIterator();
        if (iterator == null) {
            throw new IllegalArgumentException("The DomainModelReference must be resolved.");
        }
        switch (option) {
            case Last: {
                EStructuralFeature.Setting lastSetting = null;
                int numberSettings = 0;
                while (iterator.hasNext()) {
                    lastSetting = (EStructuralFeature.Setting)iterator.next();
                    ++numberSettings;
                }
                if (lastSetting == null || numberSettings != 1) {
                    throw new IllegalArgumentException("The DomainModelReference must be resolved.");
                }
                return lastSetting;
            }
            case First: {
                if (iterator.hasNext()) {
                    return (EStructuralFeature.Setting)iterator.next();
                }
                throw new IllegalArgumentException("The DomainModelReference must be resolved.");
            }
        }
        throw new IllegalArgumentException("Unknown option.");
    }

    private static enum SettingOption {
        First,
        Last;

    }
}

