/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.internal.tooling.controls;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.template.internal.tooling.Messages;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class HexColorSelectionControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    protected Binding[] createBindings(Control control, EStructuralFeature.Setting setting) {
        Composite composite = (Composite)Composite.class.cast(control);
        Control childControl = composite.getChildren()[0];
        ISWTObservableValue value = SWTObservables.observeBackground((Control)childControl);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(setting), new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return null;
                }
                return HexColorSelectionControlSWTRenderer.this.getString(((Color)Color.class.cast(value)).getRGB());
            }
        }, new UpdateValueStrategy(){

            public Object convert(Object value) {
                String hexString = (String)value;
                if (hexString == null) {
                    return null;
                }
                int red = Integer.parseInt(hexString.substring(0, 2), 16);
                int green = Integer.parseInt(hexString.substring(2, 4), 16);
                int blue = Integer.parseInt(hexString.substring(4, 6), 16);
                Color color = new Color((Device)Display.getCurrent(), red, green, blue);
                return color;
            }
        });
        ISWTObservableValue textValue = SWTObservables.observeTooltipText((Control)childControl);
        Binding textBinding = this.getDataBindingContext().bindValue((IObservableValue)textValue, this.getModelValue(setting));
        return new Binding[]{binding, textBinding};
    }

    protected Control createSWTControl(final Composite parent, final EStructuralFeature.Setting setting) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
        Label colorExample = new Label(composite, 2048);
        GridDataFactory.fillDefaults().align(1, 4).grab(false, false).hint(40, -1).applyTo((Control)colorExample);
        Button selectColorBtn = new Button(composite, 8);
        GridDataFactory.fillDefaults().align(1, 4).grab(false, false).applyTo((Control)selectColorBtn);
        selectColorBtn.setText(Messages.HexColorSelectionControlSWTRenderer_SelectColorBtn);
        selectColorBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ColorDialog cd = new ColorDialog(parent.getShell());
                RGB rgb = cd.open();
                HexColorSelectionControlSWTRenderer.this.setValue(HexColorSelectionControlSWTRenderer.this.getString(rgb), setting);
            }
        });
        return composite;
    }

    private String getString(RGB rgb) {
        String red = Integer.toHexString(0x100 | rgb.red).substring(1);
        String green = Integer.toHexString(0x100 | rgb.green).substring(1);
        String blue = Integer.toHexString(0x100 | rgb.blue).substring(1);
        return String.valueOf(red) + green + blue;
    }

    private void setValue(String hexColor, EStructuralFeature.Setting setting) {
        EditingDomain editingDomain = this.getEditingDomain(setting);
        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)setting.getEObject(), (Object)setting.getEStructuralFeature(), (Object)hexColor);
        editingDomain.getCommandStack().execute(command);
    }

    protected String getUnsetText() {
        return null;
    }
}

