/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.internal.tooling.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ValueSelectionHelper {
    public static Object getValueSelectionDialog(Shell shell, EStructuralFeature structuralFeature) {
        if (structuralFeature == null) {
            return null;
        }
        if (EReference.class.isInstance(structuralFeature)) {
            return null;
        }
        EAttribute attribute = (EAttribute)structuralFeature;
        Class attribuetClazz = attribute.getEAttributeType().getInstanceClass();
        if (attribuetClazz.isPrimitive()) {
            if (Integer.TYPE.isAssignableFrom(attribuetClazz)) {
                attribuetClazz = Integer.class;
            } else if (Long.TYPE.isAssignableFrom(attribuetClazz)) {
                attribuetClazz = Long.class;
            } else if (Float.TYPE.isAssignableFrom(attribuetClazz)) {
                attribuetClazz = Float.class;
            } else if (Double.TYPE.isAssignableFrom(attribuetClazz)) {
                attribuetClazz = Double.class;
            } else if (Boolean.TYPE.isAssignableFrom(attribuetClazz)) {
                attribuetClazz = Boolean.class;
            } else if (Character.TYPE.isAssignableFrom(attribuetClazz)) {
                attribuetClazz = Character.class;
            }
        }
        Object object = null;
        if (Enum.class.isAssignableFrom(attribuetClazz)) {
            T[] enumValues = attribuetClazz.getEnumConstants();
            ListDialog ld = new ListDialog(shell);
            ld.setLabelProvider((ILabelProvider)new LabelProvider());
            ld.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            ld.setInput(enumValues);
            ld.setInitialSelections(new Object[]{enumValues[0]});
            ld.setMessage("Please select the enum value to set.");
            ld.setTitle("Select a value");
            int enumSelectionResult = ld.open();
            if (enumSelectionResult == 0) {
                object = ld.getResult()[0];
            }
        } else if (String.class.isAssignableFrom(attribuetClazz) || Number.class.isAssignableFrom(attribuetClazz) || Boolean.class.isAssignableFrom(attribuetClazz)) {
            try {
                Constructor constructor = attribuetClazz.getConstructor(String.class);
                InputDialog id = new InputDialog(shell, "Insert the value", "The value must be parseable by the " + attribuetClazz.getSimpleName() + " class. For a double value please use the #.# format. For boolean values 'true' or 'false'.", null, null);
                int inputResult = id.open();
                if (inputResult == 0) {
                    object = constructor.newInstance(id.getValue());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            MessageDialog.openError((Shell)shell, (String)"Not primitive Attribute selected", (String)"The selected attribute has a not primitive type. We can't provide you support for it!");
        }
        return object;
    }
}

