/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edapt.common.MetamodelExtent;
import org.eclipse.emf.edapt.history.reconstruction.BackwardReconstructorBase;
import org.eclipse.emf.edapt.history.reconstruction.EcoreReconstructorSwitchBase;
import org.eclipse.emf.edapt.history.reconstruction.Mapping;
import org.eclipse.emf.edapt.spi.history.Add;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.CompositeChange;
import org.eclipse.emf.edapt.spi.history.Create;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.Move;
import org.eclipse.emf.edapt.spi.history.Remove;
import org.eclipse.emf.edapt.spi.history.Set;

public class EcoreBackwardReconstructor
extends BackwardReconstructorBase {
    private final URI folder;
    private EcoreReconstructorSwitch ecoreSwitch;

    public EcoreBackwardReconstructor(URI folder) {
        this.folder = folder;
    }

    public void init(Mapping mapping, MetamodelExtent extent) {
        this.ecoreSwitch = new EcoreReconstructorSwitch();
        for (EPackage p : extent.getRootPackages()) {
            String filename = mapping.getSource((EObject)p).eResource().getURI().lastSegment();
            URI uri = this.folder.appendSegment(filename);
            Resource resource = this.resourceSet.getResource(uri, false);
            if (resource == null) {
                resource = this.resourceSet.createResource(uri);
            }
            resource.getContents().add((Object)p);
        }
        super.init(mapping, extent);
    }

    public void startChange(Change change) {
        super.startChange(change);
        if (change instanceof Create) {
            this.ecoreSwitch.doSwitch(change);
        }
    }

    public void endChange(Change change) {
        super.endChange(change);
        if (!(change instanceof Create)) {
            this.ecoreSwitch.doSwitch(change);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EcoreReconstructorSwitch
    extends EcoreReconstructorSwitchBase<Object> {
        private EcoreReconstructorSwitch() {
        }

        @Override
        public Object caseSet(Set operation) {
            EObject element = EcoreBackwardReconstructor.this.mapping.getTarget(operation.getElement());
            EStructuralFeature feature = operation.getFeature();
            Object value = EcoreBackwardReconstructor.this.mapping.resolveTarget(operation.getOldValue());
            this.set(element, feature, value);
            return operation;
        }

        @Override
        public Object caseCreate(Create operation) {
            EObject element = EcoreBackwardReconstructor.this.mapping.getTarget(operation.getElement());
            Resource toRemove = null;
            if (operation.getTarget() == null && element.eResource().getContents().size() == 1) {
                toRemove = element.eResource();
            }
            this.delete(element);
            if (toRemove != null) {
                EcoreBackwardReconstructor.this.resourceSet.getResources().remove((Object)toRemove);
            }
            return operation;
        }

        @Override
        public Object caseDelete(Delete operation) {
            EObject target = EcoreBackwardReconstructor.this.mapping.getTarget(operation.getTarget());
            EReference reference = operation.getReference();
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            EObject reproducedElement = copier.copy(operation.getElement());
            copier.copyReferences();
            for (Map.Entry entry : copier.entrySet()) {
                EcoreBackwardReconstructor.this.mapping.map((EObject)entry.getKey(), (EObject)entry.getValue());
                EcoreBackwardReconstructor.this.extent.addToExtent((EObject)entry.getValue());
            }
            this.add(target, (EStructuralFeature)reference, reproducedElement);
            return operation;
        }

        @Override
        public Object caseMove(Move operation) {
            EObject element = EcoreBackwardReconstructor.this.mapping.getTarget(operation.getElement());
            EObject source = EcoreBackwardReconstructor.this.mapping.getTarget(operation.getSource());
            EReference reference = operation.getReference();
            this.move(element, source, reference);
            return operation;
        }

        @Override
        public Object caseAdd(Add operation) {
            EObject element = EcoreBackwardReconstructor.this.mapping.getTarget(operation.getElement());
            Object value = EcoreBackwardReconstructor.this.mapping.resolveTarget(operation.getValue());
            EStructuralFeature feature = operation.getFeature();
            this.remove(element, feature, value);
            return operation;
        }

        @Override
        public Object caseRemove(Remove operation) {
            EObject element = EcoreBackwardReconstructor.this.mapping.getTarget(operation.getElement());
            Object value = EcoreBackwardReconstructor.this.mapping.resolveTarget(operation.getValue());
            EStructuralFeature feature = operation.getFeature();
            this.add(element, feature, value);
            return operation;
        }

        @Override
        public Object caseCompositeChange(CompositeChange operation) {
            return operation;
        }
    }
}

