/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.util;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edapt.common.ResourceUtils;
import org.eclipse.emf.edapt.common.URIUtils;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.Release;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HistoryUtils {
    private static final String HISTORY_ANNOTATION_SOURCE = "http://www.eclipse.org/edapt";
    private static final String HISTORY_ANNOTATION_KEY = "historyURI";
    public static final String HISTORY_FILE_EXTENSION = "history";

    private HistoryUtils() {
    }

    public static Resource getRootResource(ResourceSet resourceSet) {
        Resource resource = HistoryUtils.getHistoryResource(resourceSet);
        History history = (History)resource.getContents().get(0);
        EPackage rootPackage = (EPackage)history.getRootPackages().get(0);
        return rootPackage.eResource();
    }

    public static Resource getHistoryResource(ResourceSet resourceSet) {
        for (Resource resource : resourceSet.getResources()) {
            String extension = resource.getURI().fileExtension();
            if (!HISTORY_FILE_EXTENSION.equals(extension)) continue;
            return resource;
        }
        return null;
    }

    public static URI getHistoryURI(Resource metamodelResource) {
        EPackage p;
        String value;
        URI metamodelURI = metamodelResource.getURI();
        List packages = ResourceUtils.getRootElements((Resource)metamodelResource, EPackage.class);
        if (!packages.isEmpty() && (value = EcoreUtil.getAnnotation((EModelElement)(p = (EPackage)packages.get(0)), (String)HISTORY_ANNOTATION_SOURCE, (String)HISTORY_ANNOTATION_KEY)) != null) {
            URI relativeURI = URI.createFileURI((String)value);
            URI historyURI = relativeURI.resolve(metamodelURI);
            return historyURI;
        }
        return HistoryUtils.getDefaultHistoryURI(metamodelResource);
    }

    public static URI getDefaultHistoryURI(Resource metamodelResource) {
        return URIUtils.replaceExtension((URI)metamodelResource.getURI(), (String)HISTORY_FILE_EXTENSION);
    }

    public static void setHistoryURI(Resource metamodelResource, URI historyURI) {
        if (HistoryUtils.getDefaultHistoryURI(metamodelResource).equals(historyURI)) {
            return;
        }
        List packages = ResourceUtils.getRootElements((Resource)metamodelResource, EPackage.class);
        if (!packages.isEmpty()) {
            URI relativeURI = URIUtils.getRelativePath((URI)historyURI, (URI)metamodelResource.getURI());
            EPackage p = (EPackage)packages.get(0);
            EcoreUtil.setAnnotation((EModelElement)p, (String)HISTORY_ANNOTATION_SOURCE, (String)HISTORY_ANNOTATION_KEY, (String)relativeURI.toString());
        }
    }

    public static Release getRelease(Collection<Release> releases, int number) {
        for (Release release : releases) {
            if (release.getNumber() != number) continue;
            return release;
        }
        return null;
    }

    public static Release getMinimumRelease(Set<Release> releases) {
        Release minRelease = null;
        for (Release release : releases) {
            if (minRelease == null) {
                minRelease = release;
                continue;
            }
            if (release.getNumber() >= minRelease.getNumber()) continue;
            minRelease = release;
        }
        return minRelease;
    }
}

