/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.filetransfer;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileDownloadStatus;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileTransferJob;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.FileTransferManager;
import org.eclipse.emf.emfstore.internal.client.model.filetransfer.Messages;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FilePartitionerUtil;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.internal.server.model.FileIdentifier;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

public class FileDownloadJob
extends FileTransferJob {
    private final FileDownloadStatus status;

    FileDownloadJob(FileDownloadStatus status, FileTransferManager transferManager, FileIdentifier fileId, boolean isTriggeredByUI) {
        super(transferManager, new FileTransferInformation(fileId, -1), Messages.FileDownloadJob_FileDownload);
        this.setUser(isTriggeredByUI);
        this.status = status;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.getConnectionAttributes();
            this.setFile(this.getCache().createTempFile(this.getFileId()));
            if (!this.executeTransfer(monitor)) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        catch (ESException e) {
            IStatus iStatus = this.registerException((Exception)((Object)e));
            return iStatus;
        }
        catch (IOException e) {
            IStatus iStatus = this.registerException(e);
            return iStatus;
        }
        catch (RuntimeException e) {
            IStatus iStatus = this.registerException(e);
            return iStatus;
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private IStatus registerException(Exception e) {
        this.status.transferFailed(e);
        this.setException(e);
        return Status.CANCEL_STATUS;
    }

    private boolean executeTransfer(IProgressMonitor monitor) throws RemoteException, ESException {
        FileChunk fileChunk = null;
        fileChunk = this.getConnectionManager().downloadFileChunk(this.getSessionId(), this.getProjectId(), this.getFileInformation());
        this.getFileInformation().setFileSize(fileChunk.getFileSize());
        this.initializeMonitor(monitor);
        this.status.transferStarted(fileChunk.getFileSize());
        do {
            fileChunk = this.getConnectionManager().downloadFileChunk(this.getSessionId(), this.getProjectId(), this.getFileInformation());
            FilePartitionerUtil.writeChunk((File)this.getFile(), (FileChunk)fileChunk);
            monitor.worked(1);
            this.incrementChunkNumber();
            if (!this.isCanceled()) continue;
            this.status.transferCancelled();
            return false;
        } while (!fileChunk.isLast());
        File result = this.getCache().moveTempFileToCache(this.getFileId(), true);
        this.status.transferFinished(result);
        return true;
    }
}

