/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.operations.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiAttributeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.OperationsFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.OperationsPackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.UnkownFeatureException;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.impl.FeatureOperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiAttributeOperationImpl
extends FeatureOperationImpl
implements MultiAttributeOperation {
    protected static final boolean ADD_EDEFAULT = false;
    protected boolean add = false;
    protected EList<Integer> indexes;
    protected EList<Object> referencedValues;

    protected MultiAttributeOperationImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return OperationsPackage.Literals.MULTI_ATTRIBUTE_OPERATION;
    }

    @Override
    public boolean isAdd() {
        return this.add;
    }

    @Override
    public void setAdd(boolean newAdd) {
        boolean oldAdd = this.add;
        this.add = newAdd;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldAdd, this.add));
        }
    }

    @Override
    public EList<Integer> getIndexes() {
        if (this.indexes == null) {
            this.indexes = new EDataTypeUniqueEList(Integer.class, (InternalEObject)this, 7);
        }
        return this.indexes;
    }

    @Override
    public EList<Object> getReferencedValues() {
        if (this.referencedValues == null) {
            this.referencedValues = new EDataTypeEList(Object.class, (InternalEObject)this, 8);
        }
        return this.referencedValues;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.isAdd();
            }
            case 7: {
                return this.getIndexes();
            }
            case 8: {
                return this.getReferencedValues();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setAdd((Boolean)newValue);
                return;
            }
            case 7: {
                this.getIndexes().clear();
                this.getIndexes().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getReferencedValues().clear();
                this.getReferencedValues().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setAdd(false);
                return;
            }
            case 7: {
                this.getIndexes().clear();
                return;
            }
            case 8: {
                this.getReferencedValues().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return this.add;
            }
            case 7: {
                return this.indexes != null && !this.indexes.isEmpty();
            }
            case 8: {
                return this.referencedValues != null && !this.referencedValues.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (add: ");
        result.append(this.add);
        result.append(", indexes: ");
        result.append(this.indexes);
        result.append(", referencedValues: ");
        result.append(this.referencedValues);
        result.append(')');
        return result.toString();
    }

    @Override
    public void apply(IdEObjectCollection project) {
        EObject modelElement = project.getModelElement(this.getModelElementId());
        if (modelElement == null) {
            return;
        }
        if (this.getReferencedValues().size() != this.getIndexes().size()) {
            return;
        }
        try {
            EAttribute feature = (EAttribute)this.getFeature(modelElement);
            EList list = (EList)modelElement.eGet((EStructuralFeature)feature);
            switch (this.getUnset().getValue()) {
                case 1: {
                    modelElement.eUnset((EStructuralFeature)feature);
                    break;
                }
                case 0: 
                case 2: {
                    if (this.isAdd()) {
                        int i = 0;
                        while (i < this.getReferencedValues().size()) {
                            Object value = this.getReferencedValues().get(i);
                            int index = (Integer)this.getIndexes().get(i);
                            if (!feature.isUnique() || !list.contains(value)) {
                                if (index > -1 && list.size() >= index) {
                                    list.add(index, value);
                                } else {
                                    list.add(value);
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    int i = this.getIndexes().size() - 1;
                    while (i >= 0) {
                        int index = (Integer)this.getIndexes().get(i);
                        if (index >= 0 && list.size() > index) {
                            list.remove(index);
                        }
                        --i;
                    }
                    if (this.getIndexes().size() != 0 || this.getUnset().getValue() != 2) break;
                    modelElement.eSet((EStructuralFeature)feature, (Object)list);
                }
                default: {
                    break;
                }
            }
        }
        catch (UnkownFeatureException unkownFeatureException) {
            return;
        }
    }

    @Override
    public AbstractOperation reverse() {
        MultiAttributeOperation operation = OperationsFactory.eINSTANCE.createMultiAttributeOperation();
        super.reverse(operation);
        operation.setAdd(!this.isAdd());
        operation.getReferencedValues().addAll(this.getReferencedValues());
        operation.getIndexes().addAll(this.getIndexes());
        this.setUnsetForReverseOperation(operation);
        return operation;
    }
}

