/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.connectionmanager;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.server.exceptions.UnknownSessionException;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectionManager<T> {
    private final Map<SessionId, T> map = new LinkedHashMap<SessionId, T>();

    protected void addConnectionProxy(SessionId id, T connectionProxy) {
        this.map.put(id, connectionProxy);
    }

    protected void removeConnectionProxy(SessionId id) {
        this.map.remove(id);
    }

    protected T getConnectionProxy(SessionId id) throws UnknownSessionException {
        T connectionProxy = this.map.get(id);
        if (connectionProxy == null) {
            throw new UnknownSessionException(ConnectionManager.LOGIN_FIRST);
        }
        return connectionProxy;
    }

    protected Map<SessionId, T> getConnectionProxyMap() {
        return this.map;
    }

    public boolean hasConnectionProxy(SessionId id) {
        return this.map.get(id) != null;
    }
}

