/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.controller;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.callbacks.ESUpdateCallback;
import org.eclipse.emf.emfstore.client.exceptions.ESProjectNotSharedException;
import org.eclipse.emf.emfstore.client.observer.ESUpdateObserver;
import org.eclipse.emf.emfstore.common.model.ESModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.client.common.UnknownEMFStoreWorkloadCommand;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.ChangeConflictException;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ChangeConflictSet;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictDetector;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ModelElementIdToEObjectMappingImpl;
import org.eclipse.emf.emfstore.internal.server.impl.api.ESConflictSetImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.ESConflictSet;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateController
extends ServerCall<PrimaryVersionSpec> {
    private final VersionSpec version;
    private final ESUpdateCallback callback;

    public UpdateController(ProjectSpaceBase projectSpace, VersionSpec version, ESUpdateCallback callback, IProgressMonitor progress) {
        super(projectSpace);
        if (!projectSpace.isShared()) {
            throw new ESProjectNotSharedException();
        }
        if (version == null) {
            version = Versions.createHEAD((VersionSpec)projectSpace.getBaseVersion());
        }
        if (callback == null) {
            callback = ESUpdateCallback.NOCALLBACK;
        }
        this.version = version;
        this.callback = callback;
        this.setProgressMonitor(progress);
    }

    @Override
    protected PrimaryVersionSpec run() throws ESException {
        return this.doUpdate(this.version);
    }

    private PrimaryVersionSpec doUpdate(VersionSpec version) throws ChangeConflictException, ESException {
        ChangeConflictSet changeConflictSet;
        this.getProgressMonitor().beginTask(Messages.UpdateController_UpdatingProject, 100);
        this.getProgressMonitor().worked(1);
        this.getProgressMonitor().subTask(Messages.UpdateController_ResolvingNewVersion);
        PrimaryVersionSpec resolvedVersion = this.getProjectSpace().resolveVersionSpec(version, this.getProgressMonitor());
        if (this.equalsBaseVersion(resolvedVersion)) {
            return resolvedVersion;
        }
        this.getProgressMonitor().worked(5);
        if (this.getProgressMonitor().isCanceled()) {
            return this.getProjectSpace().getBaseVersion();
        }
        this.getProgressMonitor().subTask(Messages.UpdateController_FetchingChanges);
        List<ChangePackage> incomingChanges = this.getIncomingChanges(resolvedVersion);
        this.checkAndRemoveDuplicateOperations(incomingChanges, this.getProjectSpace().getLocalChangePackage());
        ChangePackage localChanges = this.getProjectSpace().getLocalChangePackage(false);
        ModelElementIdToEObjectMappingImpl idToEObjectMapping = new ModelElementIdToEObjectMappingImpl((ModelElementIdToEObjectMapping)this.getProjectSpace().getProject(), incomingChanges);
        idToEObjectMapping.put(localChanges);
        this.getProgressMonitor().worked(65);
        if (this.getProgressMonitor().isCanceled()) {
            return this.getProjectSpace().getBaseVersion();
        }
        this.getProgressMonitor().subTask(Messages.UpdateController_CheckingForConflicts);
        List copy = APIUtil.mapToAPI(ESChangePackage.class, incomingChanges);
        if (this.getProgressMonitor().isCanceled() || !this.callback.inspectChanges(this.getProjectSpace().toAPI(), copy, (ESModelElementIdToEObjectMapping)idToEObjectMapping.toAPI())) {
            return this.getProjectSpace().getBaseVersion();
        }
        ((ESUpdateObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESUpdateObserver.class, true)).inspectChanges(this.getProjectSpace().toAPI(), copy, this.getProgressMonitor());
        if (this.getProjectSpace().getOperations().size() > 0 && (changeConflictSet = this.calcConflicts(localChanges, incomingChanges, idToEObjectMapping)).getConflictBuckets().size() > 0) {
            this.getProgressMonitor().subTask(Messages.UpdateController_ConflictsDetected);
            if (this.callback.conflictOccurred((ESConflictSet)new ESConflictSetImpl(changeConflictSet), this.getProgressMonitor())) {
                localChanges = this.getProjectSpace().mergeResolvedConflicts(changeConflictSet, Collections.singletonList(localChanges), incomingChanges);
            } else {
                throw new ChangeConflictException(changeConflictSet);
            }
        }
        this.getProgressMonitor().worked(15);
        this.getProgressMonitor().subTask(Messages.UpdateController_ApplyingChanges);
        this.getProjectSpace().applyChanges(resolvedVersion, incomingChanges, localChanges, this.getProgressMonitor(), true);
        ((ESUpdateObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESUpdateObserver.class, true)).updateCompleted(this.getProjectSpace().toAPI(), this.getProgressMonitor());
        return this.getProjectSpace().getBaseVersion();
    }

    private void save(EObject eObject, String failureMsg) {
        try {
            if (eObject.eResource() != null) {
                eObject.eResource().save(ModelUtil.getResourceSaveOptions());
            }
        }
        catch (IOException ex) {
            ModelUtil.logException((String)failureMsg, (Throwable)ex);
        }
    }

    private boolean equalsBaseVersion(PrimaryVersionSpec resolvedVersion) {
        return resolvedVersion.compareTo((Object)this.getProjectSpace().getBaseVersion()) == 0;
    }

    private List<ChangePackage> getIncomingChanges(final PrimaryVersionSpec resolvedVersion) throws ESException {
        return (List)new UnknownEMFStoreWorkloadCommand<List<ChangePackage>>(this.getProgressMonitor()){

            @Override
            public List<ChangePackage> run(IProgressMonitor monitor) throws ESException {
                return UpdateController.this.getConnectionManager().getChanges(UpdateController.this.getSessionId(), UpdateController.this.getProjectSpace().getProjectId(), (VersionSpec)UpdateController.this.getProjectSpace().getBaseVersion(), (VersionSpec)resolvedVersion);
            }
        }.execute();
    }

    private ChangeConflictSet calcConflicts(ChangePackage localChanges, List<ChangePackage> changes, ModelElementIdToEObjectMappingImpl idToEObjectMapping) {
        ConflictDetector conflictDetector = new ConflictDetector();
        return conflictDetector.calculateConflicts(Collections.singletonList(localChanges), changes, (ModelElementIdToEObjectMapping)idToEObjectMapping);
    }

    private void checkAndRemoveDuplicateOperations(List<ChangePackage> incomingChanges, ChangePackage localChanges) {
        int baseVersionDelta = this.removeFromChangePackages(incomingChanges, localChanges);
        if (baseVersionDelta == 0) {
            return;
        }
        PrimaryVersionSpec baseVersion = this.getProjectSpace().getBaseVersion();
        baseVersion.setIdentifier(baseVersion.getIdentifier() + baseVersionDelta);
        ModelUtil.logError((String)MessageFormat.format(String.valueOf(Messages.UpdateController_ChangePackagesRemoved) + Messages.UpdateController_PullingUpBaseVersion, baseVersionDelta, baseVersion.getIdentifier(), baseVersion.getIdentifier() + baseVersionDelta));
        this.save((EObject)this.getProjectSpace(), Messages.UpdateController_ProjectSpace_SaveFailed);
        this.save((EObject)localChanges, Messages.UpdateController_LocalChanges_SaveFailed);
    }

    public int removeFromChangePackages(List<ChangePackage> incomingChanges, ChangePackage localChanges) {
        Iterator<ChangePackage> incomingChangesIterator = incomingChanges.iterator();
        int baseVersionDelta = 0;
        while (incomingChangesIterator.hasNext()) {
            ChangePackage incomingChangePackage = incomingChangesIterator.next();
            boolean hasBeenConsumed = this.removeDuplicateOperations(incomingChangePackage, localChanges);
            if (!hasBeenConsumed) break;
            ++baseVersionDelta;
            incomingChangesIterator.remove();
        }
        return baseVersionDelta;
    }

    /*
     * Unable to fully structure code
     */
    public boolean removeDuplicateOperations(ChangePackage incomingChanges, ChangePackage localChanges) {
        localOperationsIterator = localChanges.getOperations().iterator();
        incomingOps = incomingChanges.getOperations();
        incomingOpsSize = incomingOps.size();
        incomingIdx = 0;
        operationMatchingStarted = false;
        if (localChanges.getOperations().size() != 0) ** GOTO lbl19
        return false;
lbl-1000:
        // 1 sources

        {
            if (incomingIdx == incomingOpsSize) {
                return true;
            }
            localOp = (AbstractOperation)localOperationsIterator.next();
            if ((incomingOp = (AbstractOperation)incomingOps.get(incomingIdx++)).getIdentifier().equals(localOp.getIdentifier())) {
                localOperationsIterator.remove();
                operationMatchingStarted = true;
                continue;
            }
            if (operationMatchingStarted) {
                ModelUtil.logError((String)Messages.UpdateController_IncomingOperationsOnlyPartlyMatch);
                throw new IllegalStateException("Incoming operations only partly match with local.");
            }
            return false;
lbl19:
            // 2 sources

            ** while (localOperationsIterator.hasNext())
        }
lbl20:
        // 1 sources

        if (incomingIdx == incomingOpsSize) {
            return true;
        }
        ModelUtil.logError((String)Messages.UpdateController_IncomingOperationsNotFullyConsumed);
        throw new IllegalStateException("Incoming operations are not fully consumed.");
    }
}

