/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.importexport.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.emfstore.internal.client.importexport.IExportImportController;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportProjectHistoryController
extends ServerCall<Void>
implements IExportImportController {
    private ProjectHistory projectHistory;
    private final ProjectInfo projectInfo;

    public ExportProjectHistoryController(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
    }

    @Override
    public String getLabel() {
        return "Exporting changes";
    }

    @Override
    public String[] getFilteredNames() {
        return new String[]{"EMFStore Project Files (*" + ExportImportDataUnits.History.getExtension() + ")", "All Files (*.*)"};
    }

    @Override
    public String[] getFilteredExtensions() {
        return new String[]{"*" + ExportImportDataUnits.History.getExtension() + ", *.*"};
    }

    @Override
    public String getParentFolderPropertyKey() {
        return "org.eclipse.emf.emfstore.client.ui.exportProjectHistoryPath";
    }

    @Override
    public void execute(File file, IProgressMonitor progressMonitor) throws IOException {
        if (!FileUtil.getExtension((File)file).equals(ExportImportDataUnits.History.getExtension())) {
            file = new File(file.getAbsoluteFile() + ExportImportDataUnits.History.getExtension());
        }
        this.saveProjectHistory(this.projectHistory, file.getAbsolutePath());
    }

    private void saveProjectHistory(ProjectHistory projectHistory, String absoluteFileName) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)absoluteFileName));
        resource.getContents().add((Object)projectHistory);
        ModelUtil.saveResource((Resource)resource, (IResourceLogger)WorkspaceUtil.getResourceLogger());
    }

    @Override
    public String getFilename() {
        return "ProjectHistory_of_" + this.projectInfo.getName() + "@" + this.projectHistory.getLastVersion().getPrimarySpec().getIdentifier() + ExportImportDataUnits.History.getExtension();
    }

    @Override
    public boolean isExport() {
        return true;
    }

    @Override
    protected Void run() throws ESException {
        this.projectHistory = ESWorkspaceProviderImpl.getInstance().getConnectionManager().exportProjectHistoryFromServer(this.getSessionId(), this.projectInfo.getProjectId());
        return null;
    }
}

