/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.Messages;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiAttributeSetConflict
extends VisualConflict {
    public MultiAttributeSetConflict(ConflictBucket conflictBucket, DecisionManager decisionManager, boolean isMyRemove) {
        super(conflictBucket, decisionManager, isMyRemove, true);
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        if (this.isLeftMy()) {
            description.setDescription(DecisionUtil.getDescription("multiattributesetconflict.my", this.getDecisionManager().isBranchMerge()));
        } else {
            description.setDescription(DecisionUtil.getDescription("multiattributesetconflict.their", this.getDecisionManager().isBranchMerge()));
        }
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        if (this.isLeftMy()) {
            myOption.setOptionLabel(Messages.MultiAttributeSetConflict_RemoveElement);
            theirOption.setOptionLabel(Messages.MultiAttributeSetConflict_ChangeElement);
        } else {
            myOption.setOptionLabel(Messages.MultiAttributeSetConflict_ChangeElement);
            theirOption.setOptionLabel(Messages.MultiAttributeSetConflict_RemoveElement);
        }
        options.add(myOption);
        options.add(theirOption);
    }
}

