/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictContext;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.Messages;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletionConflict
extends VisualConflict {
    public DeletionConflict(ConflictBucket conflictBucket, boolean meCausingDelete, DecisionManager decisionManager) {
        super(conflictBucket, decisionManager, meCausingDelete, false);
        this.init();
    }

    @Override
    protected ConflictContext initConflictContext() {
        return new ConflictContext(this.getDecisionManager(), this.getLeftOperation(), this.getTheirOperation());
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        if (this.isLeftMy()) {
            description.setDescription(DecisionUtil.getDescription("deletionconflict.my", this.getDecisionManager().isBranchMerge()));
        } else {
            description.setDescription(DecisionUtil.getDescription("deletionconflict.their", this.getDecisionManager().isBranchMerge()));
        }
        description.add("modelelement", this.getLeftOperation().getModelElementId());
        description.add("firstother", this.getRightOperation().getModelElementId());
        description.add("otherinvolved", this.generateOthers());
        description.setImage("delete.gif");
        return description;
    }

    private String generateOthers() {
        if (this.getRightOperations().size() > 1) {
            return MessageFormat.format(Messages.DeletionConflict_AndOtherElements, this.getRightOperations().size() - 1);
        }
        return "";
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        if (this.isLeftMy()) {
            myOption.setOptionLabel(this.deleteMsg());
            theirOption.setOptionLabel(this.keepMsg());
        } else {
            myOption.setOptionLabel(this.keepMsg());
            theirOption.setOptionLabel(this.deleteMsg());
        }
        options.add(myOption);
        options.add(theirOption);
    }

    private String keepMsg() {
        EObject modelElement = this.getDecisionManager().getModelElement(this.getRightOperation().getModelElementId());
        String result = String.valueOf(Messages.DeletionConflict_Recover) + DecisionUtil.getClassAndName(modelElement);
        result = String.valueOf(result) + this.generateOthers();
        return result;
    }

    private String deleteMsg() {
        EObject modelElement = this.getDecisionManager().getModelElement(this.getLeftOperation().getModelElementId());
        return String.valueOf(Messages.DeletionConflict_Delete) + DecisionUtil.getClassAndName(modelElement);
    }
}

