/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.editor.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emfforms.internal.editor.Activator;
import org.eclipse.emfforms.spi.common.report.AbstractReport;

public final class ResourceSetHelpers {
    private ResourceSetHelpers() {
    }

    public static boolean save(ResourceSet resourceSet) {
        try {
            for (Resource resource : resourceSet.getResources()) {
                resource.save(null);
            }
            return true;
        }
        catch (IOException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.internal.editor", ex.getMessage(), (Throwable)ex)));
            return false;
        }
    }

    public static ResourceSet loadResourceSetWithProxies(URI resourceURI, BasicCommandStack commandStack) {
        ResourceSet resourceSet = ResourceSetHelpers.createResourceSet((CommandStack)commandStack);
        if (ResourceSetHelpers.addResourceToSet(resourceSet, resourceURI)) {
            if (resourceSet.getResources().get(0) instanceof GenModel) {
                ((GenModel)resourceSet.getResources().get(0)).reconcile();
            }
            return resourceSet;
        }
        return null;
    }

    private static ResourceSet createResourceSet(CommandStack commandStack) {
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)}), commandStack);
        ResourceSet resourceSet = domain.getResourceSet();
        resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        return resourceSet;
    }

    public static boolean addResourceToSet(ResourceSet resourceSet, URI resourceURI) {
        try {
            HashMap<String, Boolean> loadOptions = new HashMap<String, Boolean>();
            loadOptions.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            resourceSet.createResource(resourceURI).load(loadOptions);
            int rsSize = resourceSet.getResources().size();
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
            while (rsSize != resourceSet.getResources().size()) {
                EcoreUtil.resolveAll((ResourceSet)resourceSet);
                rsSize = resourceSet.getResources().size();
            }
            return true;
        }
        catch (IOException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, "org.eclipse.emfforms.internal.editor", ex.getMessage(), (Throwable)ex)));
            return false;
        }
    }

    public static List<?> findAllOfTypeInResourceSet(EObject object, EClassifier type, boolean includeEcorePackage) {
        return ResourceSetHelpers.findAllOf(object.eResource().getResourceSet(), type.getInstanceClass(), includeEcorePackage);
    }

    public static <T> List<T> findAllOfTypeInResourceSet(EObject object, Class<T> clazz, boolean includeEcorePackage) {
        return ResourceSetHelpers.findAllOf(object.eResource().getResourceSet(), clazz, includeEcorePackage);
    }

    public static <T> List<T> findAllOf(ResourceSet resourceSet, Class<T> clazz, boolean includeEcorePackage) {
        ArrayList<T> result = new ArrayList<T>();
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResources()) {
                TreeIterator objectIterator = resource.getAllContents();
                while (objectIterator.hasNext()) {
                    EObject o = (EObject)objectIterator.next();
                    if (o == null || !clazz.isInstance(o)) continue;
                    result.add(clazz.cast(o));
                }
            }
        }
        if (includeEcorePackage) {
            TreeIterator objectIterator = EcorePackage.eINSTANCE.eAllContents();
            while (objectIterator.hasNext()) {
                EObject o = (EObject)objectIterator.next();
                if (o == null || !clazz.isInstance(o)) continue;
                result.add(clazz.cast(o));
            }
        }
        return result;
    }
}

