/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictContext;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiReferenceConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiReferenceSingleConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.SingleReferenceConflict;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.SingleReferenceOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceConflict
extends VisualConflict {
    private final VisualConflict conflict;

    public ReferenceConflict(SingleReferenceOperation leftSingleRef, SingleReferenceOperation rightSingleRef, ConflictBucket conflictBucket, DecisionManager decisionManager) {
        super(conflictBucket, (AbstractOperation)leftSingleRef, (AbstractOperation)rightSingleRef, decisionManager, true, false);
        this.conflict = new SingleReferenceConflict(conflictBucket, leftSingleRef, rightSingleRef, decisionManager);
        this.init();
    }

    public ReferenceConflict(MultiReferenceOperation leftMultiRef, MultiReferenceOperation rightMultiRef, ConflictBucket conflictBucket, DecisionManager decisionManager) {
        super(conflictBucket, (AbstractOperation)leftMultiRef, (AbstractOperation)rightMultiRef, decisionManager, true, false);
        this.conflict = new MultiReferenceConflict(conflictBucket, leftMultiRef, rightMultiRef, decisionManager, true);
        this.init();
    }

    public ReferenceConflict(MultiReferenceOperation leftMultiRef, SingleReferenceOperation rightSingleRef, ConflictBucket conflictBucket, DecisionManager decisionManager) {
        super(conflictBucket, (AbstractOperation)leftMultiRef, (AbstractOperation)rightSingleRef, decisionManager, true, false);
        this.conflict = new MultiReferenceSingleConflict(leftMultiRef, rightSingleRef, conflictBucket, decisionManager);
        this.init();
    }

    public ReferenceConflict(SingleReferenceOperation leftSingleRef, MultiReferenceOperation rightMultiRef, ConflictBucket conflictBucket, DecisionManager decisionManager) {
        super(conflictBucket, (AbstractOperation)leftSingleRef, (AbstractOperation)rightMultiRef, decisionManager, true, false);
        this.conflict = new MultiReferenceSingleConflict(rightMultiRef, leftSingleRef, conflictBucket, decisionManager);
        this.init();
    }

    @Override
    protected ConflictContext initConflictContext() {
        return this.conflict.getConflictContext();
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription desc) {
        return this.conflict.getConflictDescription();
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        for (ConflictOption option : this.conflict.getOptions()) {
            if (option.getType() == ConflictOption.OptionType.MyOperation) {
                option.getOperations().clear();
                option.addOperations(this.getConflictBucket().getMyOperations());
            } else if (option.getType() == ConflictOption.OptionType.TheirOperation) {
                option.getOperations().clear();
                option.addOperations(this.getConflictBucket().getTheirOperations());
            }
            options.add(option);
        }
    }
}

