/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.common;

import java.util.LinkedHashSet;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;

public class ServiceObjectTracker<T> {
    private final ServiceObjects<T> serviceObjects;
    private final Set<T> trackedServices = new LinkedHashSet<T>();

    public ServiceObjectTracker(BundleContext bundleContext, Class<T> clazz) {
        ServiceReference serviceRef = bundleContext.getServiceReference(clazz);
        this.serviceObjects = bundleContext.getServiceObjects(serviceRef);
    }

    public T getService() {
        Object service = this.serviceObjects.getService();
        if (service != null) {
            this.trackedServices.add(service);
        }
        return (T)service;
    }

    public void dispose() {
        for (T service : this.trackedServices) {
            this.serviceObjects.ungetService(service);
        }
    }
}

