/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.changetracking.ESCommandObserver;
import org.eclipse.emf.emfstore.client.observer.ESCommitObserver;
import org.eclipse.emf.emfstore.client.observer.ESPostCreationObserver;
import org.eclipse.emf.emfstore.client.observer.ESShareObserver;
import org.eclipse.emf.emfstore.client.observer.ESUpdateObserver;
import org.eclipse.emf.emfstore.common.model.ESObjectContainer;
import org.eclipse.emf.emfstore.internal.client.model.CompositeOperationHandle;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.NotificationToOperationConverter;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.filter.FilterStack;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.notification.recording.NotificationRecorder;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.MissingCommandException;
import org.eclipse.emf.emfstore.internal.client.model.impl.Messages;
import org.eclipse.emf.emfstore.internal.client.model.impl.OperationRecorderConfig;
import org.eclipse.emf.emfstore.internal.client.model.impl.OperationRecorderListener;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.model.impl.RemovedElementsCache;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.NotificationInfo;
import org.eclipse.emf.emfstore.internal.common.model.util.SettingWithReferencedElement;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.OperationsFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.ReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.SingleReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.impl.CreateDeleteOperationImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.semantic.SemanticCompositeOperation;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationRecorder
implements ESCommandObserver,
ESCommitObserver,
ESUpdateObserver,
ESShareObserver,
IdEObjectCollectionChangeObserver {
    public static final String UNKOWN_CREATOR = Messages.OperationRecorder_Unknown;
    private int currentOperationListSize;
    private List<AbstractOperation> operations;
    private final List<OperationRecorderListener> observers;
    private final RemovedElementsCache removedElementsCache;
    private final NotificationToOperationConverter converter;
    private NotificationRecorder notificationRecorder;
    private CompositeOperation compositeOperation;
    private final ProjectSpaceBase projectSpace;
    private final IdEObjectCollectionImpl collection;
    private boolean isRecording;
    private boolean commandIsRunning;
    private final OperationRecorderConfig config;

    public OperationRecorder(ProjectSpaceBase projectSpace) {
        this.projectSpace = projectSpace;
        this.collection = (IdEObjectCollectionImpl)projectSpace.getProject();
        this.operations = new ArrayList<AbstractOperation>();
        this.observers = new ArrayList<OperationRecorderListener>();
        this.removedElementsCache = new RemovedElementsCache(this.collection);
        this.config = new OperationRecorderConfig();
        this.converter = new NotificationToOperationConverter(this.collection);
    }

    public List<AbstractOperation> clearOperations() {
        ArrayList<AbstractOperation> ops = new ArrayList<AbstractOperation>(this.operations);
        this.operations.clear();
        return ops;
    }

    public OperationRecorderConfig getConfig() {
        return this.config;
    }

    public IdEObjectCollection getCollection() {
        return this.collection;
    }

    public void modelElementAdded(IdEObjectCollection project, EObject modelElement) {
        ArrayList<Object> resultingOperations;
        if (!this.isRecording) {
            return;
        }
        this.checkCommandConstraints(modelElement);
        this.stopChangeRecording();
        ((ESPostCreationObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESPostCreationObserver.class)).onCreation(modelElement);
        this.startChangeRecording();
        LinkedHashSet<EObject> allModelElements = new LinkedHashSet<EObject>();
        allModelElements.add(modelElement);
        allModelElements.addAll(ModelUtil.getAllContainedModelElements((EObject)modelElement, (boolean)false));
        List crossReferences = ModelUtil.collectOutgoingCrossReferences((IdEObjectCollection)this.collection, allModelElements);
        List<SettingWithReferencedElement> ingoingCrossReferences = this.collectIngoingCrossReferences((IdEObjectCollection)this.collection, allModelElements);
        crossReferences.addAll(ingoingCrossReferences);
        List<SettingWithReferencedElement> savedSettings = this.removedElementsCache.getRemovedRootElementToReferenceSetting(modelElement);
        if (savedSettings != null) {
            ArrayList<SettingWithReferencedElement> toRemove = new ArrayList<SettingWithReferencedElement>();
            for (SettingWithReferencedElement setting : savedSettings) {
                for (SettingWithReferencedElement newSetting : crossReferences) {
                    if (!setting.getSetting().getEStructuralFeature().equals(newSetting.getSetting().getEStructuralFeature()) || !setting.getReferencedElement().equals(newSetting.getReferencedElement())) continue;
                    toRemove.add(newSetting);
                }
            }
            crossReferences.removeAll(toRemove);
        }
        List<ReferenceOperation> recordedOperations = this.generateCrossReferenceOperations(crossReferences);
        if (this.commandIsRunning && this.removedElementsCache.contains(modelElement)) {
            resultingOperations = new ArrayList<ReferenceOperation>(recordedOperations);
        } else {
            CreateDeleteOperation createDeleteOperation = this.createCreateDeleteOperation(modelElement, false);
            createDeleteOperation.getSubOperations().addAll(recordedOperations);
            resultingOperations = new ArrayList();
            resultingOperations.add((ReferenceOperation)createDeleteOperation);
        }
        if (this.compositeOperation != null) {
            this.compositeOperation.getSubOperations().addAll(resultingOperations);
        } else {
            this.bufferOrRecordOperations(resultingOperations);
        }
    }

    private void checkCommandConstraints(EObject modelElement) {
        if (!this.commandIsRunning && this.config.isForceCommands().booleanValue()) {
            WorkspaceUtil.handleException(Messages.OperationRecorder_ElementChangedWithoutCommand_0, new MissingCommandException(MessageFormat.format(Messages.OperationRecorder_ElementChangedWithoutCommand_1, modelElement)));
        }
    }

    private List<SettingWithReferencedElement> collectIngoingCrossReferences(IdEObjectCollection collection, Set<EObject> allModelElements) {
        ArrayList<SettingWithReferencedElement> settings = new ArrayList<SettingWithReferencedElement>();
        for (EObject modelElement : allModelElements) {
            Collection<EStructuralFeature.Setting> inverseReferences = this.projectSpace.findInverseCrossReferences(modelElement);
            for (EStructuralFeature.Setting setting : inverseReferences) {
                if (!ModelUtil.shouldBeCollected((IdEObjectCollection)collection, allModelElements, (EObject)setting.getEObject())) continue;
                EReference reference = (EReference)setting.getEStructuralFeature();
                EClassifier eType = reference.getEType();
                if (reference.isContainer() || reference.isContainment() || !reference.isChangeable() || !(eType instanceof EClass)) continue;
                SettingWithReferencedElement settingWithReferencedElement = new SettingWithReferencedElement(setting, modelElement);
                settings.add(settingWithReferencedElement);
            }
        }
        return settings;
    }

    private List<ReferenceOperation> generateCrossReferenceOperations(Collection<SettingWithReferencedElement> crossReferences) {
        ArrayList<ReferenceOperation> result = new ArrayList<ReferenceOperation>();
        for (SettingWithReferencedElement setting : crossReferences) {
            EObject referencedElement = setting.getReferencedElement();
            ModelElementId newModelElementId = this.collection.getModelElementId(referencedElement);
            if (newModelElementId == null) {
                newModelElementId = this.collection.getDeletedModelElementId(referencedElement);
            }
            EObject eObject = setting.getSetting().getEObject();
            EReference reference = (EReference)setting.getSetting().getEStructuralFeature();
            if (setting.getSetting().getEStructuralFeature().isMany()) {
                int position = ((List)eObject.eGet((EStructuralFeature)reference)).indexOf(referencedElement);
                MultiReferenceOperation multiRefOp = NotificationToOperationConverter.createMultiReferenceOperation(this.collection, eObject, reference, Arrays.asList(referencedElement), true, position);
                result.add((ReferenceOperation)multiRefOp);
                continue;
            }
            SingleReferenceOperation singleRefOp = NotificationToOperationConverter.createSingleReferenceOperation(this.collection, null, newModelElementId, reference, eObject);
            result.add((ReferenceOperation)singleRefOp);
        }
        return result;
    }

    private void operationsRecorded(List<AbstractOperation> operations) {
        if (operations.size() == 0) {
            return;
        }
        for (OperationRecorderListener observer : this.observers) {
            observer.operationsRecorded(operations);
        }
    }

    public void addOperationRecorderListener(OperationRecorderListener observer) {
        this.observers.add(observer);
    }

    public void removeOperationRecorderListener(OperationRecorderListener observer) {
        this.observers.remove(observer);
    }

    public void startChangeRecording() {
        if (this.notificationRecorder == null) {
            this.notificationRecorder = new NotificationRecorder();
        }
        this.isRecording = true;
    }

    public void stopChangeRecording() {
        this.isRecording = false;
    }

    private List<AbstractOperation> recordingFinished() {
        LinkedList<AbstractOperation> ops = new LinkedList<AbstractOperation>();
        List<NotificationInfo> rec = this.notificationRecorder.getRecording().asMutableList();
        for (NotificationInfo n : rec) {
            if (!n.isValid()) {
                WorkspaceUtil.log(String.valueOf(Messages.OperationRecorder_InvalidNotificationMessage) + n.getValidationMessage(), null, 0);
                continue;
            }
            AbstractOperation op = this.converter.convert(n);
            if (op != null) {
                ops.add(op);
                continue;
            }
            WorkspaceUtil.log(String.valueOf(Messages.OperationRecorder_InvalidNotificationClassification_0) + Messages.OperationRecorder_InvalidNotificationClassification_1 + n.toString(), null, 0);
        }
        return ops;
    }

    public NotificationRecorder getNotificationRecorder() {
        return this.notificationRecorder;
    }

    private CreateDeleteOperation createCreateDeleteOperation(EObject modelElement, boolean delete) {
        CreateDeleteOperation createDeleteOperation = OperationsFactory.eINSTANCE.createCreateDeleteOperation();
        createDeleteOperation.setDelete(delete);
        EObject element = modelElement;
        List allContainedModelElements = ModelUtil.getAllContainedModelElementsAsList((EObject)element, (boolean)false);
        allContainedModelElements.add(element);
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, false);
        EObject copiedElement = copier.copy(element);
        copier.copyReferences();
        List copiedAllContainedModelElements = ModelUtil.getAllContainedModelElementsAsList((EObject)copiedElement, (boolean)false);
        copiedAllContainedModelElements.add(copiedElement);
        if (allContainedModelElements.size() != copiedAllContainedModelElements.size()) {
            copiedElement = EcoreUtil.copy((EObject)element);
            copiedAllContainedModelElements = ModelUtil.getAllContainedModelElementsAsList((EObject)copiedElement, (boolean)false);
            copiedAllContainedModelElements.add(copiedElement);
        }
        int i = 0;
        while (i < allContainedModelElements.size()) {
            EObject child = (EObject)allContainedModelElements.get(i);
            if (!ModelUtil.isIgnoredDatatype((EObject)child)) {
                EObject copiedChild = (EObject)copiedAllContainedModelElements.get(i);
                ModelElementId childId = this.collection.getModelElementId(child);
                ((CreateDeleteOperationImpl)createDeleteOperation).getEObjectToIdMap().put((Object)copiedChild, (Object)childId);
            }
            ++i;
        }
        createDeleteOperation.setModelElement(copiedElement);
        createDeleteOperation.setModelElementId(this.collection.getModelElementId(modelElement));
        createDeleteOperation.setClientDate(new Date());
        return createDeleteOperation;
    }

    public void modelElementRemoved(IdEObjectCollection project, EObject modelElement) {
        if (this.isRecording) {
            if (!this.commandIsRunning) {
                this.handleElementDelete(modelElement);
                this.collection.clearAllocatedCaches();
            } else {
                LinkedHashSet<EObject> allModelElements = new LinkedHashSet<EObject>();
                allModelElements.add(modelElement);
                allModelElements.addAll(ModelUtil.getAllContainedModelElements((EObject)modelElement, (boolean)false));
                List crossReferences = ModelUtil.collectOutgoingCrossReferences((IdEObjectCollection)this.collection, allModelElements);
                List<SettingWithReferencedElement> ingoingCrossReferences = this.collectIngoingCrossReferences((IdEObjectCollection)this.collection, allModelElements);
                crossReferences.addAll(ingoingCrossReferences);
                this.removedElementsCache.addRemovedElement(modelElement, allModelElements, crossReferences);
            }
        }
    }

    @Override
    public void commandCompleted(Command command) {
        this.commandCompleted(command, false);
    }

    public void commandCompleted(Command command, boolean isNestedCommand) {
        ArrayList<EObject> deletedElements = new ArrayList<EObject>();
        int i = this.removedElementsCache.getRemovedRootElements().size() - 1;
        while (i >= 0) {
            EObject removedElement = this.removedElementsCache.getRemovedRootElements().get(i);
            if (!this.collection.contains(removedElement) && !deletedElements.contains(removedElement)) {
                deletedElements.add(0, removedElement);
            }
            --i;
        }
        for (final EObject deletedElement : deletedElements) {
            this.projectSpace.executeRunnable(new Runnable(){

                public void run() {
                    OperationRecorder.this.handleElementDelete(deletedElement);
                }
            });
        }
        Project project = this.projectSpace.getProject();
        EList cutElements = project.getCutElements();
        if (this.config.isDenyAddCutElementsToModelElements().booleanValue() && cutElements.size() != 0) {
            throw new IllegalStateException(String.valueOf(Messages.OperationRecorder_CutElementsPresent_0) + Messages.OperationRecorder_CutElementsPresent_1);
        }
        for (EObject eObject : new ArrayList(cutElements)) {
            project.addModelElement(eObject);
        }
        this.operations = this.modifyOperations(this.operations, command);
        this.operationsRecorded(this.operations);
        this.removedElementsCache.clear();
        this.operations.clear();
        this.collection.clearAllocatedCaches();
        this.commandIsRunning = isNestedCommand;
    }

    private List<AbstractOperation> modifyOperations(List<AbstractOperation> operations, Command command) {
        if (operations.isEmpty() || this.config.getOperationModifier() == null) {
            return operations;
        }
        return this.config.getOperationModifier().modify(operations, command);
    }

    private void deleteOutgoingCrossReferencesOfContainmentTree(Set<EObject> allEObjects) {
        ArrayList<SettingWithElementsToRemove> settingsToUnset = new ArrayList<SettingWithElementsToRemove>();
        for (EObject modelElement : allEObjects) {
            for (EReference reference : modelElement.eClass().getEAllReferences()) {
                if (!EClass.class.isInstance(reference.getEType())) continue;
                EClass eClass = (EClass)reference.getEType();
                if (Map.Entry.class.isAssignableFrom(eClass.getInstanceClass()) && reference.isContainment() && reference.isChangeable()) {
                    this.handleMapEntryDeletion(modelElement, eClass, reference, allEObjects);
                    continue;
                }
                if (reference.isContainer() || reference.isContainment() || !reference.isChangeable()) continue;
                if (reference.isMany()) {
                    Set<EObject> referencesToRemove = this.filterAllNonContained((List)modelElement.eGet((EStructuralFeature)reference), allEObjects);
                    if (referencesToRemove.size() <= 0) continue;
                    settingsToUnset.add(new SettingWithElementsToRemove(((InternalEObject)InternalEObject.class.cast(modelElement)).eSetting((EStructuralFeature)reference), referencesToRemove));
                    continue;
                }
                EObject referencedElement = (EObject)modelElement.eGet((EStructuralFeature)reference);
                if (referencedElement == null || allEObjects.contains(referencedElement)) continue;
                settingsToUnset.add(new SettingWithElementsToRemove(((InternalEObject)InternalEObject.class.cast(modelElement)).eSetting((EStructuralFeature)reference)));
            }
        }
        this.unsetAll(settingsToUnset);
    }

    private void unsetAll(List<SettingWithElementsToRemove> settingsToUnset) {
        for (SettingWithElementsToRemove settingWithElementsToRemove : settingsToUnset) {
            EStructuralFeature.Setting setting = settingWithElementsToRemove.setting;
            EStructuralFeature feature = setting.getEStructuralFeature();
            Set referencesToRemove = settingWithElementsToRemove.elementsToRemove;
            if (feature.isMany()) {
                List referencedElements = (List)setting.getEObject().eGet(feature);
                referencedElements.removeAll(referencesToRemove);
                continue;
            }
            setting.getEObject().eSet(feature, null);
        }
    }

    private Set<EObject> filterAllNonContained(List<EObject> elements, Set<EObject> allElements) {
        LinkedHashSet<EObject> referencedElementsCopy = new LinkedHashSet<EObject>(elements);
        referencedElementsCopy.removeAll(allElements);
        return referencedElementsCopy;
    }

    private void handleMapEntryDeletion(EObject modelElement, EClass mapEntryEClass, EReference reference, Set<EObject> allEObjects) {
        List mapEntriesEList = (List)modelElement.eGet((EStructuralFeature)reference);
        LinkedHashSet<EObject> mapEntriesToRemove = new LinkedHashSet<EObject>();
        EReference nonContainmentKeyReference = this.getNonContainmentKeyReference(mapEntryEClass);
        if (nonContainmentKeyReference == null) {
            return;
        }
        for (EObject mapEntry : mapEntriesEList) {
            Object targetElement = mapEntry.eGet((EStructuralFeature)nonContainmentKeyReference);
            if (allEObjects.contains(targetElement)) continue;
            mapEntriesToRemove.add(mapEntry);
        }
        if (mapEntriesToRemove.isEmpty()) {
            return;
        }
        EcoreUtil.resolveAll((EObject)modelElement);
        for (EObject mapEntryToRemove : mapEntriesToRemove) {
            mapEntriesEList.remove(mapEntryToRemove);
            this.handleElementDelete(mapEntryToRemove);
        }
    }

    private EReference getNonContainmentKeyReference(EClass eClass) {
        for (EReference eRef : eClass.getEReferences()) {
            if (eRef.getName().equals("key") && !eRef.isContainment()) {
                return eRef;
            }
            if (!eRef.getName().equals("key") || !eRef.isContainment()) continue;
            return null;
        }
        return null;
    }

    private void handleElementDelete(EObject deletedElement) {
        Set allDeletedModelElements = ModelUtil.getAllContainedModelElements((EObject)deletedElement, (boolean)false);
        allDeletedModelElements.add(deletedElement);
        this.deleteOutgoingCrossReferencesOfContainmentTree(allDeletedModelElements);
        if (this.config.isCutOffIncomingCrossReferences().booleanValue()) {
            for (EObject element : allDeletedModelElements) {
                Collection<EStructuralFeature.Setting> inverseReferences = this.projectSpace.findInverseCrossReferences(element);
                ModelUtil.deleteIncomingCrossReferencesToElement((EObject)element, inverseReferences, (Set)allDeletedModelElements);
            }
        }
        if (!this.isRecording) {
            return;
        }
        List allContainedModelElements = ModelUtil.getAllContainedModelElementsAsList((EObject)deletedElement, (boolean)false);
        allContainedModelElements.add(deletedElement);
        EObject copiedElement = ModelUtil.clone((EObject)deletedElement);
        List copiedAllContainedModelElements = ModelUtil.getAllContainedModelElementsAsList((EObject)copiedElement, (boolean)false);
        copiedAllContainedModelElements.add(copiedElement);
        CreateDeleteOperation deleteOperation = OperationsFactory.eINSTANCE.createCreateDeleteOperation();
        deleteOperation.setClientDate(new Date());
        deleteOperation.setModelElement(copiedElement);
        deleteOperation.setModelElementId(this.getDeletedModelElementId(deletedElement));
        int i = 0;
        while (i < allContainedModelElements.size()) {
            EObject child = (EObject)allContainedModelElements.get(i);
            EObject copiedChild = (EObject)copiedAllContainedModelElements.get(i);
            ModelElementId childId = this.getDeletedModelElementId(child);
            ((CreateDeleteOperationImpl)deleteOperation).getEObjectToIdMap().put((Object)copiedChild, (Object)childId);
            ++i;
        }
        deleteOperation.setDelete(true);
        ArrayList<CompositeOperation> compositeOperationsToDelete = new ArrayList<CompositeOperation>();
        List<ReferenceOperation> extractReferenceOperationsForDelete = this.extractReferenceOperationsForDelete(deletedElement, compositeOperationsToDelete);
        deleteOperation.getSubOperations().addAll(extractReferenceOperationsForDelete);
        this.operations.removeAll(compositeOperationsToDelete);
        if (this.compositeOperation != null) {
            this.compositeOperation.getSubOperations().add((Object)deleteOperation);
        } else {
            this.bufferOrRecordOperation((AbstractOperation)deleteOperation);
        }
    }

    private ModelElementId getDeletedModelElementId(EObject deletedElement) {
        if (!this.commandIsRunning) {
            return this.collection.getDeletedModelElementId(deletedElement);
        }
        return (ModelElementId)ModelUtil.clone((EObject)this.removedElementsCache.getRemovedElementId(deletedElement));
    }

    private List<ReferenceOperation> extractReferenceOperationsForDelete(EObject deletedElement, List<CompositeOperation> compositeOperationsToDelete) {
        LinkedHashSet<ModelElementId> allDeletedElementsIds = new LinkedHashSet<ModelElementId>();
        for (EObject child : ModelUtil.getAllContainedModelElements((EObject)deletedElement, (boolean)false)) {
            ModelElementId childId = this.collection.getDeletedModelElementId(child);
            allDeletedElementsIds.add(childId);
        }
        allDeletedElementsIds.add(this.collection.getDeletedModelElementId(deletedElement));
        ArrayList<ReferenceOperation> referenceOperationsForDelete = new ArrayList<ReferenceOperation>();
        List<AbstractOperation> newOperations = this.operations.subList(0, this.operations.size());
        ArrayList<AbstractOperation> l = new ArrayList<AbstractOperation>();
        int i = newOperations.size() - 1;
        while (i >= 0) {
            AbstractOperation operation = newOperations.get(i);
            if (this.belongsToDelete(operation, allDeletedElementsIds)) {
                referenceOperationsForDelete.add(0, (ReferenceOperation)operation);
                l.add(operation);
            } else {
                if (!(operation instanceof CompositeOperation) || ((CompositeOperation)operation).getMainOperation() == null) break;
                CompositeOperation compositeOperation = (CompositeOperation)operation;
                boolean doesNotBelongToDelete = false;
                for (AbstractOperation subOperation : compositeOperation.getSubOperations()) {
                    if (this.belongsToDelete(subOperation, allDeletedElementsIds)) continue;
                    doesNotBelongToDelete = true;
                    break;
                }
                if (!doesNotBelongToDelete) {
                    referenceOperationsForDelete.addAll(0, (Collection<ReferenceOperation>)compositeOperation.getSubOperations());
                    compositeOperationsToDelete.add(compositeOperation);
                }
            }
            --i;
        }
        this.operations.removeAll(l);
        return referenceOperationsForDelete;
    }

    private boolean belongsToDelete(AbstractOperation operation, Set<ModelElementId> allDeletedElementsIds) {
        ReferenceOperation referenceOperation;
        Set allInvolvedModelElements;
        if (operation instanceof ReferenceOperation && (allInvolvedModelElements = (referenceOperation = (ReferenceOperation)operation).getAllInvolvedModelElements()).removeAll(allDeletedElementsIds)) {
            return this.isDestructorReferenceOperation(referenceOperation);
        }
        return false;
    }

    private boolean isDestructorReferenceOperation(ReferenceOperation referenceOperation) {
        if (referenceOperation instanceof MultiReferenceOperation) {
            MultiReferenceOperation multiReferenceOperation = (MultiReferenceOperation)referenceOperation;
            return !multiReferenceOperation.isAdd();
        }
        if (referenceOperation instanceof SingleReferenceOperation) {
            SingleReferenceOperation singleReferenceOperation = (SingleReferenceOperation)referenceOperation;
            return singleReferenceOperation.getOldValue() != null && singleReferenceOperation.getNewValue() == null;
        }
        return false;
    }

    @Override
    public void commandFailed(Command command, Exception exception) {
        int i;
        if (this.compositeOperation != null) {
            i = this.compositeOperation.getSubOperations().size() - 1;
            while (i >= this.currentOperationListSize) {
                this.compositeOperation.getSubOperations().remove(i);
                --i;
            }
        }
        if (this.config.isRollbackAtCommandFailure().booleanValue()) {
            i = this.operations.size() - 1;
            while (i >= 0) {
                this.operations.get(i).reverse().apply((IdEObjectCollection)this.collection);
                --i;
            }
        } else {
            this.commandCompleted(command);
        }
    }

    @Override
    public void commandStarted(Command command) {
        this.currentOperationListSize = 0;
        this.commandIsRunning = true;
    }

    public CompositeOperation getCompositeOperation() {
        return this.compositeOperation;
    }

    public CompositeOperationHandle beginCompositeOperation() {
        if (this.compositeOperation != null) {
            throw new IllegalStateException(Messages.OperationRecorder_OnlyOneCompositeAllowed);
        }
        this.compositeOperation = OperationsFactory.eINSTANCE.createCompositeOperation();
        CompositeOperationHandle handle = new CompositeOperationHandle(this, this.compositeOperation);
        this.notificationRecorder.newRecording();
        return handle;
    }

    public void endCompositeOperation(SemanticCompositeOperation semanticCompositeOperation) {
        this.compositeOperation = semanticCompositeOperation;
        this.endCompositeOperation();
    }

    public void endCompositeOperation() {
        this.bufferOrRecordOperation((AbstractOperation)this.compositeOperation);
        this.compositeOperation = null;
        this.notificationRecorder.stopRecording();
    }

    public void abortCompositeOperation() {
        AbstractOperation reversedCompositeOperation = this.compositeOperation.reverse();
        this.projectSpace.applyOperations(Collections.singletonList(reversedCompositeOperation), false);
        this.removedElementsCache.clear();
        this.notificationRecorder.stopRecording();
        this.compositeOperation = null;
        this.currentOperationListSize = this.operations.size();
    }

    public void notify(Notification notification, IdEObjectCollection collection, EObject modelElement) {
        if (!this.isRecording) {
            return;
        }
        if (FilterStack.DEFAULT.check(new NotificationInfo(notification).toAPI(), (ESObjectContainer<?>)collection)) {
            return;
        }
        this.checkCommandConstraints(modelElement);
        this.notificationRecorder.record(notification);
        if (this.notificationRecorder.isRecordingComplete()) {
            List<AbstractOperation> ops = this.recordingFinished();
            if (this.compositeOperation != null) {
                this.compositeOperation.getSubOperations().addAll(ops);
                return;
            }
            if (ops.size() > 1) {
                this.bufferOrRecordOperation((AbstractOperation)this.createCompositeOperation(ops));
            } else if (ops.size() == 1) {
                this.bufferOrRecordOperation(ops.get(0));
            }
        }
    }

    private CompositeOperation createCompositeOperation(List<AbstractOperation> ops) {
        CompositeOperation op = OperationsFactory.eINSTANCE.createCompositeOperation();
        op.getSubOperations().addAll(ops);
        op.setMainOperation(ops.get(ops.size() - 1));
        op.setModelElementId((ModelElementId)ModelUtil.clone((EObject)op.getMainOperation().getModelElementId()));
        return op;
    }

    private void bufferOrRecordOperations(List<AbstractOperation> operations) {
        if (this.commandIsRunning && this.config.isEmitOperationsUponCommandCompletion().booleanValue()) {
            this.operations.addAll(operations);
        } else {
            this.operationsRecorded(operations);
        }
    }

    private void bufferOrRecordOperation(AbstractOperation operation) {
        this.bufferOrRecordOperations(Arrays.asList(operation));
    }

    public void collectionDeleted(IdEObjectCollection collection) {
    }

    public ProjectSpace getProjectSpace() {
        return this.projectSpace;
    }

    @Override
    public boolean inspectChanges(ESLocalProject project, List<ESChangePackage> changePackages, IProgressMonitor monitor) {
        return true;
    }

    @Override
    public boolean inspectChanges(ESLocalProject project, ESChangePackage changePackage, IProgressMonitor monitor) {
        return true;
    }

    @Override
    public void updateCompleted(ESLocalProject project, IProgressMonitor monitor) {
        this.clearAllocatedCaches(project);
    }

    @Override
    public void shareDone(ESLocalProject localProject) {
        this.clearAllocatedCaches(localProject);
    }

    @Override
    public void commitCompleted(ESLocalProject project, ESPrimaryVersionSpec newRevision, IProgressMonitor monitor) {
        this.clearAllocatedCaches(project);
    }

    private void clearAllocatedCaches(ESLocalProject project) {
        if (((ProjectSpace)((ESLocalProjectImpl)project).toInternalAPI()).getProject().equals(this.collection) && !this.commandIsRunning) {
            this.collection.clearAllocatedCaches();
        }
    }

    public boolean isCommandRunning() {
        return this.commandIsRunning;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SettingWithElementsToRemove {
        private final EStructuralFeature.Setting setting;
        private final Set<EObject> elementsToRemove = new LinkedHashSet<EObject>();

        SettingWithElementsToRemove(EStructuralFeature.Setting setting) {
            this.setting = setting;
        }

        SettingWithElementsToRemove(EStructuralFeature.Setting setting, Set<EObject> elementsToRemove) {
            this.setting = setting;
            this.elementsToRemove.addAll(elementsToRemove);
        }

        public EStructuralFeature.Setting getSetting() {
            return this.setting;
        }

        public Set<EObject> getElementsToRemove() {
            return this.elementsToRemove;
        }
    }
}

