/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictContext;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.MultiReferenceConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.conflicts.SingleReferenceConflict;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceConflict
extends VisualConflict {
    private final VisualConflict conflict;

    public ReferenceConflict(boolean underlyingSingleConflict, ConflictBucket conflictBucket, DecisionManager decisionManager) {
        super(conflictBucket, decisionManager, true, false);
        if (underlyingSingleConflict) {
            this.conflict = new SingleReferenceConflict(conflictBucket, conflictBucket.getMyOperation(), conflictBucket.getTheirOperation(), decisionManager);
        } else {
            this.conflict = this.createMultiMultiConflict(conflictBucket, conflictBucket.getMyOperation(), conflictBucket.getTheirOperation(), decisionManager);
            this.setLeftIsMy(((MultiReferenceOperation)conflictBucket.getMyOperation()).isAdd());
        }
        this.init();
    }

    private VisualConflict createMultiMultiConflict(ConflictBucket conflictBucket, AbstractOperation my, AbstractOperation their, DecisionManager decisionManager) {
        if (((MultiReferenceOperation)my).isAdd()) {
            return new MultiReferenceConflict(conflictBucket, my, their, decisionManager, true);
        }
        return new MultiReferenceConflict(conflictBucket, their, my, decisionManager, false);
    }

    @Override
    protected ConflictContext initConflictContext() {
        return this.conflict.getConflictContext();
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription desc) {
        return this.conflict.getConflictDescription();
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        for (ConflictOption option : this.conflict.getOptions()) {
            if (option.getType() == ConflictOption.OptionType.MyOperation) {
                option.addOperations(this.getLeftOperations());
            } else if (option.getType() == ConflictOption.OptionType.TheirOperation) {
                option.addOperations(this.getRightOperations());
            }
            options.add(option);
        }
    }
}

