/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.emfstore.internal.client.model.AdminBroker;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.PropertiesForm;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.TabContent;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.dialogs.admin.acimport.wizard.AcUserImportAction;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.ServerAdmin;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserTabContent
extends TabContent
implements IPropertyChangeListener {
    private static final String NEW_USER_NAME = "New User";

    public UserTabContent(String string, AdminBroker adminBroker, PropertiesForm frm) {
        super(string, adminBroker, frm);
        this.setTab(this);
    }

    @Override
    protected List<Action> initActions() {
        Action createNewUser = new Action("Create new user"){

            public void run() {
                try {
                    if (UserTabContent.this.userExists(UserTabContent.NEW_USER_NAME)) {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"User already exists", (String)"A user with the given name 'New User' already exists.");
                    } else {
                        UserTabContent.this.getAdminBroker().createUser(UserTabContent.NEW_USER_NAME);
                    }
                }
                catch (ESException e) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                }
                UserTabContent.this.getTableViewer().refresh();
                UserTabContent.this.getForm().getTableViewer().refresh();
            }
        };
        createNewUser.setImageDescriptor(Activator.getImageDescriptor("icons/user.png"));
        createNewUser.setToolTipText("Create new user");
        DeleteUserAction deleteUser = new DeleteUserAction("Delete user");
        deleteUser.setImageDescriptor(Activator.getImageDescriptor("icons/delete.gif"));
        deleteUser.setToolTipText("Delete user");
        AcUserImportAction importOrgUnit = new AcUserImportAction(this.getAdminBroker());
        importOrgUnit.addPropertyChangeListener(this);
        ChangePasswordAction changePassword = new ChangePasswordAction("Change password of selected user");
        changePassword.setImageDescriptor(Activator.getImageDescriptor("icons/lock.png"));
        changePassword.setToolTipText("Change password of selected user");
        return Arrays.asList(new Action[]{createNewUser, deleteUser, importOrgUnit, changePassword});
    }

    @Override
    public ITableLabelProvider getLabelProvider() {
        return new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return Activator.getImageDescriptor("icons/user.png").createImage();
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((ACUser)element).getName();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean userExists(String username) {
        try {
            ACUser user;
            Iterator iterator = this.getAdminBroker().getUsers().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(user = (ACUser)iterator.next()).getName().equals(username));
            return true;
        }
        catch (ESException eSException) {
            return false;
        }
    }

    @Override
    public IStructuredContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList users = new ArrayList();
                try {
                    users.addAll(UserTabContent.this.getAdminBroker().getUsers());
                }
                catch (ESException e) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                }
                return users.toArray(new ACUser[users.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.getTableViewer().refresh();
    }

    private final class ChangePasswordAction
    extends Action {
        private ChangePasswordAction(String text) {
            super(text);
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)UserTabContent.this.getTableViewer().getSelection();
            for (ACUser user : selection) {
                if (user == null) {
                    return;
                }
                try {
                    String superUser = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", "super");
                    boolean isAdmin = false;
                    for (Role userRole : user.getRoles()) {
                        if (user.getName().compareTo(superUser) != 0 || !(userRole instanceof ServerAdmin)) continue;
                        isAdmin = true;
                        break;
                    }
                    Display display = Display.getCurrent();
                    Shell activeShell = display.getActiveShell();
                    if (isAdmin) {
                        MessageDialog.openInformation((Shell)activeShell, (String)"Illegal deletion attempt", (String)"It is not allowed to delete the super user!");
                    } else {
                        InputDialog inputDialog = new InputDialog(activeShell, "Enter new password for user '" + user.getName() + "'", "Enter the new password", "", null);
                        if (inputDialog.open() == 0) {
                            String newPassword = inputDialog.getValue();
                            UserTabContent.this.getAdminBroker().changeUser(user.getId(), user.getName(), newPassword);
                        }
                    }
                }
                catch (ESException e) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                }
                if (!(UserTabContent.this.getForm().getCurrentInput() instanceof ACOrgUnit) || !UserTabContent.this.getForm().getCurrentInput().equals(user)) continue;
                UserTabContent.this.getForm().setInput(null);
            }
            UserTabContent.this.getTableViewer().refresh();
        }
    }

    private final class DeleteUserAction
    extends Action {
        private DeleteUserAction(String text) {
            super(text);
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)UserTabContent.this.getTableViewer().getSelection();
            for (ACUser ou : selection) {
                if (ou == null) {
                    return;
                }
                try {
                    String superUser = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", "super");
                    boolean isAdmin = false;
                    for (Role userRole : ou.getRoles()) {
                        if (ou.getName().compareTo(superUser) != 0 || !(userRole instanceof ServerAdmin)) continue;
                        isAdmin = true;
                        break;
                    }
                    if (isAdmin) {
                        Display display = Display.getCurrent();
                        MessageDialog.openInformation((Shell)display.getActiveShell(), (String)"Illegal deletion attempt", (String)"It is not allowed to delete the super user!");
                    } else {
                        UserTabContent.this.getAdminBroker().deleteUser(ou.getId());
                    }
                }
                catch (ESException e) {
                    EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
                }
                if (!(UserTabContent.this.getForm().getCurrentInput() instanceof ACOrgUnit) || !UserTabContent.this.getForm().getCurrentInput().equals(ou)) continue;
                UserTabContent.this.getForm().setInput(null);
            }
            UserTabContent.this.getTableViewer().refresh();
        }
    }
}

