/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.DecisionBox;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.util.UIDecisionUtil;
import org.eclipse.emf.emfstore.internal.client.ui.views.changes.ChangePackageVisualizationHelper;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionComponent
extends Composite {
    public DescriptionComponent(DecisionBox parent, VisualConflict conflict) {
        super((Composite)parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 20;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label image = new Label((Composite)this, 0);
        image.setImage(UIDecisionUtil.getImage(conflict.getConflictDescription().getImage()));
        image.setToolTipText(conflict.getClass().getSimpleName());
        image.setLayoutData((Object)new GridData(2));
        image.setBackground(parent.getBackground());
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        String description = "";
        for (String tmp : this.splitText(parent, conflict.getConflictDescription())) {
            if (tmp.startsWith("::")) {
                styleRanges.add(this.createStyleRange(description.length(), tmp.length() - 2));
                description = String.valueOf(description) + tmp.substring(2);
                continue;
            }
            description = String.valueOf(description) + tmp;
        }
        Group group = new Group((Composite)this, 0);
        group.setLayoutData((Object)new GridData(1808));
        FillLayout groupLayout = new FillLayout();
        groupLayout.marginHeight = 5;
        groupLayout.marginWidth = 6;
        group.setLayout((Layout)groupLayout);
        group.setBackground(parent.getBackground());
        group.setText("Conflict Description:");
        StyledText styledDescription = new StyledText((Composite)group, 74);
        styledDescription.setEditable(false);
        styledDescription.setEnabled(false);
        styledDescription.setText(String.valueOf(description) + "\n");
        styledDescription.setWordWrap(true);
        styledDescription.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
        styledDescription.setBackground(parent.getBackground());
    }

    private StyleRange createStyleRange(int start, int length) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = length;
        styleRange.fontStyle = 1;
        return styleRange;
    }

    private List<String> splitText(DecisionBox box, ConflictDescription conflict) {
        String description = conflict.getDescription();
        ChangePackageVisualizationHelper visualHelper = UIDecisionUtil.getChangePackageVisualizationHelper(box.getDecisionManager());
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = description.split("\\[");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String[] split = string.split("\\]");
            if (split.length > 1) {
                Object obj = conflict.getValues().get(split[0]);
                String tmp = "";
                if (obj instanceof AbstractOperation) {
                    tmp = visualHelper.getDescription((AbstractOperation)obj);
                } else if (obj instanceof EObject) {
                    tmp = DecisionUtil.getModelElementName((EObject)((EObject)obj));
                } else if (obj != null) {
                    tmp = obj.toString();
                    tmp = UIDecisionUtil.cutString(tmp, 85, true);
                } else {
                    tmp = "";
                }
                tmp = UIDecisionUtil.stripNewLine(tmp);
                split[0] = "::" + tmp;
            }
            result.addAll(Arrays.asList(split));
            ++n2;
        }
        return result;
    }
}

