/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf.diff;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.emfstore.fuzzy.emf.FuzzyUtil;
import org.eclipse.emf.emfstore.fuzzy.emf.config.TestConfig;
import org.eclipse.emf.emfstore.fuzzy.emf.config.TestRun;
import org.eclipse.emf.emfstore.fuzzy.emf.diff.Messages;
import org.eclipse.emf.emfstore.fuzzy.emf.diff.TestRunProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonTestRunProvider
extends TestRunProvider {
    private static final String JOB = "job/";
    private static SAXReader saxReader = new SAXReader();
    private static String jobUrl;
    private String hudsonUrl;
    private final int firstBuildNumber;
    private final int secondBuildNumber;
    public static final String PROP_HUDSON = ".hudson";
    public static final String PROP_URL = ".url";
    public static final String PROP_ARTIFACT_FOLDER = ".artifact.folder";
    public static final String PROP_PORT = ".port";
    public static final String PROP_JOB = ".job";
    public static final String PROP_DIFF_JOB = ".diffjob";
    private static final String LAST_BUILD = "lastBuild";
    public static final String[] VALID_STATES;
    private static final String ARTIFACT;

    static {
        VALID_STATES = new String[]{"SUCCESS", "UNSTABLE"};
        ARTIFACT = FuzzyUtil.getProperty(".hudson.artifact.folder", "/artifact/");
    }

    public HudsonTestRunProvider() throws DocumentException, IOException {
        this.initProperties();
        this.firstBuildNumber = HudsonTestRunProvider.getLastValidBuildNumber(Integer.parseInt(HudsonTestRunProvider.getFirstElementValue(String.valueOf(jobUrl) + LAST_BUILD + "/api/xml?tree=number")), jobUrl);
        this.secondBuildNumber = HudsonTestRunProvider.getLastValidBuildNumber(this.firstBuildNumber - 1, jobUrl);
    }

    public HudsonTestRunProvider(int firstBuildNumber, int secondBuildNumber) {
        this.initProperties();
        this.firstBuildNumber = firstBuildNumber;
        this.secondBuildNumber = secondBuildNumber;
    }

    private void initProperties() {
        this.hudsonUrl = HudsonTestRunProvider.getHudsonUrl();
        jobUrl = String.valueOf(this.hudsonUrl) + JOB + FuzzyUtil.getProperty(".hudson.job", "Explorer") + "/";
    }

    private static String getHudsonUrl() {
        String port = FuzzyUtil.getProperty(".hudson.port", null);
        return String.valueOf(FuzzyUtil.getProperty(".hudson.url", "http://localhost")) + (port != null ? ":" + port : "") + "/";
    }

    private static int getLastValidBuildNumber(int maxBuildNumber, String jobUrl) throws MalformedURLException, DocumentException {
        if (maxBuildNumber < 0) {
            throw new RuntimeException(Messages.HudsonTestRunProvider_Not_Enough_Valid_Builds);
        }
        if (HudsonTestRunProvider.isValidBuild(maxBuildNumber, jobUrl)) {
            return maxBuildNumber;
        }
        return HudsonTestRunProvider.getLastValidBuildNumber(maxBuildNumber - 1, jobUrl);
    }

    private static boolean isValidBuild(int buildNumber, String jobUrl) throws MalformedURLException, DocumentException {
        String result = HudsonTestRunProvider.getFirstElementValue(String.valueOf(jobUrl) + buildNumber + "/api/xml?tree=result");
        String[] stringArray = VALID_STATES;
        int n = VALID_STATES.length;
        int n2 = 0;
        while (n2 < n) {
            String valid = stringArray[n2];
            if (valid.equals(result)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String getFirstElementValue(String url) throws MalformedURLException, DocumentException {
        Document doc = saxReader.read(new URL(url));
        List elements = doc.getRootElement().elements();
        if (elements.size() == 0) {
            throw new RuntimeException(String.valueOf(Messages.HudsonTestRunProvider_No_Elements_In_Result) + url);
        }
        return ((Element)elements.get(0)).getText();
    }

    @Override
    public TestRun[] getTestRuns() throws IOException {
        TestRun[] runs = new TestRun[2];
        Resource resource = this.getTestRunResource(this.firstBuildNumber);
        if (!FuzzyUtil.resourceExists(resource)) {
            throw new RuntimeException(Messages.HudsonTestRunProvider_No_TestRunFile_For_1st_Run);
        }
        resource.load(null);
        runs[0] = this.getTestRun(resource);
        resource = this.getTestRunResource(this.secondBuildNumber);
        if (!FuzzyUtil.resourceExists(resource)) {
            throw new RuntimeException(Messages.HudsonTestRunProvider_No_TestRunFile_For_2nd_Run);
        }
        resource.load(null);
        runs[1] = this.getTestRun(resource);
        return runs;
    }

    private Resource getTestRunResource(int buildNumber) {
        return FuzzyUtil.createResource(String.valueOf(jobUrl) + buildNumber + ARTIFACT + "fuzzy/" + "testruns/" + this.getTestConfig().getId() + ".xml");
    }

    public List<TestConfig> getAllConfigs() {
        Resource resource = FuzzyUtil.createResource(String.valueOf(jobUrl) + this.firstBuildNumber + ARTIFACT + "fuzzy/" + "fuzzyConfig.fuzzy");
        try {
            resource.load(null);
        }
        catch (IOException e) {
            throw new RuntimeException(Messages.HudsonTestRunProvider_Could_Not_Load_Config_File, e);
        }
        ArrayList<TestConfig> configs = new ArrayList<TestConfig>();
        for (EObject obj : resource.getContents()) {
            if (!(obj instanceof TestConfig)) continue;
            configs.add((TestConfig)obj);
        }
        return configs;
    }

    public static Resource getDiffResource() throws MalformedURLException, DocumentException {
        String diffJobUrl = String.valueOf(HudsonTestRunProvider.getHudsonUrl()) + JOB + FuzzyUtil.getProperty(".hudson.diffjob", "Diff") + "/";
        int lastValidNumber = HudsonTestRunProvider.getLastValidBuildNumber(Integer.parseInt(HudsonTestRunProvider.getFirstElementValue(String.valueOf(diffJobUrl) + LAST_BUILD + "/api/xml?tree=number")), diffJobUrl);
        return FuzzyUtil.createResource(String.valueOf(diffJobUrl) + lastValidNumber + ARTIFACT + "fuzzy/" + "diff" + ".xml");
    }
}

