/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.emfstore.fuzzy.Annotations;
import org.eclipse.emf.emfstore.fuzzy.FuzzyDataProvider;
import org.eclipse.emf.emfstore.fuzzy.FuzzyTestClassRunner;
import org.eclipse.emf.emfstore.fuzzy.Util;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuzzyRunner
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();
    private final FuzzyDataProvider<?> dataProvider = this.getDataProvider();
    public static final String NAME_SEPARATOR = " ";

    public FuzzyRunner(Class<?> clazz) throws InitializationError {
        super(clazz, Collections.emptyList());
        this.dataProvider.setTestClass(this.getTestClass());
        this.dataProvider.init();
        FrameworkField dataField = this.getDataField();
        FrameworkField utilField = this.getUtilField();
        FrameworkField optionsField = this.getOptionsField();
        Util util = this.dataProvider.getUtil();
        int i = 0;
        while (i < this.dataProvider.size()) {
            FuzzyTestClassRunner runner = new FuzzyTestClassRunner(clazz, this.dataProvider, dataField, utilField, optionsField, util, i + 1);
            if (runner.getChildren().size() > 0) {
                this.runners.add((Runner)runner);
            }
            ++i;
        }
    }

    public void run(RunNotifier notifier) {
        List<RunListener> listener = this.dataProvider.getListener();
        if (listener != null) {
            for (RunListener runListener : listener) {
                notifier.addListener(runListener);
            }
        }
        super.run(notifier);
    }

    private FrameworkField getUtilField() {
        return this.getSingleStaticFrameworkField(Annotations.Util.class);
    }

    private FrameworkField getOptionsField() {
        return this.getSingleStaticFrameworkField(Annotations.Options.class);
    }

    private FrameworkField getSingleStaticFrameworkField(Class<? extends Annotation> annotation) {
        List fields = this.getTestClass().getAnnotatedFields(annotation);
        if (fields.size() > 1) {
            throw new RuntimeException("Only one field annotated with " + annotation.getSimpleName() + " permitted: " + this.getTestClass().getName() + " contains " + fields.size());
        }
        for (FrameworkField field : fields) {
            int modifiers = field.getField().getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            return field;
        }
        return null;
    }

    private FrameworkField getDataField() throws InitializationError {
        FrameworkField field = this.getSingleStaticFrameworkField(Annotations.Data.class);
        if (field == null) {
            throw new InitializationError("No non-static model field anntoted with " + Annotations.Data.class.getSimpleName() + " in class " + this.getTestClass().getName());
        }
        return field;
    }

    private FuzzyDataProvider<?> getDataProvider() throws InitializationError {
        Annotation[] annotations = this.getTestClass().getAnnotations();
        Class<?> dataProviderClass = null;
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof Annotations.DataProvider && !FuzzyDataProvider.class.isAssignableFrom(dataProviderClass = ((Annotations.DataProvider)annotation).value())) {
                throw new InitializationError(dataProviderClass + " is not an implementation of " + FuzzyDataProvider.class.getSimpleName());
            }
            ++n2;
        }
        try {
            return (FuzzyDataProvider)dataProviderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException instantiationException) {
            throw new InitializationError("The DataProvider must have a zero-parameter constructor!");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InitializationError("The DataProvider must have a zero-parameter constructor!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InitializationError("The DataProvider must have a zero-parameter constructor!");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InitializationError("The DataProvider must have a zero-parameter constructor!");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InitializationError("The DataProvider must have a zero-parameter constructor!");
        }
        catch (SecurityException securityException) {
            throw new InitializationError("The DataProvider must have a zero-parameter constructor!");
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }
}

