/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.operations.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.ContainmentType;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.OperationsPackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.SingleReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.provider.ReferenceOperationItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleReferenceOperationItemProvider
extends ReferenceOperationItemProvider {
    public SingleReferenceOperationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addOldValuePropertyDescriptor(object);
            this.addNewValuePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addOldValuePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SingleReferenceOperation_oldValue_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SingleReferenceOperation_oldValue_feature", "_UI_SingleReferenceOperation_type"), (EStructuralFeature)OperationsPackage.Literals.SINGLE_REFERENCE_OPERATION__OLD_VALUE, true, false, true, null, null, null));
    }

    protected void addNewValuePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SingleReferenceOperation_newValue_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SingleReferenceOperation_newValue_feature", "_UI_SingleReferenceOperation_type"), (EStructuralFeature)OperationsPackage.Literals.SINGLE_REFERENCE_OPERATION__NEW_VALUE, true, false, true, null, null, null));
    }

    @Override
    public Object getImage(Object object) {
        return super.getImage(object);
    }

    @Override
    public String getText(Object object) {
        if (object instanceof SingleReferenceOperation) {
            SingleReferenceOperation op = (SingleReferenceOperation)object;
            ModelElementId oldElement = op.getOldValue();
            ModelElementId newElement = op.getNewValue();
            String oldName = SingleReferenceOperationItemProvider.getModelElementClassAndName(op.getOldValue());
            String newName = SingleReferenceOperationItemProvider.getModelElementClassAndName(op.getNewValue());
            String elementName = SingleReferenceOperationItemProvider.getModelElementClassAndName(op.getModelElementId());
            boolean isContainer = op.getContainmentType().equals((Object)ContainmentType.CONTAINER);
            if (isContainer && oldElement != null && newElement != null) {
                return "Moved " + elementName + " from " + oldName + " to " + newName;
            }
            if (isContainer && newElement != null) {
                return "Moved " + elementName + " to " + newName;
            }
            if (oldElement == null && newElement == null) {
                return "Unset " + op.getFeatureName() + " in " + elementName;
            }
            if (oldElement == null && newElement != null) {
                return "Set " + op.getFeatureName() + " in " + elementName + " to " + newName;
            }
            if (oldElement != null && newElement == null) {
                return "Unset " + op.getFeatureName() + " in " + elementName + " from previous value " + oldName;
            }
            return "Set " + op.getFeatureName() + " in " + elementName + " from " + oldName + " to " + newName;
        }
        return super.getText(object);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

