/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.common.ESResourceSetProvider;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESPriorityComparator;
import org.eclipse.emf.emfstore.internal.common.ResourceFactoryRegistry;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Version;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionImpl
extends EObjectImpl
implements Version {
    public static final String FILE_EXTENSION_PROJECTSTATE = ".ups";
    public static final String FILE_EXTENSION_CHANGEPACKAGE = ".ucp";
    public static final String FILE_PREFIX_CHANGEPACKAGE = "changepackage-";
    public static final String FILE_PREFIX_PROJECTSTATE = "projectstate-";
    public static final String CHANGEPACKAGES_SEGMENT = "changepackages";
    public static final String PROJECTSTATES_SEGMENT = "projectstates";
    private SoftReference<Resource> projectStateResource = new SoftReference<Object>(null);
    private SoftReference<Resource> changePackageResource = new SoftReference<Object>(null);
    private static ResourceFactoryRegistry resourceFactoryRegistry = new ResourceFactoryRegistry();
    protected PrimaryVersionSpec primarySpec;
    protected EList<TagVersionSpec> tagSpecs;
    protected Version nextVersion;
    protected Version previousVersion;
    protected LogMessage logMessage;
    protected Version ancestorVersion;
    protected EList<Version> branchedVersions;
    protected EList<Version> mergedToVersion;
    protected EList<Version> mergedFromVersion;

    protected VersionImpl() {
    }

    protected EClass eStaticClass() {
        return VersioningPackage.Literals.VERSION;
    }

    @Override
    public PrimaryVersionSpec getPrimarySpec() {
        if (this.primarySpec != null && this.primarySpec.eIsProxy()) {
            InternalEObject oldPrimarySpec = (InternalEObject)this.primarySpec;
            this.primarySpec = (PrimaryVersionSpec)this.eResolveProxy(oldPrimarySpec);
            if (this.primarySpec != oldPrimarySpec) {
                InternalEObject newPrimarySpec = (InternalEObject)this.primarySpec;
                NotificationChain msgs = oldPrimarySpec.eInverseRemove((InternalEObject)this, -1, null, null);
                if (newPrimarySpec.eInternalContainer() == null) {
                    msgs = newPrimarySpec.eInverseAdd((InternalEObject)this, -1, null, msgs);
                }
                if (msgs != null) {
                    msgs.dispatch();
                }
                if (this.eNotificationRequired()) {
                    this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldPrimarySpec, (Object)this.primarySpec));
                }
            }
        }
        return this.primarySpec;
    }

    public PrimaryVersionSpec basicGetPrimarySpec() {
        return this.primarySpec;
    }

    public NotificationChain basicSetPrimarySpec(PrimaryVersionSpec newPrimarySpec, NotificationChain msgs) {
        PrimaryVersionSpec oldPrimarySpec = this.primarySpec;
        this.primarySpec = newPrimarySpec;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldPrimarySpec, (Object)newPrimarySpec);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setPrimarySpec(PrimaryVersionSpec newPrimarySpec) {
        if (newPrimarySpec != this.primarySpec) {
            NotificationChain msgs = null;
            if (this.primarySpec != null) {
                msgs = ((InternalEObject)this.primarySpec).eInverseRemove((InternalEObject)this, -1, null, msgs);
            }
            if (newPrimarySpec != null) {
                msgs = ((InternalEObject)newPrimarySpec).eInverseAdd((InternalEObject)this, -1, null, msgs);
            }
            if ((msgs = this.basicSetPrimarySpec(newPrimarySpec, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newPrimarySpec, (Object)newPrimarySpec));
        }
    }

    @Override
    public EList<TagVersionSpec> getTagSpecs() {
        if (this.tagSpecs == null) {
            this.tagSpecs = new EObjectContainmentEList.Resolving(TagVersionSpec.class, (InternalEObject)this, 1);
        }
        return this.tagSpecs;
    }

    @Override
    public Version getNextVersion() {
        if (this.nextVersion != null && this.nextVersion.eIsProxy()) {
            InternalEObject oldNextVersion = (InternalEObject)this.nextVersion;
            this.nextVersion = (Version)this.eResolveProxy(oldNextVersion);
            if (this.nextVersion != oldNextVersion && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldNextVersion, (Object)this.nextVersion));
            }
        }
        return this.nextVersion;
    }

    public Version basicGetNextVersion() {
        return this.nextVersion;
    }

    public NotificationChain basicSetNextVersion(Version newNextVersion, NotificationChain msgs) {
        Version oldNextVersion = this.nextVersion;
        this.nextVersion = newNextVersion;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldNextVersion, (Object)newNextVersion);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setNextVersion(Version newNextVersion) {
        if (newNextVersion != this.nextVersion) {
            NotificationChain msgs = null;
            if (this.nextVersion != null) {
                msgs = ((InternalEObject)this.nextVersion).eInverseRemove((InternalEObject)this, 3, Version.class, msgs);
            }
            if (newNextVersion != null) {
                msgs = ((InternalEObject)newNextVersion).eInverseAdd((InternalEObject)this, 3, Version.class, msgs);
            }
            if ((msgs = this.basicSetNextVersion(newNextVersion, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newNextVersion, (Object)newNextVersion));
        }
    }

    @Override
    public Version getPreviousVersion() {
        if (this.previousVersion != null && this.previousVersion.eIsProxy()) {
            InternalEObject oldPreviousVersion = (InternalEObject)this.previousVersion;
            this.previousVersion = (Version)this.eResolveProxy(oldPreviousVersion);
            if (this.previousVersion != oldPreviousVersion && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldPreviousVersion, (Object)this.previousVersion));
            }
        }
        return this.previousVersion;
    }

    public Version basicGetPreviousVersion() {
        return this.previousVersion;
    }

    public NotificationChain basicSetPreviousVersion(Version newPreviousVersion, NotificationChain msgs) {
        Version oldPreviousVersion = this.previousVersion;
        this.previousVersion = newPreviousVersion;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldPreviousVersion, (Object)newPreviousVersion);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setPreviousVersion(Version newPreviousVersion) {
        if (newPreviousVersion != this.previousVersion) {
            NotificationChain msgs = null;
            if (this.previousVersion != null) {
                msgs = ((InternalEObject)this.previousVersion).eInverseRemove((InternalEObject)this, 2, Version.class, msgs);
            }
            if (newPreviousVersion != null) {
                msgs = ((InternalEObject)newPreviousVersion).eInverseAdd((InternalEObject)this, 2, Version.class, msgs);
            }
            if ((msgs = this.basicSetPreviousVersion(newPreviousVersion, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newPreviousVersion, (Object)newPreviousVersion));
        }
    }

    private EMap<EObject, String> loadIdsFromResourceForEObjects(Set<EObject> modelElements, XMIResource xmiResource) {
        if (xmiResource != null) {
            BasicEMap eObjectToIdMap = new BasicEMap(xmiResource.getContents().size());
            for (EObject eObject : modelElements) {
                String objId = xmiResource.getID(eObject);
                if (objId == null) continue;
                eObjectToIdMap.put((Object)eObject, (Object)objId);
            }
            return eObjectToIdMap;
        }
        return null;
    }

    @Override
    public LogMessage getLogMessage() {
        if (this.logMessage != null && this.logMessage.eIsProxy()) {
            InternalEObject oldLogMessage = (InternalEObject)this.logMessage;
            this.logMessage = (LogMessage)this.eResolveProxy(oldLogMessage);
            if (this.logMessage != oldLogMessage) {
                InternalEObject newLogMessage = (InternalEObject)this.logMessage;
                NotificationChain msgs = oldLogMessage.eInverseRemove((InternalEObject)this, -5, null, null);
                if (newLogMessage.eInternalContainer() == null) {
                    msgs = newLogMessage.eInverseAdd((InternalEObject)this, -5, null, msgs);
                }
                if (msgs != null) {
                    msgs.dispatch();
                }
                if (this.eNotificationRequired()) {
                    this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldLogMessage, (Object)this.logMessage));
                }
            }
        }
        return this.logMessage;
    }

    public LogMessage basicGetLogMessage() {
        return this.logMessage;
    }

    public NotificationChain basicSetLogMessage(LogMessage newLogMessage, NotificationChain msgs) {
        LogMessage oldLogMessage = this.logMessage;
        this.logMessage = newLogMessage;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldLogMessage, (Object)newLogMessage);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLogMessage(LogMessage newLogMessage) {
        if (newLogMessage != this.logMessage) {
            NotificationChain msgs = null;
            if (this.logMessage != null) {
                msgs = ((InternalEObject)this.logMessage).eInverseRemove((InternalEObject)this, -5, null, msgs);
            }
            if (newLogMessage != null) {
                msgs = ((InternalEObject)newLogMessage).eInverseAdd((InternalEObject)this, -5, null, msgs);
            }
            if ((msgs = this.basicSetLogMessage(newLogMessage, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newLogMessage, (Object)newLogMessage));
        }
    }

    @Override
    public Version getAncestorVersion() {
        if (this.ancestorVersion != null && this.ancestorVersion.eIsProxy()) {
            InternalEObject oldAncestorVersion = (InternalEObject)this.ancestorVersion;
            this.ancestorVersion = (Version)this.eResolveProxy(oldAncestorVersion);
            if (this.ancestorVersion != oldAncestorVersion && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldAncestorVersion, (Object)this.ancestorVersion));
            }
        }
        return this.ancestorVersion;
    }

    public Version basicGetAncestorVersion() {
        return this.ancestorVersion;
    }

    public NotificationChain basicSetAncestorVersion(Version newAncestorVersion, NotificationChain msgs) {
        Version oldAncestorVersion = this.ancestorVersion;
        this.ancestorVersion = newAncestorVersion;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldAncestorVersion, (Object)newAncestorVersion);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setAncestorVersion(Version newAncestorVersion) {
        if (newAncestorVersion != this.ancestorVersion) {
            NotificationChain msgs = null;
            if (this.ancestorVersion != null) {
                msgs = ((InternalEObject)this.ancestorVersion).eInverseRemove((InternalEObject)this, 6, Version.class, msgs);
            }
            if (newAncestorVersion != null) {
                msgs = ((InternalEObject)newAncestorVersion).eInverseAdd((InternalEObject)this, 6, Version.class, msgs);
            }
            if ((msgs = this.basicSetAncestorVersion(newAncestorVersion, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newAncestorVersion, (Object)newAncestorVersion));
        }
    }

    @Override
    public EList<Version> getBranchedVersions() {
        if (this.branchedVersions == null) {
            this.branchedVersions = new EObjectWithInverseResolvingEList(Version.class, (InternalEObject)this, 6, 5);
        }
        return this.branchedVersions;
    }

    @Override
    public EList<Version> getMergedToVersion() {
        if (this.mergedToVersion == null) {
            this.mergedToVersion = new EObjectWithInverseResolvingEList.ManyInverse(Version.class, (InternalEObject)this, 7, 8);
        }
        return this.mergedToVersion;
    }

    @Override
    public EList<Version> getMergedFromVersion() {
        if (this.mergedFromVersion == null) {
            this.mergedFromVersion = new EObjectWithInverseResolvingEList.ManyInverse(Version.class, (InternalEObject)this, 8, 7);
        }
        return this.mergedFromVersion;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                if (this.nextVersion != null) {
                    msgs = ((InternalEObject)this.nextVersion).eInverseRemove((InternalEObject)this, 3, Version.class, msgs);
                }
                return this.basicSetNextVersion((Version)otherEnd, msgs);
            }
            case 3: {
                if (this.previousVersion != null) {
                    msgs = ((InternalEObject)this.previousVersion).eInverseRemove((InternalEObject)this, 2, Version.class, msgs);
                }
                return this.basicSetPreviousVersion((Version)otherEnd, msgs);
            }
            case 5: {
                if (this.ancestorVersion != null) {
                    msgs = ((InternalEObject)this.ancestorVersion).eInverseRemove((InternalEObject)this, 6, Version.class, msgs);
                }
                return this.basicSetAncestorVersion((Version)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getBranchedVersions()).basicAdd((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getMergedToVersion()).basicAdd((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getMergedFromVersion()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetPrimarySpec(null, msgs);
            }
            case 1: {
                return ((InternalEList)this.getTagSpecs()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return this.basicSetNextVersion(null, msgs);
            }
            case 3: {
                return this.basicSetPreviousVersion(null, msgs);
            }
            case 4: {
                return this.basicSetLogMessage(null, msgs);
            }
            case 5: {
                return this.basicSetAncestorVersion(null, msgs);
            }
            case 6: {
                return ((InternalEList)this.getBranchedVersions()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getMergedToVersion()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getMergedFromVersion()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getPrimarySpec();
                }
                return this.basicGetPrimarySpec();
            }
            case 1: {
                return this.getTagSpecs();
            }
            case 2: {
                if (resolve) {
                    return this.getNextVersion();
                }
                return this.basicGetNextVersion();
            }
            case 3: {
                if (resolve) {
                    return this.getPreviousVersion();
                }
                return this.basicGetPreviousVersion();
            }
            case 4: {
                if (resolve) {
                    return this.getLogMessage();
                }
                return this.basicGetLogMessage();
            }
            case 5: {
                if (resolve) {
                    return this.getAncestorVersion();
                }
                return this.basicGetAncestorVersion();
            }
            case 6: {
                return this.getBranchedVersions();
            }
            case 7: {
                return this.getMergedToVersion();
            }
            case 8: {
                return this.getMergedFromVersion();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setPrimarySpec((PrimaryVersionSpec)newValue);
                return;
            }
            case 1: {
                this.getTagSpecs().clear();
                this.getTagSpecs().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setNextVersion((Version)newValue);
                return;
            }
            case 3: {
                this.setPreviousVersion((Version)newValue);
                return;
            }
            case 4: {
                this.setLogMessage((LogMessage)newValue);
                return;
            }
            case 5: {
                this.setAncestorVersion((Version)newValue);
                return;
            }
            case 6: {
                this.getBranchedVersions().clear();
                this.getBranchedVersions().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getMergedToVersion().clear();
                this.getMergedToVersion().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getMergedFromVersion().clear();
                this.getMergedFromVersion().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setPrimarySpec(null);
                return;
            }
            case 1: {
                this.getTagSpecs().clear();
                return;
            }
            case 2: {
                this.setNextVersion(null);
                return;
            }
            case 3: {
                this.setPreviousVersion(null);
                return;
            }
            case 4: {
                this.setLogMessage(null);
                return;
            }
            case 5: {
                this.setAncestorVersion(null);
                return;
            }
            case 6: {
                this.getBranchedVersions().clear();
                return;
            }
            case 7: {
                this.getMergedToVersion().clear();
                return;
            }
            case 8: {
                this.getMergedFromVersion().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.primarySpec != null;
            }
            case 1: {
                return this.tagSpecs != null && !this.tagSpecs.isEmpty();
            }
            case 2: {
                return this.nextVersion != null;
            }
            case 3: {
                return this.previousVersion != null;
            }
            case 4: {
                return this.logMessage != null;
            }
            case 5: {
                return this.ancestorVersion != null;
            }
            case 6: {
                return this.branchedVersions != null && !this.branchedVersions.isEmpty();
            }
            case 7: {
                return this.mergedToVersion != null && !this.mergedToVersion.isEmpty();
            }
            case 8: {
                return this.mergedFromVersion != null && !this.mergedFromVersion.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Project getProjectState() {
        Resource resource = this.getProjectStateResource();
        if (resource == null || resource.getContents().size() < 1) {
            return null;
        }
        Project project = (Project)resource.getContents().get(0);
        return project;
    }

    @Override
    public AbstractChangePackage getChanges() {
        Resource resource = this.getChangePackageResource();
        if (resource == null || resource.getContents().size() < 1) {
            return null;
        }
        AbstractChangePackage changePackage = (AbstractChangePackage)resource.getContents().get(0);
        return changePackage;
    }

    private Resource getProjectStateResource() {
        Resource result = this.projectStateResource.get();
        if (this.projectStateResource.get() == null || !this.projectStateResource.get().isLoaded()) {
            block5: {
                try {
                    result = this.loadResourceForURI(this.getProjectURI());
                }
                catch (IOException ioe) {
                    result = null;
                    if (ioe instanceof FileNotFoundException && this.getPrimarySpec().getIdentifier() != 0) break block5;
                    ModelUtil.logException((Throwable)ioe);
                }
            }
            if (result != null && result.getContents().size() > 0) {
                Project project = (Project)result.getContents().get(0);
                this.initProjectStateAfterLoad((ProjectImpl)project);
            }
            this.setProjectStateResource(result);
        }
        if (result != null && result.getResourceSet() == null) {
            this.addResourceToResourceSet(result);
        }
        return result;
    }

    private void initProjectStateAfterLoad(ProjectImpl project) {
        Resource resource = project.eResource();
        if (resource instanceof XMIResource) {
            Set allContainedModelElements = ModelUtil.getAllContainedModelElements((EObject)project, (boolean)false);
            EMap<EObject, String> eObjectToIdMap = this.loadIdsFromResourceForEObjects(allContainedModelElements, (XMIResource)resource);
            LinkedHashMap<String, EObject> idToEObjectMap = new LinkedHashMap<String, EObject>(eObjectToIdMap.size());
            for (Map.Entry entry : eObjectToIdMap.entrySet()) {
                idToEObjectMap.put((String)entry.getValue(), (EObject)entry.getKey());
            }
            project.initMapping(eObjectToIdMap.map(), idToEObjectMap);
        }
    }

    private Resource getChangePackageResource() {
        Resource result = this.changePackageResource.get();
        if (this.changePackageResource.get() == null || !this.changePackageResource.get().isLoaded()) {
            block4: {
                try {
                    result = this.loadResourceForURI(this.getChangePackageURI());
                }
                catch (IOException e) {
                    result = null;
                    if (this.getPrimarySpec().getIdentifier() <= 0) break block4;
                    ModelUtil.logException((Throwable)e);
                }
            }
            this.setChangeResource(result);
        }
        if (result != null && result.getResourceSet() == null) {
            this.addResourceToResourceSet(result);
        }
        return result;
    }

    private Resource loadResourceForURI(URI uri) throws IOException {
        Resource resource = null;
        if (this.eResource() != null && this.eResource().getResourceSet() != null) {
            resource = this.eResource().getResourceSet().createResource(uri);
        }
        if (resource == null) {
            resourceFactoryRegistry.createResource(uri);
        }
        resource.load(ModelUtil.getResourceLoadOptions());
        return resource;
    }

    private void addResourceToResourceSet(Resource resource) {
        ESExtensionPoint extensionPoint = new ESExtensionPoint("org.eclipse.emf.emfstore.server.resourceSetProvider", true, (Comparator)new ESPriorityComparator("priority", true));
        ESResourceSetProvider resourceSetProvider = (ESResourceSetProvider)extensionPoint.getElementWithHighestPriority().getClass("class", ESResourceSetProvider.class);
        ResourceSet resourceSet = resourceSetProvider.getResourceSet();
        resourceSet.getResources().add((Object)resource);
    }

    private URI getProjectURI() {
        return this.getBaseURI() == null ? null : this.getBaseURI().appendSegment(PROJECTSTATES_SEGMENT).appendSegment(Integer.toString(this.getPrimarySpec().getIdentifier()));
    }

    private URI getChangePackageURI() {
        return this.getBaseURI() == null ? null : this.getBaseURI().appendSegment(CHANGEPACKAGES_SEGMENT).appendSegment(Integer.toString(this.getPrimarySpec().getIdentifier()));
    }

    private URI getBaseURI() {
        return this.eResource() == null ? null : this.eResource().getURI().trimSegments(2);
    }

    @Override
    public void setChangeResource(Resource resource) {
        if (resource == null) {
            this.changePackageResource = new SoftReference<Object>(null);
        } else {
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null && resourceSet == this.eResource().getResourceSet()) {
                resourceSet.getResources().remove((Object)resource);
            }
            this.changePackageResource = new SoftReference<Resource>(resource);
        }
    }

    @Override
    public void setProjectStateResource(Resource resource) {
        if (resource == null) {
            this.projectStateResource = new SoftReference<Object>(null);
        } else {
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null && resourceSet == this.eResource().getResourceSet()) {
                resourceSet.getResources().remove((Object)resource);
            }
            this.projectStateResource = new SoftReference<Resource>(resource);
        }
    }
}

