/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AccessControl;
import org.eclipse.emf.emfstore.internal.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.core.InternalCommand;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidInputException;
import org.eclipse.emf.emfstore.internal.server.exceptions.SessionTimedOutException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESUserImpl;
import org.eclipse.emf.emfstore.server.auth.ESProjectAdminPrivileges;
import org.eclipse.emf.emfstore.server.model.ESGlobalProjectId;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitId;
import org.eclipse.emf.emfstore.server.model.ESSessionId;
import org.eclipse.emf.emfstore.server.model.ESUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEmfstoreInterface {
    private final HashMap<Class<? extends AbstractSubEmfstoreInterface>, AbstractSubEmfstoreInterface> subInterfaces;
    private boolean accessControlDisabled;
    private final ServerSpace serverSpace;
    private final AccessControl accessControl;

    public AbstractEmfstoreInterface(ServerSpace serverSpace, AccessControl accessControl) throws FatalESException {
        if (serverSpace == null || accessControl == null) {
            throw new FatalESException();
        }
        this.serverSpace = serverSpace;
        this.accessControl = accessControl;
        this.accessControlDisabled = false;
        this.subInterfaces = new LinkedHashMap<Class<? extends AbstractSubEmfstoreInterface>, AbstractSubEmfstoreInterface>();
        this.initSubInterfaces();
        for (AbstractSubEmfstoreInterface subInterface : this.subInterfaces.values()) {
            subInterface.initSubInterface();
        }
    }

    protected abstract void initSubInterfaces() throws FatalESException;

    protected void addSubInterface(AbstractSubEmfstoreInterface subInterface) {
        if (subInterface != null) {
            this.getSubInterfaces().put(subInterface.getClass(), subInterface);
        }
    }

    protected HashMap<Class<? extends AbstractSubEmfstoreInterface>, AbstractSubEmfstoreInterface> getSubInterfaces() {
        return this.subInterfaces;
    }

    protected <T> T getSubInterface(Class<T> clazz) {
        return (T)this.subInterfaces.get(clazz);
    }

    protected ServerSpace getServerSpace() {
        return this.serverSpace;
    }

    protected Object getMonitor() {
        return MonitorProvider.getInstance().getMonitor();
    }

    protected AccessControl getAccessControl() {
        return this.accessControl;
    }

    protected synchronized void checkSession(SessionId sessionId) throws SessionTimedOutException {
        this.getAccessControl().getSessions().isValid((ESSessionId)sessionId.toAPI());
    }

    protected synchronized void checkReadAccess(SessionId sessionId, ProjectId projectId, Set<EObject> modelElements) throws AccessControlException {
        if (this.accessControlDisabled) {
            return;
        }
        this.getAccessControl().getAuthorizationService().checkReadAccess((ESSessionId)sessionId.toAPI(), (ESGlobalProjectId)projectId.toAPI(), modelElements);
    }

    protected synchronized void checkWriteAccess(SessionId sessionId, ProjectId projectId, Set<EObject> modelElements) throws AccessControlException {
        if (this.accessControlDisabled) {
            return;
        }
        this.getAccessControl().getAuthorizationService().checkWriteAccess((ESSessionId)sessionId.toAPI(), (ESGlobalProjectId)projectId.toAPI(), modelElements);
    }

    protected SessionId resolveSessionById(String sessionId) {
        ESSessionId resolvedSession = this.getAccessControl().getSessions().resolveSessionById(sessionId);
        return (SessionId)APIUtil.toInternal(SessionId.class, (Object)resolvedSession);
    }

    protected ACUser resolveUserBySessionId(String sessionId) throws AccessControlException {
        ESSessionId resolvedSession = this.getAccessControl().getSessions().resolveSessionById(sessionId);
        ESUser resolvedUser = this.getAccessControl().getSessions().resolveUser(resolvedSession);
        return (ACUser)((ESUserImpl)ESUserImpl.class.cast(resolvedUser)).toInternalAPI();
    }

    protected synchronized void checkProjectAdminAccess(SessionId sessionId, ProjectId projectId, ESProjectAdminPrivileges privilege) throws AccessControlException {
        if (this.accessControlDisabled) {
            return;
        }
        this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), (ESGlobalProjectId)projectId.toAPI(), privilege);
    }

    protected synchronized boolean checkProjectAdminAccessForOrgUnit(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnitId) throws AccessControlException {
        if (this.accessControlDisabled) {
            return true;
        }
        return this.getAccessControl().getAuthorizationService().checkProjectAdminAccessForOrgUnit((ESSessionId)sessionId.toAPI(), (ESOrgUnitId)orgUnitId.toAPI(), Collections.singleton((ESGlobalProjectId)projectId.toAPI()));
    }

    protected synchronized boolean checkProjectAdminAccess(SessionId sessionId, ESProjectAdminPrivileges privilege) throws AccessControlException {
        if (this.accessControlDisabled) {
            return true;
        }
        return this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null, privilege);
    }

    protected synchronized boolean checkProjectAdminAccess(SessionId sessionId) throws AccessControlException {
        if (this.accessControlDisabled) {
            return true;
        }
        return this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), null);
    }

    protected synchronized boolean checkProjectAdminAccess(SessionId sessionId, ProjectId projectId) throws AccessControlException {
        if (this.accessControlDisabled) {
            return true;
        }
        return this.getAccessControl().getAuthorizationService().checkProjectAdminAccess((ESSessionId)sessionId.toAPI(), (ESGlobalProjectId)projectId.toAPI());
    }

    protected synchronized void checkServerAdminAccess(SessionId sessionId) throws AccessControlException {
        if (this.accessControlDisabled) {
            return;
        }
        this.getAccessControl().getAuthorizationService().checkServerAdminAccess((ESSessionId)sessionId.toAPI());
    }

    protected void sanityCheckObjects(Object ... objects) throws InvalidInputException {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.sanityCheckObject(object);
            ++n2;
        }
    }

    private void sanityCheckObject(Object object) throws InvalidInputException {
        if (object == null) {
            throw new InvalidInputException();
        }
    }

    public synchronized void runCommand(InternalCommand<? extends AbstractEmfstoreInterface> command) {
        this.accessControlDisabled = true;
        command.setInterface(this);
        command.doExecute();
        this.accessControlDisabled = false;
    }
}

