/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.modelmutator.mutation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.Mutation;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationPredicates;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.MutationTargetSelector;
import org.eclipse.emf.emfstore.internal.modelmutator.mutation.StructuralFeatureMutation;
import org.eclipse.emf.emfstore.modelmutator.ESAttributeChangeMutation;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorUtil;
import org.eclipse.emf.emfstore.modelmutator.ESMutationException;
import org.eclipse.emf.emfstore.modelmutator.ESRandomChangeMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeChangeMutation
extends StructuralFeatureMutation<ESAttributeChangeMutation>
implements ESAttributeChangeMutation {
    private Object newValue;
    private ESRandomChangeMode randomChangeMode;

    public AttributeChangeMutation(ESModelMutatorUtil util) {
        super(util);
        this.addGeneralAttributeChangeMutationPredicates();
    }

    protected AttributeChangeMutation(ESModelMutatorUtil util, MutationTargetSelector selector) {
        super(util, selector);
        this.addGeneralAttributeChangeMutationPredicates();
    }

    private void addGeneralAttributeChangeMutationPredicates() {
        this.addTargetFeatureAttributePredicate();
        this.addAttributeTypeNotFeatureMapPredicate();
        this.addAttributeTypeNotEEnumeratorPredicate();
    }

    private void addTargetFeatureAttributePredicate() {
        this.getTargetContainerSelector().getTargetFeaturePredicates().add(MutationPredicates.IS_MUTABLE_ATTRIBUTE);
    }

    private void addAttributeTypeNotFeatureMapPredicate() {
        this.getTargetContainerSelector().getTargetFeaturePredicates().add((Predicate<? super EStructuralFeature>)Predicates.not(MutationPredicates.HAS_FEATURE_MAP_ENTRY_TYPE));
    }

    private void addAttributeTypeNotEEnumeratorPredicate() {
        this.getTargetContainerSelector().getTargetFeaturePredicates().add((Predicate<? super EStructuralFeature>)Predicates.not((Predicate)new Predicate<EStructuralFeature>(){

            public boolean apply(EStructuralFeature input) {
                return input != null && EcorePackage.eINSTANCE.getEEnumerator().equals(input.getEType());
            }
        }));
    }

    @Override
    public Mutation clone() {
        return new AttributeChangeMutation(this.getUtil(), this.getTargetContainerSelector());
    }

    @Override
    public void apply() throws ESMutationException {
        switch (this.getRandomChangeMode()) {
            case ADD: {
                this.doAddAttributeValue();
                break;
            }
            case DELETE: {
                this.doDeleteAttributeValue();
                break;
            }
            case REORDER: {
                this.doReorderAttributeValue();
                break;
            }
        }
    }

    private boolean doAddAttributeValue() throws ESMutationException {
        this.getTargetContainerSelector().doSelection();
        EObject eObject = this.getTargetContainerSelector().getTargetObject();
        EAttribute eAttribute = (EAttribute)this.getTargetContainerSelector().getTargetFeature();
        Object newValue = this.createNewValue(eAttribute);
        if (newValue != null && eAttribute.isID() && !this.getUtil().getModelMutatorConfiguration().isAllowDuplicateIDs()) {
            while (!this.getUtil().isUniqueID(newValue)) {
                newValue = this.createNewValue(eAttribute);
            }
            this.getUtil().registerID(newValue);
        }
        if (eAttribute.isMany()) {
            int insertionIndex = this.getTargetContainerSelector().getRandomIndexFromTargetObjectAndFeatureValueRange();
            this.getUtil().setPerCommand(eObject, (EStructuralFeature)eAttribute, newValue, insertionIndex);
        } else {
            this.getUtil().setPerCommand(eObject, (EStructuralFeature)eAttribute, newValue);
        }
        return true;
    }

    private boolean doDeleteAttributeValue() throws ESMutationException {
        this.makeSureWeHaveAValueInSelectedObjectAtSelectedFeature();
        this.getTargetContainerSelector().doSelection();
        EObject eObject = this.getTargetContainerSelector().getTargetObject();
        EAttribute eAttribute = (EAttribute)this.getTargetContainerSelector().getTargetFeature();
        if (eAttribute.isMany()) {
            List currentValues = (List)eObject.eGet((EStructuralFeature)eAttribute);
            int deletionIndex = this.getTargetContainerSelector().getRandomIndexFromTargetObjectAndFeatureValueRange();
            currentValues.remove(deletionIndex);
            this.getUtil().setPerCommand(eObject, (EStructuralFeature)eAttribute, currentValues);
        } else {
            this.getUtil().setPerCommand(eObject, (EStructuralFeature)eAttribute, SetCommand.UNSET_VALUE);
        }
        return true;
    }

    private void makeSureWeHaveAValueInSelectedObjectAtSelectedFeature() {
        this.getTargetContainerSelector().getOriginalFeatureValuePredicates().add(MutationPredicates.IS_NON_EMPTY_VALUE_OR_LIST);
    }

    private boolean doReorderAttributeValue() throws ESMutationException {
        boolean success;
        this.makeSureAttributeIsMutliValued();
        this.makeSureWeHaveAValueInSelectedObjectAtSelectedFeature();
        this.getTargetContainerSelector().doSelection();
        EObject eObject = this.getTargetContainerSelector().getTargetObject();
        EAttribute eAttribute = (EAttribute)this.getTargetContainerSelector().getTargetFeature();
        if (eAttribute.isMany()) {
            List currentValues = (List)eObject.eGet((EStructuralFeature)eAttribute);
            int numberOfCurrentValues = currentValues.size();
            int pickIndex = this.getRandom().nextInt(numberOfCurrentValues);
            int putIndex = this.getRandom().nextInt(numberOfCurrentValues);
            this.getUtil().movePerCommand(eObject, (EStructuralFeature)eAttribute, currentValues.get(pickIndex), putIndex);
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    private void makeSureAttributeIsMutliValued() {
        this.getTargetContainerSelector().getTargetFeaturePredicates().add(MutationPredicates.IS_MULTI_VALUED);
    }

    protected Object createNewValue(EAttribute eAttribute) {
        if (this.newValue != null) {
            return this.newValue;
        }
        return this.getUtil().createNewAttribute(eAttribute);
    }

    protected ESRandomChangeMode getRandomChangeMode() {
        if (this.randomChangeMode != null) {
            return this.randomChangeMode;
        }
        ESRandomChangeMode[] values = ESRandomChangeMode.values();
        int nextInt = this.getRandom().nextInt(values.length);
        return values[nextInt];
    }

    @Override
    public ESAttributeChangeMutation setNewValue(Object newValue) {
        this.newValue = newValue;
        return this;
    }

    @Override
    public ESAttributeChangeMutation setRandomChangeMode(ESRandomChangeMode mode) {
        this.randomChangeMode = mode;
        return this;
    }
}

