/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.modelmutator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.emfstore.modelmutator.ESAbstractModelMutator;
import org.eclipse.emf.emfstore.modelmutator.ESModelMutatorConfiguration;
import org.eclipse.emf.emfstore.modelmutator.ESResourceSelectionStrategy;
import org.eclipse.emf.emfstore.modelmutator.ESRoundRobinResourceSelectionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESCrossResourceReferencesModelMutator
extends ESAbstractModelMutator {
    private static final String VIRTUAL_URI_BASE = "virtualUri";
    private int noOfResources = 2;
    private ResourceSet resourceSet;
    private final Set<Resource> resources = Sets.newLinkedHashSet();
    private ESResourceSelectionStrategy resourceSelectionStrategy = new ESRoundRobinResourceSelectionStrategy();

    private static URI createVirtualUri(String id) {
        return URI.createURI((String)(VIRTUAL_URI_BASE + id));
    }

    public ESCrossResourceReferencesModelMutator() {
    }

    public ESCrossResourceReferencesModelMutator(ESModelMutatorConfiguration config) {
        super(config);
    }

    public ESCrossResourceReferencesModelMutator(ESModelMutatorConfiguration config, int howManyResources) {
        super(config);
        this.noOfResources = howManyResources;
    }

    public ESCrossResourceReferencesModelMutator(ESModelMutatorConfiguration config, int howManyResources, ESResourceSelectionStrategy resourceSelectionStrategy) {
        super(config);
        this.noOfResources = howManyResources;
        this.resourceSelectionStrategy = resourceSelectionStrategy;
    }

    @Override
    public void preMutate() {
        this.resourceSet = this.createResourceSet(this.noOfResources);
        ((Resource)this.resourceSet.getResources().get(0)).getContents().add((Object)this.getRootEObject());
    }

    @Override
    protected void addToParent(EObject parent, EObject newObject, EReference reference) {
        super.addToParent(parent, newObject, reference);
        Resource selectedResource = this.selectResource(Lists.newArrayList(this.resources));
        if (!this.isMainResource(selectedResource)) {
            selectedResource.getContents().add((Object)newObject);
        }
    }

    private boolean isMainResource(Resource resource) {
        return resource == this.resourceSet.getResources().get(0);
    }

    private Resource selectResource(List<Resource> resources) {
        return this.resourceSelectionStrategy.selectResource(resources);
    }

    private ResourceSet createResourceSet(int howManyResources) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        int i = 0;
        while (i < howManyResources) {
            Resource resource = resourceSet.createResource(ESCrossResourceReferencesModelMutator.createVirtualUri(Integer.toString(i)));
            this.resources.add(resource);
            ++i;
        }
        return resourceSet;
    }

    @Override
    public void postMutate() {
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }
}

