/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.util.DecisionUtil;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.DecisionBox;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.util.UIDecisionUtil;
import org.eclipse.emf.emfstore.internal.client.ui.views.changes.ChangePackageVisualizationHelper;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DescriptionComponenptUtil {
    static final String COLON_COLON = "::";
    private static final String CLOSING_BRACKET = "\\]";
    private static final String OPENING_BRACKET = "\\[";

    private DescriptionComponenptUtil() {
    }

    static List<String> splitText(DecisionBox box, ConflictDescription conflict) {
        String description = conflict.getDescription();
        ChangePackageVisualizationHelper visualHelper = UIDecisionUtil.getChangePackageVisualizationHelper(box.getDecisionManager());
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = description.split(OPENING_BRACKET);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String[] split = string.split(CLOSING_BRACKET);
            if (split.length > 1) {
                Object obj = conflict.getValues().get(split[0]);
                String tmp = "";
                if (obj instanceof AbstractOperation) {
                    tmp = visualHelper.getDescription((AbstractOperation)obj);
                } else if (obj instanceof EObject) {
                    tmp = DecisionUtil.getModelElementName((EObject)((EObject)obj));
                } else if (obj != null) {
                    tmp = obj.toString();
                    tmp = UIDecisionUtil.cutString(tmp, 85, true);
                } else {
                    tmp = "";
                }
                tmp = UIDecisionUtil.stripNewLine(tmp);
                split[0] = COLON_COLON + tmp;
            }
            result.addAll(Arrays.asList(split));
            ++n2;
        }
        return result;
    }
}

