/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.AbstractConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.AdminConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc.XmlRpcClientManager;
import org.eclipse.emf.emfstore.internal.server.exceptions.ConnectionException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcAdminConnectionManager
extends AbstractConnectionManager<XmlRpcClientManager>
implements AdminConnectionManager {
    private static final String ASSIGN_ROLE = "assignRole";
    private static final String REMOVE_PARTICIPANT = "removeParticipant";
    private static final String REMOVE_MEMBER = "removeMember";
    private static final String REMOVE_GROUP = "removeGroup";
    private static final String GET_USERS = "getUsers";
    private static final String GET_ROLE = "getRole";
    private static final String GET_PROJECT_INFOS = "getProjectInfos";
    private static final String GET_PARTICIPANTS = "getParticipants";
    private static final String GET_ORG_UNITS = "getOrgUnits";
    private static final String GET_ORG_UNIT = "getOrgUnit";
    private static final String GET_MEMBERS = "getMembers";
    private static final String GET_GROUPS = "getGroups";
    private static final String DELETE_USER = "deleteUser";
    private static final String DELETE_GROUP = "deleteGroup";
    private static final String CREATE_USER = "createUser";
    private static final String CREATE_GROUP = "createGroup";
    private static final String CHANGE_ROLE = "changeRole";
    private static final String CHANGE_USER = "changeUser";
    private static final String CHANGE_ORG_UNIT = "changeOrgUnit";
    private static final String ADD_MEMBER = "addMember";
    private static final String ADD_PARTICIPANT = "addParticipant";
    private static final String ADD_INITIAL_PARTICIPANT = "addInitialParticipant";

    @Override
    public void initConnection(ServerInfo serverInfo, SessionId id) throws ConnectionException {
        XmlRpcClientManager clientManager = new XmlRpcClientManager("AdminEmfStore");
        clientManager.initConnection(serverInfo);
        this.addConnectionProxy(id, clientManager);
    }

    public void addMember(SessionId sessionId, ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call(ADD_MEMBER, sessionId, group, member);
    }

    public void addParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participant, EClass role) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call(ADD_PARTICIPANT, sessionId, projectId, participant, role);
    }

    public void changeOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId, String name, String description) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call(CHANGE_ORG_UNIT, sessionId, orgUnitId, name, description);
    }

    public void changeUser(SessionId sessionId, ACOrgUnitId userId, String name, String password) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call(CHANGE_USER, sessionId, userId, name, password);
    }

    public void changeRole(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnit, EClass role) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call(CHANGE_ROLE, sessionId, projectId, orgUnit, role);
    }

    public ACOrgUnitId createGroup(SessionId sessionId, String name) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult(CREATE_GROUP, ACOrgUnitId.class, sessionId, name);
    }

    public ACOrgUnitId createUser(SessionId sessionId, String name) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult(CREATE_USER, ACOrgUnitId.class, sessionId, name);
    }

    public void deleteGroup(SessionId sessionId, ACOrgUnitId group) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call(DELETE_GROUP, sessionId, group);
    }

    public void deleteUser(SessionId sessionId, ACOrgUnitId user) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call(DELETE_USER, sessionId, user);
    }

    public List<ACGroup> getGroups(SessionId sessionId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult(GET_GROUPS, ACGroup.class, sessionId);
    }

    public List<ACGroup> getGroups(SessionId sessionId, ACOrgUnitId user) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult(GET_GROUPS, ACGroup.class, sessionId, user);
    }

    public List<ACOrgUnit> getMembers(SessionId sessionId, ACOrgUnitId groupId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult(GET_MEMBERS, ACOrgUnit.class, sessionId, groupId);
    }

    public ACOrgUnit getOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult(GET_ORG_UNIT, ACOrgUnit.class, sessionId, orgUnitId);
    }

    public List<ACOrgUnit> getOrgUnits(SessionId sessionId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult(GET_ORG_UNITS, ACOrgUnit.class, sessionId);
    }

    public List<ACOrgUnit> getParticipants(SessionId sessionId, ProjectId projectId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult(GET_PARTICIPANTS, ACOrgUnit.class, sessionId, projectId);
    }

    public List<ProjectInfo> getProjectInfos(SessionId sessionId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult(GET_PROJECT_INFOS, ProjectInfo.class, sessionId);
    }

    public Role getRole(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnit) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult(GET_ROLE, Role.class, sessionId, projectId, orgUnit);
    }

    public List<ACUser> getUsers(SessionId sessionId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult(GET_USERS, ACUser.class, sessionId);
    }

    public void removeGroup(SessionId sessionId, ACOrgUnitId user, ACOrgUnitId group) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call(REMOVE_GROUP, sessionId, user, group);
    }

    public void removeMember(SessionId sessionId, ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call(REMOVE_MEMBER, sessionId, group, member);
    }

    public void removeParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participant) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call(REMOVE_PARTICIPANT, sessionId, projectId, participant);
    }

    public void assignRole(SessionId sessionId, ACOrgUnitId orgUnitId, EClass roleClass) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call(ASSIGN_ROLE, sessionId, orgUnitId, roleClass);
    }

    public void addInitialParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participantId, EClass roleClass) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call(ADD_INITIAL_PARTICIPANT, sessionId, projectId, participantId, roleClass);
    }
}

