/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.DefaultESAuthorizationService;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.DefaultESOrgUnitResolverService;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.LoginService;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.Messages;
import org.eclipse.emf.emfstore.internal.server.impl.api.ESOrgUnitProviderImpl;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.dao.ACDAOFacade;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESOrgUnitRepositoryImpl;
import org.eclipse.emf.emfstore.server.auth.ESAuthenticationControlType;
import org.eclipse.emf.emfstore.server.auth.ESAuthorizationService;
import org.eclipse.emf.emfstore.server.auth.ESOrgUnitResolver;
import org.eclipse.emf.emfstore.server.auth.ESSessions;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitProvider;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitRepository;

public class AccessControl {
    private static final String ORG_UNIT_RESOLVER_SERVICE_CLASS = "orgUnitResolverServiceClass";
    private static final String ORG_UNIT_PROVIDER_CLASS = "orgUnitProviderClass";
    private static final String AUTHORIZATION_SERVICE_CLASS = "authorizationServiceClass";
    private static final String ACCESSCONTROL_EXTENSION_ID = "org.eclipse.emf.emfstore.server.accessControl";
    private final ESOrgUnitProvider orgUnitProvider;
    private final ESAuthorizationService authorizationService;
    private final ESOrgUnitResolver orgUnitResolver;
    private final ESSessions sessions;
    private final LoginService loginService;
    private final ServerSpace serverSpace;
    private ESAuthenticationControlType authenticationControlType;

    public AccessControl(ServerSpace serverSpace) {
        this.serverSpace = serverSpace;
        this.sessions = new ESSessions();
        this.orgUnitProvider = this.initOrgUnitProviderService();
        this.orgUnitResolver = this.initOrgUnitResolverService();
        this.authorizationService = this.initAuthorizationService();
        this.loginService = this.initLoginService();
    }

    public AccessControl(ESAuthenticationControlType authenticationControlType, ServerSpace serverSpace) {
        this.authenticationControlType = authenticationControlType;
        this.serverSpace = serverSpace;
        this.sessions = new ESSessions();
        this.orgUnitProvider = this.initOrgUnitProviderService();
        this.orgUnitResolver = this.initOrgUnitResolverService();
        this.authorizationService = this.initAuthorizationService();
        this.loginService = this.initLoginService();
    }

    private LoginService initLoginService() {
        if (this.authenticationControlType == null) {
            String[] splittedProperty = ServerConfiguration.getSplittedProperty("emfstore.accesscontrol.authentication.policy");
            this.authenticationControlType = ESAuthenticationControlType.valueOf(splittedProperty[0]);
        }
        return new LoginService(this.authenticationControlType, this.sessions, this.orgUnitProvider, this.getOrgUnitResolverServive());
    }

    private ESAuthorizationService initAuthorizationService() {
        ESAuthorizationService authorizationService;
        block4: {
            try {
                List services = new ESExtensionPoint(ACCESSCONTROL_EXTENSION_ID, false).getClasses(AUTHORIZATION_SERVICE_CLASS, ESAuthorizationService.class);
                if (services.isEmpty()) {
                    authorizationService = new DefaultESAuthorizationService();
                    break block4;
                }
                if (services.size() == 1) {
                    authorizationService = (ESAuthorizationService)services.get(0);
                    break block4;
                }
                throw new IllegalStateException(MessageFormat.format(Messages.AccessControl_MultipleExtensionsDiscovered, "org.eclipse.emf.emfstore.server.accessControl.authorizationServiceClass"));
            }
            catch (ESExtensionPointException e) {
                String message = Messages.AccessControl_CustomAuthorizationInitFailed;
                ModelUtil.logException((String)message, (Throwable)e);
                authorizationService = new DefaultESAuthorizationService();
            }
        }
        authorizationService.init(this.sessions, this.getOrgUnitResolverServive(), this.orgUnitProvider);
        return authorizationService;
    }

    private ESOrgUnitResolver initOrgUnitResolverService() {
        ESOrgUnitResolver resolver;
        block4: {
            try {
                List resolvers = new ESExtensionPoint(ACCESSCONTROL_EXTENSION_ID, false).getClasses(ORG_UNIT_RESOLVER_SERVICE_CLASS, ESOrgUnitResolver.class);
                if (resolvers.isEmpty()) {
                    resolver = new DefaultESOrgUnitResolverService();
                    break block4;
                }
                if (resolvers.size() == 1) {
                    resolver = (ESOrgUnitResolver)resolvers.get(0);
                    break block4;
                }
                throw new IllegalStateException(MessageFormat.format(Messages.AccessControl_MultipleExtensionsDiscovered, "org.eclipse.emf.emfstore.server.accessControl.orgUnitResolverServiceClass"));
            }
            catch (ESExtensionPointException e) {
                ModelUtil.logException((String)"Custom org unit resolver class not be initialized", (Throwable)e);
                resolver = new DefaultESOrgUnitResolverService();
            }
        }
        resolver.init(this.orgUnitProvider);
        return resolver;
    }

    private ESOrgUnitProvider initOrgUnitProviderService() {
        ESOrgUnitProviderImpl orgUnitProvider;
        ESOrgUnitRepositoryImpl repository;
        block4: {
            repository = new ESOrgUnitRepositoryImpl((ACDAOFacade)this.serverSpace);
            try {
                List providers = new ESExtensionPoint(ACCESSCONTROL_EXTENSION_ID, false).getClasses(ORG_UNIT_PROVIDER_CLASS, ESOrgUnitProvider.class);
                if (providers.isEmpty()) {
                    orgUnitProvider = new ESOrgUnitProviderImpl((ESOrgUnitRepository)repository);
                    break block4;
                }
                if (providers.size() == 1) {
                    orgUnitProvider = (ESOrgUnitProvider)providers.get(0);
                    break block4;
                }
                throw new IllegalStateException(MessageFormat.format(Messages.AccessControl_MultipleExtensionsDiscovered, "org.eclipse.emf.emfstore.server.accessControl.orgUnitProviderClass"));
            }
            catch (ESExtensionPointException e) {
                String message = Messages.AccessControl_CustomOrgUnitProviderInitFailed;
                ModelUtil.logException((String)message, (Throwable)e);
                orgUnitProvider = new ESOrgUnitProviderImpl((ESOrgUnitRepository)repository);
            }
        }
        orgUnitProvider.init((ESOrgUnitRepository)repository);
        return orgUnitProvider;
    }

    public ESOrgUnitResolver getOrgUnitResolverServive() {
        return this.orgUnitResolver;
    }

    public ESOrgUnitProvider getOrgUnitProviderService() {
        return this.orgUnitProvider;
    }

    public ESAuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public ESSessions getSessions() {
        return this.sessions;
    }

    public LoginService getLoginService() {
        return this.loginService;
    }
}

