/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.exceptions.ESServerStartFailedException;
import org.eclipse.emf.emfstore.client.test.common.mocks.AdminConnectionManagerMock;
import org.eclipse.emf.emfstore.client.test.common.mocks.ConnectionMock;
import org.eclipse.emf.emfstore.client.test.common.mocks.DAOFacadeMock;
import org.eclipse.emf.emfstore.client.test.common.mocks.MockServerSpace;
import org.eclipse.emf.emfstore.client.test.common.mocks.ResourceFactoryMock;
import org.eclipse.emf.emfstore.client.test.common.mocks.ServerMock;
import org.eclipse.emf.emfstore.client.test.common.util.Messages;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.AdminConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.AdminBrokerImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.common.CommonUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.EMFStore;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AccessControl;
import org.eclipse.emf.emfstore.internal.server.core.EMFStoreImpl;
import org.eclipse.emf.emfstore.internal.server.exceptions.ConnectionException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.AccesscontrolFactory;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.RolesFactory;
import org.eclipse.emf.emfstore.internal.server.model.dao.ACDAOFacade;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESSessionIdImpl;
import org.eclipse.emf.emfstore.server.auth.ESAuthenticationControlType;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerUtil {
    private static final String ES_PROPERTIES_FILE = "es.properties";
    private static final String SUPER = "super";

    private ServerUtil() {
    }

    public static int defaultPort() {
        return 8080;
    }

    public static String localhost() {
        return "localhost";
    }

    public static String superUserPassword() {
        return SUPER;
    }

    public static String superUser() {
        return SUPER;
    }

    public static ESServer startServer() throws ESServerStartFailedException {
        ServerUtil.initServerSpace();
        CommonUtil.setTesting((boolean)true);
        ServerUtil.copyFileToWorkspace(ServerConfiguration.getConfFile(), ES_PROPERTIES_FILE, Messages.ServerUtil_Could_Not_Copy_Properties_File_To_Config_Folder, Messages.ServerUtil_Default_Properties_File_Copied_To_Config_Folder);
        ServerUtil.copyFileToWorkspace(ServerConfiguration.getServerKeyStorePath(), "emfstoreServer.keystore", Messages.ServerUtil_Failed_To_Copy_Keystore, Messages.ServerUtil_Keystore_Copied_To_Server_Workspace);
        return ESServer.FACTORY.createAndStartLocalServer();
    }

    public static void stopServer() {
        ESServer.FACTORY.stopLocalServer();
    }

    public static ServerMock startMockServer() throws IllegalArgumentException, ESServerStartFailedException, FatalESException {
        return ServerUtil.startMockServer(Collections.<String, String>emptyMap());
    }

    public static ServerMock startMockServer(Map<String, String> properties) throws ESServerStartFailedException, IllegalArgumentException, FatalESException {
        DAOFacadeMock daoFacadeMock = new DAOFacadeMock();
        ServerSpace serverSpace = ServerUtil.initServerSpace(daoFacadeMock);
        CommonUtil.setTesting((boolean)true);
        ServerUtil.copyFileToWorkspace(ServerConfiguration.getConfFile(), ES_PROPERTIES_FILE, Messages.ServerUtil_Could_Not_Copy_Properties_File_To_Config_Folder, Messages.ServerUtil_Default_Properties_File_Copied_To_Config_Folder);
        ServerUtil.copyFileToWorkspace(ServerConfiguration.getServerKeyStorePath(), "emfstoreServer.keystore", Messages.ServerUtil_Failed_To_Copy_Keystore, Messages.ServerUtil_Keystore_Copied_To_Server_Workspace);
        ServerConfiguration.setProperties((Properties)ServerUtil.initProperties(properties));
        ServerUtil.setSuperUser(daoFacadeMock);
        AccessControl accessControl = new AccessControl(ESAuthenticationControlType.model, serverSpace);
        EMFStore emfStore = EMFStoreImpl.createInterface((ServerSpace)serverSpace, (AccessControl)accessControl);
        ESWorkspaceProviderImpl.getInstance().setConnectionManager((ConnectionManager)new ConnectionMock(emfStore, accessControl));
        ESWorkspaceProviderImpl.getInstance().setAdminConnectionManager((AdminConnectionManager)new AdminConnectionManagerMock(daoFacadeMock, accessControl, serverSpace));
        ESServer createServer = ESServer.FACTORY.createServer("localhost", Integer.parseInt("8080"), "emfstore test certificate (do not use in production!)");
        return new ServerMock(createServer, emfStore, serverSpace);
    }

    public static void deleteUser(SessionId sessionId, ACOrgUnitId user) throws ESException {
        ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().deleteUser(sessionId, user);
    }

    public static boolean deleteGroup(ESUsersession session, String groupName) throws ESException {
        ESSessionIdImpl sessionId = (ESSessionIdImpl)ESSessionIdImpl.class.cast(session.getSessionId());
        List groups = ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().getGroups((SessionId)sessionId.toInternalAPI());
        ACOrgUnitId id = null;
        for (ACGroup acGroup : groups) {
            if (!acGroup.getName().equalsIgnoreCase(groupName)) continue;
            id = acGroup.getId();
            break;
        }
        if (id != null) {
            ESWorkspaceProviderImpl.getInstance().getAdminConnectionManager().deleteGroup((SessionId)sessionId.toInternalAPI(), id);
            return true;
        }
        return false;
    }

    public static ACOrgUnitId createUser(ESUsersession session, String name) throws ESException {
        ESUsersessionImpl sessionImpl = (ESUsersessionImpl)ESUsersessionImpl.class.cast(session);
        AdminBrokerImpl broker = ServerUtil.createAdminBroker(sessionImpl);
        return broker.createUser(name);
    }

    public static ACOrgUnitId createGroup(ESUsersession session, String name) throws ESException {
        ESUsersessionImpl sessionImpl = (ESUsersessionImpl)ESUsersessionImpl.class.cast(session);
        AdminBrokerImpl broker = ServerUtil.createAdminBroker(sessionImpl);
        return broker.createGroup(name);
    }

    public static void changePassword(ESUsersession session, ACOrgUnitId userId, String user, String password) throws ESException {
        ESUsersessionImpl sessionImpl = (ESUsersessionImpl)ESUsersessionImpl.class.cast(session);
        AdminBrokerImpl broker = ServerUtil.createAdminBroker(sessionImpl);
        broker.changeUser(userId, user, password);
    }

    public static void changeUser(ESUsersession session, ACOrgUnitId userId, String userName, String password) throws ESException {
        ESUsersessionImpl sessionImpl = (ESUsersessionImpl)ESUsersessionImpl.class.cast(session);
        AdminBrokerImpl broker = ServerUtil.createAdminBroker(sessionImpl);
        broker.changeUser(userId, userName, password);
    }

    public static ACUser getUser(ESUsersession session, String name) throws ESException {
        ESUsersessionImpl sessionImpl = (ESUsersessionImpl)ESUsersessionImpl.class.cast(session);
        AdminBrokerImpl broker = ServerUtil.createAdminBroker(sessionImpl);
        for (ACUser acUser : broker.getUsers()) {
            if (!acUser.getName().equals(name)) continue;
            return acUser;
        }
        return null;
    }

    public static ACGroup getGroup(ESUsersession session, String name) throws ESException {
        ESUsersessionImpl sessionImpl = (ESUsersessionImpl)ESUsersessionImpl.class.cast(session);
        AdminBrokerImpl broker = ServerUtil.createAdminBroker(sessionImpl);
        for (ACGroup group : broker.getGroups()) {
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return null;
    }

    public static ACUser getUser(ESUsersession session, ACOrgUnitId userId) throws ESException {
        ESUsersessionImpl sessionImpl = (ESUsersessionImpl)ESUsersessionImpl.class.cast(session);
        AdminBrokerImpl broker = ServerUtil.createAdminBroker(sessionImpl);
        for (ACUser acUser : broker.getUsers()) {
            if (!acUser.getId().getId().equals(userId.getId())) continue;
            return acUser;
        }
        return null;
    }

    private static AdminBrokerImpl createAdminBroker(ESUsersessionImpl sessionImpl) throws ConnectionException {
        return new AdminBrokerImpl(((Usersession)sessionImpl.toInternalAPI()).getServerInfo(), ((Usersession)sessionImpl.toInternalAPI()).getSessionId());
    }

    public static ACUser getParticipant(ESUsersession session, ProjectId projectId, ACOrgUnitId userId) throws ESException {
        ESUsersessionImpl sessionImpl = (ESUsersessionImpl)ESUsersessionImpl.class.cast(session);
        AdminBrokerImpl broker = ServerUtil.createAdminBroker(sessionImpl);
        for (ACOrgUnit acUser : broker.getParticipants(projectId)) {
            if (!acUser.getId().getId().equals(userId.getId()) || !(acUser instanceof ACUser)) continue;
            return (ACUser)acUser;
        }
        return null;
    }

    private static void setSuperUser(ACDAOFacade daoFacade) throws FatalESException {
        String superuser = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", SUPER);
        for (ACUser user : daoFacade.getUsers()) {
            if (!user.getName().equals(superuser)) continue;
            return;
        }
        ACUser superUser = AccesscontrolFactory.eINSTANCE.createACUser();
        superUser.setName(superuser);
        superUser.setFirstName(SUPER);
        superUser.setLastName("user");
        superUser.setDescription(Messages.ServerUtil_ServerAdmin_Description);
        superUser.getRoles().add((Object)RolesFactory.eINSTANCE.createServerAdmin());
        daoFacade.add(superUser);
        ModelUtil.logInfo((String)(String.valueOf(Messages.ServerUtil_Added_Superuser) + superuser));
    }

    public static Properties initProperties(Map<String, String> additionalProperties) {
        File propertyFile = new File(ServerConfiguration.getConfFile());
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(propertyFile);
                properties.load(fis);
                ServerConfiguration.setProperties((Properties)properties, (boolean)false);
                ModelUtil.logInfo((String)("Property file read. (" + propertyFile.getAbsolutePath() + ")"));
                for (Map.Entry<String, String> entry : additionalProperties.entrySet()) {
                    if (!StringUtils.isNotEmpty((String)entry.getValue())) continue;
                    properties.setProperty(entry.getKey(), entry.getValue());
                }
            }
            catch (IOException e) {
                ModelUtil.logWarning((String)Messages.ServerUtil_Property_Init_Failed, (Throwable)e);
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e2) {
                    ModelUtil.logWarning((String)Messages.ServerUtil_Could_Not_Close_File, (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                ModelUtil.logWarning((String)Messages.ServerUtil_Could_Not_Close_File, (Throwable)e);
            }
        }
        return properties;
    }

    private static void copyFileToWorkspace(String target, String source, String failure, String success) {
        File targetFile = new File(target);
        if (!targetFile.exists()) {
            String attribute;
            ESExtensionPoint extensionPoint = new ESExtensionPoint("org.eclipse.emf.emfstore.server.configurationResource");
            ESExtensionElement element = extensionPoint.getFirst();
            if (element != null && (attribute = element.getAttribute(targetFile.getName())) != null) {
                try {
                    FileUtil.copyFile((InputStream)new URL("platform:/plugin/" + element.getIConfigurationElement().getNamespaceIdentifier() + "/" + attribute).openConnection().getInputStream(), (File)targetFile);
                    return;
                }
                catch (IOException e) {
                    ModelUtil.logWarning((String)("Copy of file from " + source + " to " + target + " failed"), (Throwable)e);
                }
            }
            try {
                FileUtil.copyFile((InputStream)ServerUtil.getResource("testFiles/" + source), (File)targetFile);
            }
            catch (IOException e) {
                ModelUtil.logWarning((String)("Copy of file from " + source + " to " + target + " failed"), (Throwable)e);
            }
        }
    }

    private static InputStream getResource(String resource) throws IOException {
        URL configURL = FrameworkUtil.getBundle(ServerUtil.class).getEntry(resource);
        if (configURL != null) {
            InputStream input = configURL.openStream();
            return input;
        }
        return null;
    }

    private static ServerSpace initServerSpace() {
        ResourceSetImpl set = new ResourceSetImpl();
        set.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryMock());
        Resource resource = set.createResource(URI.createURI((String)""));
        ServerSpace serverSpace = ModelFactory.eINSTANCE.createServerSpace();
        resource.getContents().add((Object)serverSpace);
        return serverSpace;
    }

    private static ServerSpace initServerSpace(ACDAOFacade daoFacade) {
        ResourceSetImpl set = new ResourceSetImpl();
        set.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryMock());
        Resource resource = set.createResource(URI.createURI((String)""));
        MockServerSpace serverSpace = new MockServerSpace(daoFacade);
        resource.getContents().add((Object)serverSpace);
        return serverSpace;
    }
}

