/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.util;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.DecisionManager;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.util.UIDecisionConfig;
import org.eclipse.emf.emfstore.internal.client.ui.views.changes.ChangePackageVisualizationHelper;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public final class UIDecisionUtil {
    private static FontRegistry fontRegistry;

    private UIDecisionUtil() {
    }

    public static Image getImage(String path) {
        return UIDecisionUtil.getImageDescriptor(path).createImage();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        String key = path;
        ImageDescriptor regImage = JFaceResources.getImageRegistry().getDescriptor(key);
        if (regImage == null) {
            regImage = Activator.getImageDescriptor("icons/merge/" + path);
            JFaceResources.getImageRegistry().put(key, regImage);
        }
        return regImage;
    }

    public static String cutString(String str, int length, boolean addPoints) {
        if (str == null) {
            return "";
        }
        if (str.length() > length) {
            str = str.substring(0, length);
            if (addPoints) {
                str = String.valueOf(str) + "...";
            }
            return str;
        }
        return str;
    }

    public static String stripNewLine(String text) {
        if (text == null) {
            return "";
        }
        return text.replaceAll("\n\r|\r\n|\n \r|\r \n|\n|\r", " ");
    }

    public static synchronized FontRegistry getFontRegistry() {
        if (fontRegistry == null) {
            fontRegistry = new FontRegistry(Display.getCurrent());
            UIDecisionConfig.initFonts(fontRegistry);
        }
        return fontRegistry;
    }

    public static ChangePackageVisualizationHelper getChangePackageVisualizationHelper(DecisionManager decisionManager) {
        return new ChangePackageVisualizationHelper(decisionManager.getIdToEObjectMapping());
    }

    public static AdapterFactoryLabelProvider getAdapterFactory() {
        return new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
    }
}

