/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.handlers;

import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.ui.controller.UIAddTagController;
import org.eclipse.emf.emfstore.internal.client.ui.handlers.AbstractEMFStoreHandler;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.HistoryBrowserView;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.ESHistoryInfo;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AddTagHandler
extends AbstractEMFStoreHandler {
    public void handle() {
        HistoryInfo historyInfo = this.requireSelection(HistoryInfo.class);
        ESLocalProject localProject = this.getProjectFromHistoryView();
        ESHistoryInfo info = (ESHistoryInfo)historyInfo.toAPI();
        if (localProject == null || info == null) {
            return;
        }
        new UIAddTagController(this.getShell(), localProject, info).execute();
        this.getHistoryBrowserViewFromActivePart().refresh();
    }

    private ESLocalProject getProjectFromHistoryView() {
        HistoryBrowserView historyBrowserView = this.getHistoryBrowserViewFromActivePart();
        if (historyBrowserView == null) {
            return null;
        }
        return (ESLocalProject)historyBrowserView.getProjectSpace().toAPI();
    }

    private HistoryBrowserView getHistoryBrowserViewFromActivePart() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null || !(activePage.getActivePart() instanceof HistoryBrowserView)) {
            return null;
        }
        return (HistoryBrowserView)activePage.getActivePart();
    }
}

