/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.importexport.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.emfstore.internal.client.importexport.IExportImportController;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;

public class ImportProjectController
implements IExportImportController {
    private final String projectName;

    public ImportProjectController(String projectName) {
        this.projectName = projectName;
    }

    public String getLabel() {
        return "project";
    }

    public String[] getFilteredNames() {
        return new String[]{"EMFStore project space (*" + ExportImportDataUnits.Project.getExtension() + ")", "All Files (*.*)"};
    }

    public String[] getFilteredExtensions() {
        return new String[]{"*" + ExportImportDataUnits.Project.getExtension(), "*.*"};
    }

    public String getParentFolderPropertyKey() {
        return "org.eclipse.emf.emfstore.client.ui.importProjectPath";
    }

    public void execute(File file, IProgressMonitor progressMonitor) throws IOException {
        Workspace currentWorkspace = (Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI();
        ProjectSpace projectSpace = currentWorkspace.importProject(file.getAbsolutePath());
        projectSpace.setProjectName(this.projectName);
        ModelUtil.saveResource((Resource)projectSpace.eResource(), (IResourceLogger)WorkspaceUtil.getResourceLogger());
    }

    public String getFilename() {
        return null;
    }

    public boolean isExport() {
        return false;
    }
}

